/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.quantification.reporterion.Reagent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class ReporterMethod
implements Serializable {
    private HashMap<String, Reagent> reagents;
    private String name;
    private HashMap<String, ReporterIon> reporterIonsMap;

    public ReporterMethod(String name, ArrayList<Reagent> reagents) {
        this.name = name;
        this.reagents = new HashMap(reagents.size());
        this.reporterIonsMap = new HashMap(reagents.size());
        for (Reagent reagent : reagents) {
            String reagentName = reagent.getName();
            if (this.reagents.containsKey(reagentName)) {
                throw new IllegalArgumentException("Reagent name " + reagentName + " is duplicated in the reporter method " + name + ".");
            }
            this.reagents.put(reagent.getName(), reagent);
            ReporterIon reporterIon = reagent.getReporterIon();
            String reporterIonName = reporterIon.getName();
            if (this.reporterIonsMap.containsKey(reporterIonName)) {
                throw new IllegalArgumentException("Reporter ion name " + reporterIonName + " is duplicated in the reporter method " + name + ".");
            }
            this.reporterIonsMap.put(reporterIonName, reporterIon);
        }
    }

    public Set<String> getReporterIonNames() {
        return this.reporterIonsMap.keySet();
    }

    public ReporterIon getReporterIon(String reporterIonName) {
        return this.reporterIonsMap.get(reporterIonName);
    }

    public Set<String> getReagentNames() {
        return this.reagents.keySet();
    }

    public ArrayList<String> getReagentsSortedByMass() {
        ArrayList reagentNames;
        HashMap<Double, ArrayList> reagentsMap = new HashMap<Double, ArrayList>();
        for (String reagentName : this.reagents.keySet()) {
            double mass = this.reagents.get(reagentName).getReporterIon().getTheoreticMass();
            reagentNames = (ArrayList)reagentsMap.get(mass);
            if (reagentNames == null) {
                reagentNames = new ArrayList();
                reagentsMap.put(mass, reagentNames);
            }
            reagentNames.add(reagentName);
        }
        ArrayList masses = new ArrayList(reagentsMap.keySet());
        Collections.sort(masses);
        ArrayList<String> result = new ArrayList<String>();
        for (Double mass : masses) {
            reagentNames = (ArrayList)reagentsMap.get(mass);
            Collections.sort(reagentNames);
            result.addAll(reagentNames);
        }
        return result;
    }

    public Reagent getReagent(String reagentName) {
        return this.reagents.get(reagentName);
    }

    public String getName() {
        return this.name;
    }
}

