/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.SearchGuiOutputOption;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class UtilitiesUserPreferences
implements Serializable {
    static final long serialVersionUID = -4343570286224891504L;
    private static String USER_PREFERENCES_FILE = System.getProperty("user.home") + "/.compomics/userpreferences.cup";
    private Float spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
    private Float spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
    private Color spectrumAnnotatedPeakColor = Color.RED;
    private Color spectrumAnnotatedMirroredPeakColor = Color.BLUE;
    private Color spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
    private Color sparklineColorValidated = new Color(110, 196, 97);
    private Color sparklineColorNonValidated = new Color(208, 19, 19);
    private Color sparklineColorNotFound = new Color(222, 222, 222);
    private Color sparklineColorPossible = new Color(100, 150, 255);
    private Color sparklineColorDoubtful = new Color(255, 204, 0);
    private Color sparklineColorFalsePositive = new Color(255, 51, 51);
    private Color peptideSelected = new Color(0, 0, 255);
    private Integer memoryPreference = 4096;
    private String javaHome = null;
    private File proteinTreeFolder = null;
    private HashMap<Long, ArrayList<Long>> proteinTreeImportTime;
    private String proteoWizardPath = null;
    private String searchGuiPath = null;
    private String peptideShakerPath = null;
    private String deNovoGuiPath = null;
    private String reporterPath = null;
    private String relimsPath = null;
    private String localPrideFolder = "user.home";
    private File dbFolder = null;
    private File proteinSequencesManagerFolder = null;
    private ArrayList<File> favoriteDBs = null;
    private ArrayList<String> readTweets = null;
    private ArrayList<String> displayedTips = null;
    private Boolean autoUpdate = true;
    private Boolean notifyStart = true;
    private LastSelectedFolder lastSelectedFolder;
    private Boolean sortPsmsOnRt = false;
    private String targetDecoyFileNameTag = "_concatenated_target_decoy";
    private Boolean checkPeakPicking = true;
    private Boolean checkDuplicateTitles = true;
    private Boolean checkMgfSize = false;
    private Double mgfMaxSize = 1000.0;
    private Integer mgfNSpectra = 25000;
    private Double refMass = 2000.0;
    private Boolean generateProteinTree = false;
    private SearchGuiOutputOption outputOption = SearchGuiOutputOption.grouped;
    private Boolean outputData = false;
    private Boolean includeDateInOutputName = false;
    private Boolean renameXTandemFile = true;
    private Boolean checkSpectrumCharges = true;
    private Integer minSpectrumChargeRange = 2;
    private Integer maxSpectrumChargeRange = 4;

    public Color getSparklineColor() {
        return this.sparklineColorValidated;
    }

    public void setSparklineColor(Color sparklineColorValidated) {
        this.sparklineColorValidated = sparklineColorValidated;
    }

    public Color getSparklineColorNonValidated() {
        if (this.sparklineColorNonValidated == null) {
            this.sparklineColorNonValidated = new Color(255, 0, 0);
        }
        return this.sparklineColorNonValidated;
    }

    public Color getPeptideSelected() {
        if (this.peptideSelected == null) {
            this.peptideSelected = new Color(0, 0, 255);
        }
        return this.peptideSelected;
    }

    public Color getSparklineColorNotFound() {
        if (this.sparklineColorNotFound == null) {
            this.sparklineColorNotFound = new Color(222, 222, 222);
        }
        return this.sparklineColorNotFound;
    }

    public void setSparklineColorNonValidated(Color sparklineColorNonValidated) {
        this.sparklineColorNonValidated = sparklineColorNonValidated;
    }

    public Color getSparklineColorPossible() {
        if (this.sparklineColorPossible == null) {
            this.sparklineColorPossible = new Color(235, 235, 235);
        }
        return this.sparklineColorPossible;
    }

    public void setSparklineColorPossible(Color sparklineColorPossible) {
        this.sparklineColorPossible = sparklineColorPossible;
    }

    public Color getSparklineColorDoubtful() {
        if (this.sparklineColorDoubtful == null) {
            this.sparklineColorDoubtful = new Color(255, 204, 0);
        }
        return this.sparklineColorDoubtful;
    }

    public void setSparklineColorDoubtful(Color sparklineColorDoubtful) {
        this.sparklineColorDoubtful = sparklineColorDoubtful;
    }

    public Color getSparklineColorFalsePositives() {
        if (this.sparklineColorFalsePositive == null) {
            this.sparklineColorFalsePositive = new Color(255, 51, 51);
        }
        return this.sparklineColorFalsePositive;
    }

    public void setSparklineColorFalsePositives(Color sparklineColorFalsePositive) {
        this.sparklineColorFalsePositive = sparklineColorFalsePositive;
    }

    public Integer getMemoryPreference() {
        return this.memoryPreference;
    }

    public void setMemoryPreference(int memoryPreference) {
        this.memoryPreference = memoryPreference;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public Color getSpectrumAnnotatedPeakColor() {
        if (this.spectrumAnnotatedPeakColor == null) {
            this.spectrumAnnotatedPeakColor = Color.RED;
        }
        return this.spectrumAnnotatedPeakColor;
    }

    public void setSpectrumAnnotatedPeakColor(Color spectrumAnnotatedPeakColor) {
        this.spectrumAnnotatedPeakColor = spectrumAnnotatedPeakColor;
    }

    public Color getSpectrumAnnotatedMirroredPeakColor() {
        if (this.spectrumAnnotatedMirroredPeakColor == null) {
            this.spectrumAnnotatedMirroredPeakColor = Color.BLUE;
        }
        return this.spectrumAnnotatedMirroredPeakColor;
    }

    public void setSpectrumAnnotatedMirroredPeakColor(Color spectrumAnnotatedMirroredPeakColor) {
        this.spectrumAnnotatedMirroredPeakColor = spectrumAnnotatedMirroredPeakColor;
    }

    public Color getSpectrumBackgroundPeakColor() {
        if (this.spectrumBackgroundPeakColor == null) {
            this.spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
        }
        return this.spectrumBackgroundPeakColor;
    }

    public void setSpectrumBackgroundPeakColor(Color spectrumBackgroundPeakColor) {
        this.spectrumBackgroundPeakColor = spectrumBackgroundPeakColor;
    }

    public Float getSpectrumAnnotatedPeakWidth() {
        if (this.spectrumAnnotatedPeakWidth == null) {
            this.spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumAnnotatedPeakWidth;
    }

    public void setSpectrumAnnotatedPeakWidth(float spectrumAnnotatedPeakWidth) {
        this.spectrumAnnotatedPeakWidth = Float.valueOf(spectrumAnnotatedPeakWidth);
    }

    public Float getSpectrumBackgroundPeakWidth() {
        if (this.spectrumBackgroundPeakWidth == null) {
            this.spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumBackgroundPeakWidth;
    }

    public void setSpectrumBackgroundPeakWidth(float spectrumBackgroundPeakWidth) {
        this.spectrumBackgroundPeakWidth = Float.valueOf(spectrumBackgroundPeakWidth);
    }

    public String getSearchGuiPath() {
        return this.searchGuiPath;
    }

    public void setSearchGuiPath(String searchGuiPath) {
        this.searchGuiPath = searchGuiPath;
    }

    public String getDeNovoGuiPath() {
        return this.deNovoGuiPath;
    }

    public void setDeNovoGuiPath(String deNovoGuiPath) {
        this.deNovoGuiPath = deNovoGuiPath;
    }

    public String getProteoWizardPath() {
        return this.proteoWizardPath;
    }

    public void setProteoWizardPath(String proteoWizardPath) {
        this.proteoWizardPath = proteoWizardPath;
    }

    public String getRelimsPath() {
        return this.relimsPath;
    }

    public void setRelimsPath(String relimsPath) {
        this.relimsPath = relimsPath;
    }

    public String getPeptideShakerPath() {
        return this.peptideShakerPath;
    }

    public void setPeptideShakerPath(String peptideShakerPath) {
        this.peptideShakerPath = peptideShakerPath;
    }

    public String getReporterPath() {
        return this.reporterPath;
    }

    public void setReporterPath(String reporterPath) {
        this.reporterPath = reporterPath;
    }

    public static void saveUserPreferences(UtilitiesUserPreferences userPreferences) {
        try {
            File file = new File(USER_PREFERENCES_FILE);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            SerializationUtils.writeObject(userPreferences, file);
        }
        catch (Exception e) {
            System.err.println("An error occurred while saving " + USER_PREFERENCES_FILE + " (see below).");
            e.printStackTrace();
        }
    }

    public static UtilitiesUserPreferences loadUserPreferences() {
        UtilitiesUserPreferences userPreferences;
        File file = new File(USER_PREFERENCES_FILE);
        if (!file.exists()) {
            userPreferences = new UtilitiesUserPreferences();
            UtilitiesUserPreferences.saveUserPreferences(userPreferences);
        } else {
            try {
                userPreferences = (UtilitiesUserPreferences)SerializationUtils.readObject(file);
            }
            catch (Exception e) {
                System.err.println("An error occurred while loading " + USER_PREFERENCES_FILE + " (see below). Preferences set back to default.");
                e.printStackTrace();
                userPreferences = new UtilitiesUserPreferences();
                UtilitiesUserPreferences.saveUserPreferences(userPreferences);
            }
        }
        return userPreferences;
    }

    public String getLocalPrideFolder() {
        return this.localPrideFolder;
    }

    public void setLocalPrideFolder(String localPrideFolder) {
        this.localPrideFolder = localPrideFolder;
    }

    public File getDbFolder() {
        return this.dbFolder;
    }

    public void setDbFolder(File dbFolder) {
        this.dbFolder = dbFolder;
    }

    public File getProteinSequencesManagerFolder() {
        if (this.proteinSequencesManagerFolder == null) {
            this.proteinSequencesManagerFolder = new File(System.getProperty("user.home") + "/.compomics/proteins/sequences/");
            if (!this.proteinSequencesManagerFolder.exists()) {
                this.proteinSequencesManagerFolder.mkdirs();
            }
        }
        return this.proteinSequencesManagerFolder;
    }

    public void setProteinSequencesManagerFolder(File proteinSequencesManagerFolder) {
        this.proteinSequencesManagerFolder = proteinSequencesManagerFolder;
    }

    public ArrayList<File> getFavoriteDBs() {
        this.checkDbFiles();
        return this.favoriteDBs;
    }

    public void checkDbFiles() {
        ArrayList<File> checkedFiles = new ArrayList<File>();
        for (File dbFile : this.favoriteDBs) {
            if (!dbFile.exists()) continue;
            checkedFiles.add(dbFile);
        }
        this.favoriteDBs = checkedFiles;
    }

    public void addFavoriteDB(File dbFile) {
        if (this.favoriteDBs == null) {
            this.favoriteDBs = new ArrayList();
        }
        this.favoriteDBs.add(0, dbFile);
    }

    public File getProteinTreeFolder() {
        if (this.proteinTreeFolder == null) {
            this.proteinTreeFolder = new File(ProteinTreeComponentsFactory.getDefaultDbFolderPath());
        }
        return this.proteinTreeFolder;
    }

    public void setProteinTreeFolder(File proteinTreeFolder) {
        this.proteinTreeFolder = proteinTreeFolder;
    }

    public HashMap<Long, ArrayList<Long>> getProteinTreeImportTime() {
        if (this.proteinTreeImportTime == null) {
            this.proteinTreeImportTime = new HashMap();
        }
        return this.proteinTreeImportTime;
    }

    public void addProteinTreeImportTime(long fileSize, long importTime) {
        ArrayList<Long> importTimes = this.getProteinTreeImportTime().get(fileSize);
        if (importTimes == null) {
            importTimes = new ArrayList();
            this.proteinTreeImportTime.put(fileSize, importTimes);
        }
        importTimes.add(importTime);
    }

    public void clearProteinTreeImportTimes() {
        if (this.proteinTreeImportTime != null) {
            this.proteinTreeImportTime.clear();
        }
    }

    public ArrayList<String> getReadTweets() {
        if (this.readTweets == null) {
            this.readTweets = new ArrayList();
        }
        return this.readTweets;
    }

    public void setReadTweets(ArrayList<String> readTweets) {
        this.readTweets = readTweets;
    }

    public ArrayList<String> getDisplayedTips() {
        if (this.displayedTips == null) {
            this.displayedTips = new ArrayList();
        }
        return this.displayedTips;
    }

    public void setDisplayedTips(ArrayList<String> displayedTips) {
        this.displayedTips = displayedTips;
    }

    public static String getUserPreferencesFile() {
        return USER_PREFERENCES_FILE;
    }

    public static String getUserPreferencesFolder() {
        File tempFile = new File(UtilitiesUserPreferences.getUserPreferencesFile());
        return tempFile.getParent();
    }

    public static void setUserPreferencesFolder(String userPreferencesFolder) {
        File tempFile = new File(userPreferencesFolder, "/utilities_userpreferences.cup");
        USER_PREFERENCES_FILE = tempFile.getAbsolutePath();
    }

    public Boolean isAutoUpdate() {
        if (this.autoUpdate == null) {
            this.autoUpdate = true;
        }
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public Boolean isNotifyStart() {
        if (this.notifyStart == null) {
            this.notifyStart = true;
        }
        return this.notifyStart;
    }

    public void setNotifyStart(Boolean notifyStart) {
        this.notifyStart = notifyStart;
    }

    public LastSelectedFolder getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
        }
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    public Boolean getSortPsmsOnRt() {
        if (this.sortPsmsOnRt == null) {
            this.sortPsmsOnRt = false;
        }
        return this.sortPsmsOnRt;
    }

    public void setSortPsmsOnRt(Boolean sortPsmsOnRt) {
        this.sortPsmsOnRt = sortPsmsOnRt;
    }

    public String getTargetDecoyFileNameSuffix() {
        if (this.targetDecoyFileNameTag == null) {
            this.targetDecoyFileNameTag = "_concatenated_target_decoy";
        }
        return this.targetDecoyFileNameTag;
    }

    public void setTargetDecoyFileNameSuffix(String targetDecoyFileNameSuffix) {
        this.targetDecoyFileNameTag = targetDecoyFileNameSuffix;
    }

    public Boolean checkPeakPicking() {
        if (this.checkPeakPicking == null) {
            this.checkPeakPicking = true;
        }
        return this.checkPeakPicking;
    }

    public void setCheckPeakPicking(boolean checkPeakPicking) {
        this.checkPeakPicking = checkPeakPicking;
    }

    public Boolean checkDuplicateTitles() {
        if (this.checkDuplicateTitles == null) {
            this.checkDuplicateTitles = true;
        }
        return this.checkDuplicateTitles;
    }

    public void setCheckDuplicateTitles(boolean checkDuplicateTitles) {
        this.checkDuplicateTitles = checkDuplicateTitles;
    }

    public Boolean checkMgfSize() {
        if (this.checkMgfSize == null) {
            this.checkMgfSize = false;
        }
        return this.checkMgfSize;
    }

    public void setCheckMgfSize(boolean checkMgfSize) {
        this.checkMgfSize = checkMgfSize;
    }

    public double getMgfMaxSize() {
        if (this.mgfMaxSize == null) {
            this.mgfMaxSize = 1000.0;
        }
        return this.mgfMaxSize;
    }

    public void setMgfMaxSize(double mgfMaxSize) {
        this.mgfMaxSize = mgfMaxSize;
    }

    public int getMgfNSpectra() {
        if (this.mgfNSpectra == null) {
            this.mgfNSpectra = 25000;
        }
        return this.mgfNSpectra;
    }

    public void setMgfNSpectra(int mgfNSpectra) {
        this.mgfNSpectra = mgfNSpectra;
    }

    public Double getRefMass() {
        if (this.refMass == null) {
            this.refMass = 2000.0;
        }
        return this.refMass;
    }

    public void setRefMass(Double refMass) {
        this.refMass = refMass;
    }

    public Boolean generateProteinTree() {
        if (this.generateProteinTree == null) {
            this.generateProteinTree = false;
        }
        return this.generateProteinTree;
    }

    public void setGenerateProteinTree(Boolean generateProteinTree) {
        this.generateProteinTree = generateProteinTree;
    }

    public void setOutputOption(SearchGuiOutputOption outputOption) {
        this.outputOption = outputOption;
    }

    public SearchGuiOutputOption getOutputOption() {
        if (this.outputOption == null) {
            this.outputOption = SearchGuiOutputOption.grouped;
        }
        return this.outputOption;
    }

    public Boolean outputData() {
        if (this.outputData == null) {
            this.outputData = false;
        }
        return this.outputData;
    }

    public void setOutputData(Boolean outputData) {
        this.outputData = outputData;
    }

    public Boolean isIncludeDateInOutputName() {
        if (this.includeDateInOutputName == null) {
            this.includeDateInOutputName = false;
        }
        return this.includeDateInOutputName;
    }

    public void setIncludeDateInOutputName(Boolean includeDateInOutputName) {
        this.includeDateInOutputName = includeDateInOutputName;
    }

    public Boolean renameXTandemFile() {
        if (this.renameXTandemFile == null) {
            this.renameXTandemFile = true;
        }
        return this.renameXTandemFile;
    }

    public void setRenameXTandemFile(Boolean renameXTandemFile) {
        this.renameXTandemFile = renameXTandemFile;
    }

    public Boolean isCheckSpectrumCharges() {
        if (this.checkSpectrumCharges == null) {
            this.checkSpectrumCharges = true;
        }
        return this.checkSpectrumCharges;
    }

    public void setCheckSpectrumCharges(Boolean checkSpectrumCharges) {
        this.checkSpectrumCharges = checkSpectrumCharges;
    }

    public Integer getMinSpectrumChargeRange() {
        if (this.minSpectrumChargeRange == null) {
            this.minSpectrumChargeRange = 2;
        }
        return this.minSpectrumChargeRange;
    }

    public void setMinSpectrumChargeRange(Integer minSpectrumChargeRange) {
        this.minSpectrumChargeRange = minSpectrumChargeRange;
    }

    public Integer getMaxSpectrumChargeRange() {
        if (this.maxSpectrumChargeRange == null) {
            this.maxSpectrumChargeRange = 4;
        }
        return this.maxSpectrumChargeRange;
    }

    public void setMaxSpectrumChargeRange(Integer maxSpectrumChargeRange) {
        this.maxSpectrumChargeRange = maxSpectrumChargeRange;
    }
}

