/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RegExEnzyme
extends Enzyme {
    Logger logger = Logger.getLogger(RegExEnzyme.class);
    private Pattern iCleavagePattern = null;

    public RegExEnzyme(String aTitle, String aCleavage, String aRestrict, String aPosition) {
        this(aTitle, aCleavage, aRestrict, aPosition, 1);
    }

    public RegExEnzyme(String aTitle, String aCleavage, String aRestrict, String aPosition, int aMiscleavages) {
        super(aTitle, "", aRestrict, aPosition, aMiscleavages);
        this.setCleavage(aCleavage);
        this.setRestrict(aRestrict);
    }

    @Override
    public void setCleavage(String aCleavage) {
        this.iCleavagePattern = Pattern.compile(aCleavage, 2);
    }

    @Override
    public void setCleavage(char[] aCleavage) {
        this.setCleavage(new String(aCleavage));
    }

    @Override
    public char[] getCleavage() {
        return this.iCleavagePattern.pattern().toCharArray();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String aPrepend) {
        StringBuffer result = new StringBuffer("\n" + aPrepend + "Hi, I'm the RegExEnzyme '" + this.getTitle() + "'.\n");
        result.append(aPrepend).append("I cleave at the match to the regular expression: ");
        result.append(this.iCleavagePattern.pattern()).append("\n");
        if (this.getRestrict() != null && this.getRestrict().length > 0) {
            result.append(aPrepend).append("My activity is restricted by these residus: '");
            result.append(new String(this.getRestrict())).append("'.\n");
        } else {
            result.append(aPrepend).append("There are no residus that restrict my activity.\n");
        }
        result.append(aPrepend).append("My position is '");
        result.append(this.getPosition() == 0 ? "C-terminal" : "N-terminal").append("'.\n");
        result.append(aPrepend).append("I currently allow ");
        result.append(this.getMiscleavages() == 0 ? "no" : "up to " + this.getMiscleavages());
        result.append(" missed cleavage").append(this.getMiscleavages() == 1 ? "" : "s").append(".\n");
        return result.toString();
    }

    @Override
    public Object clone() {
        RegExEnzyme ree = (RegExEnzyme)super.clone();
        if (ree != null) {
            ree.iCleavagePattern = this.iCleavagePattern;
        }
        return ree;
    }

    @Override
    public int isEnzymaticProduct(String aParentSequence, String aSubSequence) {
        int start = aParentSequence.indexOf(aSubSequence);
        if (start < 0) {
            throw new IllegalArgumentException("Subsequence is not a subsequence of the parent!");
        }
        int end = start + aSubSequence.length();
        return this.isEnzymaticProduct(aParentSequence, start + 1, end);
    }

    @Override
    public int isEnzymaticProduct(String aParentSequence, int aStart, int aEnd) {
        if (aStart - 1 < 0 || aEnd - 1 < 0) {
            throw new IllegalArgumentException("Subsequence is not a subsequence of the parent!");
        }
        if (aEnd - 1 > aParentSequence.length() - 1) {
            throw new IllegalArgumentException("Subsequence end index out of parent length range (" + aEnd + ">" + (aParentSequence.length() - 1) + ")!");
        }
        if (aStart > aEnd) {
            throw new IllegalArgumentException("Subsequence could not be retreived since start index is greater than end index (" + aStart + ">=" + aEnd + ")!");
        }
        Matcher matcher = this.iCleavagePattern.matcher(aParentSequence);
        int end = 0;
        ArrayList<Integer> ends = new ArrayList<Integer>();
        while (matcher.find() && end <= aEnd) {
            int tmp = matcher.end();
            if (tmp < aParentSequence.length() && this.iRestrictors.containsKey(Character.valueOf(aParentSequence.charAt(tmp)))) continue;
            if (this.iPosition == 0) {
                end = tmp;
            } else if (this.iPosition == 1) {
                end = tmp - 1;
            } else {
                throw new IllegalStateException("Cleavage position is not specified correctly! Can not determine if the proviced peptide is a valid enzymatic product!");
            }
            ends.add(end);
        }
        int result = ends.contains(aStart - 1) || aStart == 1 ? (ends.contains(aEnd) ? 1 : 2) : (ends.contains(aEnd) || aEnd == aParentSequence.length() ? 3 : 4);
        return result;
    }

    @Override
    public Protein[] cleave(Protein aProtein) {
        ArrayList peptides = new ArrayList();
        ArrayList startIndices = new ArrayList();
        ArrayList endIndices = new ArrayList();
        this.cleave(aProtein, peptides, startIndices, endIndices);
        this.handleTruncations(aProtein, peptides, startIndices, endIndices);
        this.addMisCleaved(peptides, startIndices, endIndices);
        this.removeStopCodonPeptides(peptides, startIndices, endIndices);
        Header header = aProtein.getHeader();
        Protein[] result = new Protein[peptides.size()];
        Iterator iterator = peptides.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String peptide = (String)iterator.next();
            Header h = (Header)header.clone();
            h.setLocation((Integer)startIndices.get(i) + 1, (Integer)endIndices.get(i));
            result[i] = new Protein(h, new AASequenceImpl(peptide));
            ++i;
        }
        return result;
    }

    private void removeStopCodonPeptides(List peptides, List startIndices, List endIndices) {
        Iterator pepIter = peptides.iterator();
        Iterator startIter = startIndices.iterator();
        Iterator endIter = endIndices.iterator();
        while (pepIter.hasNext()) {
            String peptide = (String)pepIter.next();
            startIter.next();
            endIter.next();
            if (peptide.indexOf("_") < 0) continue;
            pepIter.remove();
            startIter.remove();
            endIter.remove();
        }
    }

    private void cleave(Protein aProtein, List peptides, List startIndices, List endIndices) {
        String sequence = aProtein.getSequence().getSequence();
        int headerStart = aProtein.getHeader().getStartLocation() - 1;
        if (headerStart < 0) {
            headerStart = 0;
        }
        int startPos = 0;
        Matcher matcher = this.iCleavagePattern.matcher(sequence);
        while (matcher.find()) {
            String pep;
            int currEnd = matcher.end();
            if (currEnd >= sequence.length()) continue;
            char after = sequence.charAt(currEnd);
            if (this.iRestrict != null && Arrays.binarySearch(this.iRestrict, after) >= 0) continue;
            if (this.iPosition == 0) {
                pep = sequence.substring(startPos, currEnd);
                peptides.add(pep);
                startIndices.add(headerStart + startPos);
                endIndices.add(headerStart + startPos + pep.length());
                startPos = currEnd;
                continue;
            }
            if (this.iPosition == 1) {
                pep = sequence.substring(startPos, currEnd - 1);
                peptides.add(pep);
                startIndices.add(headerStart + startPos);
                endIndices.add(headerStart + startPos + pep.length());
                startPos = currEnd - 1;
                continue;
            }
            throw new IllegalStateException("Illegal position (neiter c terminal nor n terminal) while trying to cleave!");
        }
        String lastPep = sequence.substring(startPos, sequence.length());
        peptides.add(lastPep);
        startIndices.add(headerStart + startPos);
        endIndices.add(headerStart + startPos + lastPep.length());
    }

    private void handleTruncations(Protein aProtein, List peptides, List startIndices, List endIndices) {
        if (aProtein.isTruncated()) {
            if (aProtein.getTruncationPosition() == 2) {
                peptides.remove(0);
                startIndices.remove(0);
                endIndices.remove(0);
            } else if (aProtein.getTruncationPosition() == 1) {
                int last = peptides.size() - 1;
                peptides.remove(last);
                startIndices.remove(last);
                endIndices.remove(last);
            } else {
                throw new IllegalArgumentException("Truncation position is expected to be either 'Protein.CTERMTRUNC' or 'Protein.NTERMTRUNC'! Protein: " + aProtein.getHeader().getFullHeaderWithAddenda());
            }
        }
    }

    private void addMisCleaved(List peptides, List startIndices, List endIndices) {
        String[] imSequences = peptides.toArray(new String[peptides.size()]);
        for (int j = 0; j < imSequences.length; ++j) {
            String temp = imSequences[j];
            for (int k = 0; k < this.iMiscleavages && j + k + 1 < imSequences.length; ++k) {
                temp = temp + imSequences[j + k + 1];
                peptides.add(temp);
                startIndices.add(startIndices.get(j));
                endIndices.add(endIndices.get(j + k + 1));
            }
        }
    }
}

