/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy;

import com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy.UniprotTaxonomyProvider;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TaxonomyTreePanel
extends JPanel {
    private final UniprotTaxonomyProvider query;
    private JButton btnSearch;
    private JTree taxonomyTree;
    private JScrollPane taxonomyTreeScrollPane;
    private JTextField tfSearchField;

    public TaxonomyTreePanel() {
        this.initComponents();
        this.query = new UniprotTaxonomyProvider((DefaultTreeModel)this.taxonomyTree.getModel());
        this.taxonomyTree.setExpandsSelectedPaths(true);
    }

    public void buildTreeFromTabFile(File tabFile) throws IOException, InterruptedException {
        this.taxonomyTree.setModel(this.query.getModelFromFile(tabFile));
        this.expandAll();
    }

    public void buildTreeAfterSearch(String taxonomyName) throws IOException, InterruptedException, MalformedURLException, URISyntaxException {
        String taxonomyID = this.query.getCachedTaxonomyID(taxonomyName);
        if (taxonomyID == null) {
            taxonomyID = taxonomyName;
        }
        try {
            DefaultTreeModel modelAfterSearch = this.query.getModelAfterSearch(taxonomyID);
            this.taxonomyTree.setModel(modelAfterSearch);
            this.expandAll();
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Query overflow", 2);
        }
    }

    public void buildTreeAfterClick(String taxonomyName) throws IOException {
        String taxonomyID = taxonomyName;
        if (taxonomyID == null) {
            taxonomyID = taxonomyName;
        }
        TreePath[] selectionPaths = this.taxonomyTree.getSelectionPaths();
        this.taxonomyTree.setModel(this.query.getModelAfterClick(taxonomyID));
        this.taxonomyTree.setSelectionPaths(selectionPaths);
    }

    public HashMap<String, String> getSelectedTaxonomyMap() {
        HashMap<String, String> taxIDMap = new HashMap<String, String>();
        if (this.taxonomyTree.getSelectionPaths().length > 0) {
            for (TreePath path : this.taxonomyTree.getSelectionPaths()) {
                String taxonomyName = ((DefaultMutableTreeNode)path.getLastPathComponent()).toString();
                taxIDMap.put(this.query.getCachedTaxonomyID(taxonomyName), taxonomyName);
            }
        }
        return taxIDMap;
    }

    public JTree getTaxonomyTree() {
        return this.taxonomyTree;
    }

    public void expandAll() {
        for (int i = 0; i < this.taxonomyTree.getRowCount(); ++i) {
            this.taxonomyTree.expandRow(i);
        }
    }

    public void collapseAll() {
        for (int i = 0; i < this.taxonomyTree.getRowCount(); ++i) {
            this.taxonomyTree.collapseRow(i);
        }
    }

    private void initComponents() {
        this.taxonomyTreeScrollPane = new JScrollPane();
        this.taxonomyTree = new JTree();
        this.tfSearchField = new JTextField();
        this.btnSearch = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.taxonomyTreeScrollPane.setBorder(null);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("Eukaryota");
        DefaultMutableTreeNode treeNode3 = new DefaultMutableTreeNode("Alveolata");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Amoebozoa");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Apusozoa");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Breviatea");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Centroheliozoa");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Cryptophyta");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("environmental samples");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Euglenozoa");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Fornicata");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Glaucocystophyceae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Haptophyceae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Heterolobosea");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Jakobida");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Katablepharidophyta");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Malawimonadidae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Opisthokonta");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Oxymonadida");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Parabasalia");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Rhizaria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Rhodophyta");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Stramenopiles");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified eukaryotes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Viridiplantae");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Bacteria");
        treeNode3 = new DefaultMutableTreeNode("Actinobacteria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Aquificae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Armatimonadetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Bacteroidetes/Chlorobi group");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Caldiserica");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Chlamydiae/Verrucomicrobia group");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Chloroflexi");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Chrysiogenetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Cyanobacteria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Deferribacteres");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Deinococcus-Thermus");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Dictyoglomi");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Elusimicrobia");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("environmental samples");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Fibrobacteres/Acidobacteria group");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Firmicutes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Fusobacteria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Gemmatimonadetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Nitrospinae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Nitrospirae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Planctomycetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Proteobacteria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Spirochaetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Synergistetes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Tenericutes");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Thermodesulfobacteria");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Thermotogae");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified Bacteria");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Archaea");
        treeNode3 = new DefaultMutableTreeNode("Aenigmarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Crenarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Diapherotrites");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("environmental samples");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Euryarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Geoarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Korarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Nanoarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Nanohaloarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Parvarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Thaumarchaeota");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified Archaea");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Viruses");
        treeNode3 = new DefaultMutableTreeNode("Deltavirus");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("dsDNA viruses, no RNA stage");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("dsRNA viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("environmental samples");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Retro-transcribing viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Satellites");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("ssDNA viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("ssRNA viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unassigned viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified archaeal viruses");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified phages");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified virophages");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("unclassified viruses");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        this.taxonomyTree.setModel(new DefaultTreeModel(treeNode1));
        this.taxonomyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TaxonomyTreePanel.this.taxonomyTreeMouseClicked(evt);
            }
        });
        this.taxonomyTreeScrollPane.setViewportView(this.taxonomyTree);
        this.btnSearch.setText("Search");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaxonomyTreePanel.this.btnSearchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taxonomyTreeScrollPane).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tfSearchField, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSearch).addContainerGap(191, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearchField, -2, -1, -2).addComponent(this.btnSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taxonomyTreeScrollPane, -1, 260, Short.MAX_VALUE)));
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        try {
            this.buildTreeAfterSearch(this.tfSearchField.getText().replace(" ", "%20"));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Connection to UniProt failed " + System.lineSeparator() + ex, "Connection error", 0);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    private void taxonomyTreeMouseClicked(MouseEvent evt) {
        TreePath tp = this.taxonomyTree.getPathForLocation(evt.getX(), evt.getY());
        try {
            if (tp != null) {
                DefaultMutableTreeNode clickedNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                this.buildTreeAfterClick(clickedNode.toString());
                DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)clickedNode.getChildAt(0);
                this.taxonomyTree.addSelectionPath(new TreePath(childAt.getPath()));
            }
        }
        catch (ArrayIndexOutOfBoundsException clickedNode) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

