/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.IOException;
import java.util.EnumSet;
import java.util.zip.DataFormatException;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.external.msnumpress.MSNumpress;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.ZlibInflater;

public class MZMLPeaksDecoder {
    /*
     * Loose catch block
     */
    public static DecodedData decode(byte[] bytesIn, int lengthIn, Integer precision, int numPoints, EnumSet<PeaksCompression> compressions) throws DataFormatException, IOException, FileParsingException {
        DecodedData decodedData;
        boolean isBytesFromPool;
        ByteArrayHolder bytes;
        block46: {
            double[] data;
            block44: {
                DecodedData decodedData2;
                block45: {
                    block42: {
                        DecodedData decodedData3;
                        block43: {
                            block40: {
                                DecodedData decodedData4;
                                block41: {
                                    if (bytesIn.length == 0 || lengthIn == 0) {
                                        return DecodedData.createEmpty();
                                    }
                                    if (compressions == null) {
                                        compressions = EnumSet.noneOf(PeaksCompression.class);
                                    }
                                    bytes = null;
                                    isBytesFromPool = false;
                                    data = new double[numPoints];
                                    if (compressions.contains((Object)PeaksCompression.ZLIB)) {
                                        bytes = ZlibInflater.zlibUncompressBuffer(bytesIn, lengthIn, null);
                                        isBytesFromPool = true;
                                    } else {
                                        bytes = new ByteArrayHolder(bytesIn);
                                        bytes.setPosition(lengthIn);
                                    }
                                    if (!compressions.contains((Object)PeaksCompression.NUMPRESS_LINPRED)) break block40;
                                    int numDecodedDoubles = MSNumpress.decodeLinear(bytes.getUnderlyingBytes(), bytes.getPosition(), data);
                                    if (numDecodedDoubles < 0) {
                                        throw new FileParsingException("MSNumpress linear decoder failed");
                                    }
                                    decodedData4 = MZMLPeaksDecoder.toDecodedData(data);
                                    if (!isBytesFromPool || bytes == null) break block41;
                                    try {
                                        ZlibInflater.getPool().returnObject((Object)bytes);
                                    }
                                    catch (Exception e) {
                                        throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
                                    }
                                }
                                return decodedData4;
                            }
                            if (!compressions.contains((Object)PeaksCompression.NUMPRESS_POSINT)) break block42;
                            int numDecodedDoubles = MSNumpress.decodePic(bytes.getUnderlyingBytes(), bytes.getPosition(), data);
                            if (numDecodedDoubles < 0) {
                                throw new FileParsingException("MSNumpress positive integer decoder failed");
                            }
                            decodedData3 = MZMLPeaksDecoder.toDecodedData(data);
                            if (!isBytesFromPool || bytes == null) break block43;
                            try {
                                ZlibInflater.getPool().returnObject((Object)bytes);
                            }
                            catch (Exception e) {
                                throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
                            }
                        }
                        return decodedData3;
                    }
                    if (!compressions.contains((Object)PeaksCompression.NUMPRESS_SHLOGF)) break block44;
                    int numDecodedDoubles = MSNumpress.decodeSlof(bytes.getUnderlyingBytes(), bytes.getPosition(), data);
                    if (numDecodedDoubles < 0) {
                        throw new FileParsingException("MSNumpress short logged float decoder failed");
                    }
                    decodedData2 = MZMLPeaksDecoder.toDecodedData(data);
                    if (!isBytesFromPool || bytes == null) break block45;
                    try {
                        ZlibInflater.getPool().returnObject((Object)bytes);
                    }
                    catch (Exception e) {
                        throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
                    }
                }
                return decodedData2;
            }
            if (precision == null) {
                throw new IllegalArgumentException("Precision MUST be specified, if MS-NUMPRESS compression was not used");
            }
            int decodedLen = bytes.getPosition();
            byte[] decoded = bytes.getUnderlyingBytes();
            int chunkSize = precision / 8;
            double valMax = Double.NEGATIVE_INFINITY;
            int valMaxPos = 0;
            double valMin = Double.POSITIVE_INFINITY;
            int valMinPos = 0;
            double valMinNonZero = Double.POSITIVE_INFINITY;
            int valMinNonZeroPos = 0;
            double sum = 0.0;
            switch (precision) {
                case 32: {
                    for (int i = 0; i < numPoints; ++i) {
                        int offset = i * chunkSize;
                        int asInt = decoded[offset] & 0xFF | (decoded[offset + 1] & 0xFF) << 8 | (decoded[offset + 2] & 0xFF) << 16 | (decoded[offset + 3] & 0xFF) << 24;
                        float asFloat = Float.intBitsToFloat(asInt);
                        if ((double)asFloat > valMax) {
                            valMax = asFloat;
                            valMaxPos = i;
                        }
                        if ((double)asFloat < valMinNonZero) {
                            if (asFloat > 0.0f) {
                                valMinNonZero = asFloat;
                                valMinNonZeroPos = i;
                            }
                            if ((double)asFloat < valMin) {
                                valMin = asFloat;
                                valMinPos = i;
                            }
                        }
                        sum += (double)asFloat;
                        data[i] = asFloat;
                    }
                    break;
                }
                case 64: {
                    for (int i = 0; i < numPoints; ++i) {
                        int offset = i * chunkSize;
                        long asLong = (long)(decoded[offset] & 0xFF) | (long)(decoded[offset + 1] & 0xFF) << 8 | (long)(decoded[offset + 2] & 0xFF) << 16 | (long)(decoded[offset + 3] & 0xFF) << 24 | (long)(decoded[offset + 4] & 0xFF) << 32 | (long)(decoded[offset + 5] & 0xFF) << 40 | (long)(decoded[offset + 6] & 0xFF) << 48 | (long)(decoded[offset + 7] & 0xFF) << 56;
                        double asDouble = Double.longBitsToDouble(asLong);
                        if (asDouble > valMax) {
                            valMax = asDouble;
                            valMaxPos = i;
                        }
                        if (asDouble < valMinNonZero) {
                            if (asDouble > 0.0) {
                                valMinNonZero = asDouble;
                                valMinNonZeroPos = i;
                            }
                            if (asDouble < valMin) {
                                valMin = asDouble;
                                valMinPos = i;
                            }
                        }
                        sum += asDouble;
                        data[i] = asDouble;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Precision can only be 32/64 bits, other values are not valid.");
                }
            }
            decodedData = new DecodedData(data, valMax, valMaxPos, valMin, valMinPos, valMinNonZero, valMinNonZeroPos, sum);
            if (!isBytesFromPool || bytes == null) break block46;
            try {
                ZlibInflater.getPool().returnObject((Object)bytes);
            }
            catch (Exception e) {
                throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
            }
        }
        return decodedData;
        catch (OutOfMemoryError oom) {
            try {
                throw new FileParsingException("Could not allocate arrays during spectra decoding step", oom);
            }
            catch (Throwable throwable) {
                if (isBytesFromPool && bytes != null) {
                    try {
                        ZlibInflater.getPool().returnObject(bytes);
                    }
                    catch (Exception e) {
                        throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
                    }
                }
                throw throwable;
            }
        }
    }

    protected static DecodedData toDecodedData(double[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array length of zero is not allowed here");
        }
        double valMax = Double.NEGATIVE_INFINITY;
        int valMaxPos = 0;
        double valMin = Double.POSITIVE_INFINITY;
        int valMinPos = 0;
        double valMinNonZero = Double.POSITIVE_INFINITY;
        int valMinNonZeroPos = 0;
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            double val = arr[i];
            if (val > valMax) {
                valMax = val;
                valMaxPos = i;
            }
            if (val < valMinNonZero) {
                if (val > 0.0) {
                    valMinNonZero = val;
                    valMinNonZeroPos = i;
                }
                if (val < valMin) {
                    valMin = val;
                    valMinPos = i;
                }
            }
            sum += val;
            arr[i] = val;
        }
        return new DecodedData(arr, valMax, valMaxPos, valMin, valMinPos, valMinNonZero, valMinNonZeroPos, sum);
    }

    public static class DecodedData {
        double[] arr;
        double valMax;
        int valMaxPos;
        double valMin;
        int valMinPos;
        double valMinNonZero;
        int valMinNonZeroPos;
        double sum;

        public DecodedData(double[] arr, double valMax, int valMaxPos, double valMin, int valMinPos, double valMinNonZero, int valMinNonZeroPos, double sum) {
            this.arr = arr;
            this.valMax = valMax;
            this.valMaxPos = valMaxPos;
            this.valMin = valMin;
            this.valMinPos = valMinPos;
            this.valMinNonZero = valMinNonZero;
            this.valMinNonZeroPos = valMinNonZeroPos;
            this.sum = sum;
        }

        public static DecodedData createEmpty() {
            return new DecodedData(new double[0], 0.0, -1, 0.0, -1, 0.0, -1, 0.0);
        }
    }
}

