/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import umich.ms.util.Interval1D;

public class DoubleRange
extends Interval1D<Double> {
    public DoubleRange(Double left, Double right) {
        super(left, right);
    }

    public static DoubleRange fromInterval1D(Interval1D<Double> interval) {
        return new DoubleRange((Double)interval.lo, (Double)interval.hi);
    }

    public double overlapAbsolute(DoubleRange other) {
        if (!this.intersects(other)) {
            return 0.0;
        }
        int loCmp = ((Double)this.lo).compareTo((Double)other.lo);
        int hiCmp = ((Double)this.hi).compareTo((Double)other.hi);
        if (loCmp >= 0 && hiCmp <= 0) {
            return this.length();
        }
        if (loCmp <= 0 && hiCmp >= 0) {
            return other.length();
        }
        double newLo = loCmp >= 0 ? (Double)this.lo : (Double)other.lo;
        double newHi = hiCmp <= 0 ? (Double)this.hi : (Double)other.hi;
        return newHi - newLo;
    }

    public double overlapRelative(DoubleRange other) {
        double lenThis = this.length();
        double lenOther = other.length();
        if (lenThis == 0.0 && lenOther == 0.0) {
            return this.equals(other) ? 1.0 : 0.0;
        }
        double overlapAbs = this.overlapAbsolute(other);
        return overlapAbs / Math.max(lenThis, lenOther);
    }

    public final double length() {
        return (Double)this.hi - (Double)this.lo;
    }
}

