/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamException;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.logging.LogHelper;
import umich.ms.util.OffsetLength;
import umich.ms.util.xml.POSITION;
import umich.ms.util.xml.TAG_TYPE;

public class XmlUtils {
    private XmlUtils() {
    }

    public static List<Long> locate(List<byte[]> targets, List<POSITION> locations, InputStream is, long maxOffset) throws IOException {
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Targets argument can't be empty");
        }
        if (locations.size() != targets.size()) {
            throw new IllegalArgumentException("Targets and Locations arguments must be of equal length");
        }
        for (byte[] target : targets) {
            if (target.length != 0) continue;
            throw new IllegalArgumentException("Input Targets must be non-zero length");
        }
        if (maxOffset <= 0L) {
            maxOffset = Long.MAX_VALUE;
        }
        long posSource = -1L;
        ArrayList<Long> result = new ArrayList<Long>(targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            int iRead;
            byte[] target = targets.get(i);
            int posTarget = 0;
            byte bTarget = target[posTarget];
            block6: while ((iRead = is.read()) >= 0) {
                if (++posSource > maxOffset) {
                    return result;
                }
                byte bRead = (byte)iRead;
                if (bRead != bTarget) {
                    if (posTarget <= 0) continue;
                    posTarget = 0;
                    bTarget = target[posTarget];
                    continue;
                }
                if (++posTarget == target.length) {
                    switch (locations.get(i)) {
                        case START: {
                            result.add(posSource - (long)target.length + 1L);
                            break block6;
                        }
                        case END: {
                            result.add(posSource);
                            break block6;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported ELEMENT_LOCATION");
                        }
                    }
                }
                bTarget = target[posTarget];
            }
            if (iRead >= 0 || result.size() == targets.size()) continue;
            return Collections.emptyList();
        }
        return result;
    }

    @Deprecated
    public static OffsetLength locate(String tag1, TAG_TYPE tag1Type, POSITION tag1Loc, String tag2, TAG_TYPE tag2Type, POSITION tag2Loc, long maxOffset, InputStream is) throws FileParsingException {
        if (tag1Type == TAG_TYPE.SELF_CLOSING || tag2Type == TAG_TYPE.SELF_CLOSING) {
            throw new IllegalArgumentException("Self-closing tags are not supported.");
        }
        LogHelper.setJavolutionLogLevelFatal();
        long offsetLo = -1L;
        long offsetHi = -1L;
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int eventType;
            XMLStreamReaderImpl xsr = new XMLStreamReaderImpl();
            xsr.setInput((InputStream)bis, StandardCharsets.UTF_8.name());
            XMLStreamReaderImpl.LocationImpl loc = xsr.getLocation();
            do {
                eventType = xsr.next();
                block5 : switch (eventType) {
                    case 1: {
                        CharArray localName = xsr.getLocalName();
                        switch (tag1Type) {
                            case OPENING: {
                                if (!localName.equals(tag1)) break;
                                offsetLo = XmlUtils.calcOffset(loc, tag1Loc);
                                break;
                            }
                        }
                        switch (tag2Type) {
                            case OPENING: {
                                if (!localName.equals(tag2)) break block5;
                                offsetHi = XmlUtils.calcOffset(loc, tag2Loc);
                                break block5;
                            }
                        }
                        break;
                    }
                    case 2: {
                        CharArray localName = xsr.getLocalName();
                        switch (tag1Type) {
                            case OPENING: {
                                if (!localName.equals(tag1)) break;
                                offsetLo = XmlUtils.calcOffset(loc, tag1Loc);
                                break;
                            }
                        }
                        switch (tag2Type) {
                            case OPENING: {
                                if (!localName.equals(tag2)) break block5;
                                offsetHi = XmlUtils.calcOffset(loc, tag2Loc);
                                break block5;
                            }
                        }
                        break;
                    }
                }
                if (loc.getTotalCharsRead() <= maxOffset) continue;
                throw new FileParsingException(String.format("Could not locate tags '%s' and '%s' within first %d characters", tag1, tag2, maxOffset));
            } while (eventType != 8 && (offsetLo == -1L || offsetHi == -1L));
        }
        catch (IOException | XMLStreamException e) {
            throw new RunHeaderParsingException("Error when parsing MS run header info", e);
        }
        if (offsetLo == -1L || offsetHi == -1L) {
            throw new FileParsingException(String.format("Could not locate tags '%s' and '%s'.", tag1, tag2));
        }
        return new OffsetLength(offsetLo, (int)(offsetHi - offsetLo));
    }

    private static long calcOffset(XMLStreamReaderImpl.LocationImpl loc, POSITION type) {
        switch (type) {
            case START: {
                return loc.getLastStartTagPos() + (long)loc.getBomLength();
            }
            case END: {
                return loc.getTotalCharsRead() + (long)loc.getBomLength();
            }
        }
        throw new IllegalStateException("Provided POSITION is not supported.");
    }

    public static boolean advanceReaderToNext(XMLStreamReader xsr, String tag) throws javax.xml.stream.XMLStreamException {
        if (tag == null) {
            throw new IllegalArgumentException("Tag name can't be null");
        }
        if (xsr == null) {
            throw new IllegalArgumentException("Stream Reader can't be null");
        }
        do {
            if (xsr.next() != 8) continue;
            return false;
        } while (!xsr.isStartElement() || !xsr.getLocalName().equals(tag));
        return true;
    }
}

