/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import umontreal.iro.lecuyer.util.io.AbstractDataReader;
import umontreal.iro.lecuyer.util.io.DataField;

public class BinaryDataReader
extends AbstractDataReader {
    protected DataInputStream in;
    protected String filename = null;
    protected URL url = null;
    protected File file = null;
    protected boolean canReset = false;

    protected String readLabel() throws IOException {
        byte typechar = this.in.readByte();
        if (typechar != 124) {
            throw new IOException("Expected a label");
        }
        return this.readStringData();
    }

    protected String readStringData() throws IOException {
        int length = this.in.readInt();
        if (length == 0) {
            return null;
        }
        byte[] s = new byte[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.in.readByte();
        }
        return new String(s);
    }

    protected String[] readStringArrayData(int dim) throws IOException {
        String[] a = new String[dim];
        for (int i = 0; i < dim; ++i) {
            a[i] = this.readStringData();
        }
        return a;
    }

    protected String[][] readStringArray2DData(int[] dims) throws IOException {
        String[][] a = new String[dims[0]][dims[1]];
        for (int i = 0; i < dims[0]; ++i) {
            for (int j = 0; j < dims[1]; ++j) {
                a[i][j] = this.readStringData();
            }
        }
        return a;
    }

    protected int readIntData() throws IOException {
        return this.in.readInt();
    }

    protected int[] readIntArrayData(int dim) throws IOException {
        int[] a = new int[dim];
        for (int i = 0; i < dim; ++i) {
            a[i] = this.readIntData();
        }
        return a;
    }

    protected int[][] readIntArray2DData(int[] dims) throws IOException {
        int[][] a = new int[dims[0]][dims[1]];
        for (int i = 0; i < dims[0]; ++i) {
            for (int j = 0; j < dims[1]; ++j) {
                a[i][j] = this.readIntData();
            }
        }
        return a;
    }

    protected float readFloatData() throws IOException {
        return this.in.readFloat();
    }

    protected float[] readFloatArrayData(int dim) throws IOException {
        float[] a = new float[dim];
        for (int i = 0; i < dim; ++i) {
            a[i] = this.readFloatData();
        }
        return a;
    }

    protected float[][] readFloatArray2DData(int[] dims) throws IOException {
        float[][] a = new float[dims[0]][dims[1]];
        for (int i = 0; i < dims[0]; ++i) {
            for (int j = 0; j < dims[1]; ++j) {
                a[i][j] = this.readFloatData();
            }
        }
        return a;
    }

    protected double readDoubleData() throws IOException {
        return this.in.readDouble();
    }

    protected double[] readDoubleArrayData(int dim) throws IOException {
        double[] a = new double[dim];
        for (int i = 0; i < dim; ++i) {
            a[i] = this.readDoubleData();
        }
        return a;
    }

    protected double[][] readDoubleArray2DData(int[] dims) throws IOException {
        double[][] a = new double[dims[0]][dims[1]];
        for (int i = 0; i < dims[0]; ++i) {
            for (int j = 0; j < dims[1]; ++j) {
                a[i][j] = this.readDoubleData();
            }
        }
        return a;
    }

    protected Object readFieldData(byte typechar, int nDims, int[] dims) throws IOException {
        if (nDims < 0 || nDims > 2) {
            throw new IOException("unsupported number of dimensions: " + nDims);
        }
        Object data = null;
        switch (typechar) {
            case 83: {
                if (nDims == 0) {
                    data = this.readStringData();
                    break;
                }
                if (nDims == 1) {
                    data = this.readStringArrayData(dims[0]);
                    break;
                }
                if (nDims != 2) break;
                data = this.readStringArray2DData(dims);
                break;
            }
            case 105: {
                if (nDims == 0) {
                    data = this.readIntData();
                    break;
                }
                if (nDims == 1) {
                    data = this.readIntArrayData(dims[0]);
                    break;
                }
                if (nDims != 2) break;
                data = this.readIntArray2DData(dims);
                break;
            }
            case 102: {
                if (nDims == 0) {
                    data = Float.valueOf(this.readFloatData());
                    break;
                }
                if (nDims == 1) {
                    data = this.readFloatArrayData(dims[0]);
                    break;
                }
                if (nDims != 2) break;
                data = this.readFloatArray2DData(dims);
                break;
            }
            case 100: {
                if (nDims == 0) {
                    data = this.readDoubleData();
                    break;
                }
                if (nDims == 1) {
                    data = this.readDoubleArrayData(dims[0]);
                    break;
                }
                if (nDims != 2) break;
                data = this.readDoubleArray2DData(dims);
            }
        }
        return data;
    }

    public BinaryDataReader(String filename) throws IOException {
        this.filename = filename;
        this.canReset = true;
        this.reset();
    }

    public BinaryDataReader(URL url) throws IOException {
        this.url = url;
        this.canReset = true;
        this.reset();
    }

    public BinaryDataReader(File file) throws IOException {
        this.file = file;
        this.canReset = true;
        this.reset();
    }

    public BinaryDataReader(InputStream inputStream) throws IOException {
        this.in = new DataInputStream(this.in);
    }

    public DataField readNextField() throws IOException {
        String label = this.readLabel();
        byte typechar = this.in.readByte();
        int nDims = this.in.readByte();
        int[] dims = new int[nDims];
        for (int i = 0; i < nDims; ++i) {
            dims[i] = this.in.readInt();
        }
        return new DataField(label, this.readFieldData(typechar, nDims, dims));
    }

    public DataField readField(String label) throws IOException {
        this.reset();
        while (this.in.available() > 0) {
            String fieldLabel = this.readLabel();
            byte typechar = this.in.readByte();
            int nDims = this.in.readByte();
            int[] dims = new int[nDims];
            for (int i = 0; i < nDims; ++i) {
                dims[i] = this.in.readInt();
            }
            if (fieldLabel.compareTo(label) == 0) {
                return new DataField(fieldLabel, this.readFieldData(typechar, nDims, dims));
            }
            if (typechar == 83) {
                this.readFieldData(typechar, nDims, dims);
                continue;
            }
            int skipSize = 0;
            switch (typechar) {
                case 105: {
                    skipSize = 4;
                    break;
                }
                case 102: {
                    skipSize = 4;
                    break;
                }
                case 100: {
                    skipSize = 8;
                }
            }
            if (nDims > 0) {
                skipSize *= dims[0];
            }
            if (nDims > 1) {
                skipSize *= dims[1];
            }
            this.in.skipBytes(skipSize);
        }
        return null;
    }

    public void reset() throws IOException {
        if (!this.canReset) {
            return;
        }
        if (this.filename != null) {
            this.in = new DataInputStream(new FileInputStream(this.filename));
        } else if (this.file != null) {
            this.in = new DataInputStream(new FileInputStream(this.file));
        } else if (this.url != null) {
            this.in = new DataInputStream(this.url.openStream());
        }
    }

    public boolean dataPending() throws IOException {
        return this.in.available() > 0;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

