/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLongAssociativeContainer;
import com.carrotsearch.hppc.LongLongMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongLongCursor;
import com.carrotsearch.hppc.hash.LongHashFunction;
import com.carrotsearch.hppc.hash.LongMurmurHash;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongLongProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongLongOpenHashMap
implements LongLongMap {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public long[] keys;
    public long[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final LongHashFunction keyHashFunction;
    public final LongHashFunction valueHashFunction;
    private KeySet keySetView;

    public LongLongOpenHashMap() {
        this(16);
    }

    public LongLongOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongLongOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new LongMurmurHash());
    }

    public LongLongOpenHashMap(int initialCapacity, float loadFactor, LongHashFunction keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new LongHashFunction());
    }

    public LongLongOpenHashMap(int initialCapacity, float loadFactor, LongHashFunction keyHashFunction, LongHashFunction valueHashFunction) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public LongLongOpenHashMap(LongLongAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public long put(long key, long value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        long oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(LongLongAssociativeContainer container) {
        int count = this.assigned;
        for (LongLongCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(long key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final long putOrAdd(long key, long putValue, long additionValue) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) == 2) {
            int n = slot;
            long l = this.values[n] + additionValue;
            this.values[n] = l;
            return l;
        }
        ++this.assigned;
        if (state == 1) {
            --this.deleted;
        }
        this.states[slot] = 2;
        this.keys[slot] = key;
        this.values[slot] = putValue;
        return this.values[slot];
    }

    private void expandAndRehash() {
        long[] oldKeys = this.keys;
        long[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new long[capacity];
        this.values = new long[capacity];
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public long remove(long key) {
        int slot = this.slotFor(key);
        long value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = 0L;
            this.values[slot] = 0L;
            this.states[slot] = 1;
        } else assert (0L == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(LongContainer container) {
        int before = this.deleted;
        for (LongCursor cursor : container) {
            this.remove(cursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(LongPredicate predicate) {
        int before = this.deleted;
        long[] keys = this.keys;
        long[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = 0L;
            values[i] = 0L;
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public long get(long key) {
        return this.values[this.slotFor(key)];
    }

    public long lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public long lset(long key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        long previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(long key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(long key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (LongLongCursor c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            LongLongMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongLongMap && (other = (LongLongMap)obj).size() == this.size()) {
                for (LongLongCursor c : this) {
                    long v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<LongLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongLongProcedure> T forEach(T procedure) {
        long[] keys = this.keys;
        long[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static LongLongOpenHashMap from(long[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongLongOpenHashMap map = new LongLongOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static LongLongOpenHashMap from(LongLongAssociativeContainer container) {
        return new LongLongOpenHashMap(container);
    }

    private final class KeySetIterator
    implements Iterator<LongCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final LongCursor cursor = new LongCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < LongLongOpenHashMap.this.keys.length && LongLongOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != LongLongOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public LongCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = LongLongOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public final class KeySet
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongLongOpenHashMap owner;

        public KeySet() {
            this.owner = LongLongOpenHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return LongLongOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            long[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            long[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    implements Iterator<LongLongCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final LongLongCursor cursor = new LongLongCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < LongLongOpenHashMap.this.keys.length && LongLongOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != LongLongOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public LongLongCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = LongLongOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = LongLongOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

