/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.FastTable;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class SortedCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;

    public SortedCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E e) {
        return this.target().add(e);
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.target().contains(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean remove(Object obj) {
        return this.target().remove(obj);
    }

    @Override
    public int size() {
        return this.target().size();
    }

    private class IteratorImpl
    implements Iterator<E> {
        private final Iterator<E> iterator;
        private E next;

        public IteratorImpl() {
            FastTable sorted = new FastTable(SortedCollectionImpl.this.comparator());
            Iterator it = SortedCollectionImpl.this.target().iterator();
            while (it.hasNext()) {
                sorted.add(it.next());
            }
            sorted.sort();
            this.iterator = sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            this.next = this.iterator.next();
            return this.next;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            SortedCollectionImpl.this.target().remove(this.next);
            this.next = null;
        }
    }
}

