/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map.sorted;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Equality;
import javolution.util.internal.map.sorted.MapEntryImpl;
import javolution.util.internal.map.sorted.SortedMapView;
import javolution.util.internal.table.sorted.FastSortedTableImpl;

public class FastSortedMapImpl<K, V>
extends SortedMapView<K, V> {
    private static final long serialVersionUID = 1536L;
    private final FastSortedTableImpl<Map.Entry<K, V>> table;
    private final Equality<? super K> keyComparator;
    private final Equality<? super V> valueComparator;

    public FastSortedMapImpl(Equality<? super K> keyComparator, Equality<? super V> valueComparator) {
        super(null);
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
        this.table = new FastSortedTableImpl<Object>(new TableComparator());
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.table.indexOf(key) >= 0;
    }

    @Override
    public K firstKey() {
        return ((Map.Entry)this.table.getFirst()).getKey();
    }

    @Override
    public V get(Object key) {
        int i = this.table.indexOf(key);
        if (i < 0) {
            return null;
        }
        return this.table.get(i).getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.table.iterator();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.keyComparator;
    }

    @Override
    public K lastKey() {
        return ((Map.Entry)this.table.getLast()).getKey();
    }

    @Override
    public V put(K key, V value) {
        int i = this.table.positionOf((Map.Entry<K, V>)key);
        if (i >= 0) {
            Map.Entry<K, V> entry = this.table.get(i);
            V previous = entry.getValue();
            entry.setValue(value);
            return previous;
        }
        MapEntryImpl<K, V> entry = new MapEntryImpl<K, V>(key, value);
        this.table.add(-i - 1, entry);
        return null;
    }

    @Override
    public V remove(Object key) {
        int i = this.table.indexOf(key);
        if (i < 0) {
            return null;
        }
        Map.Entry<K, V> e = this.table.get(i);
        V previous = e.getValue();
        this.table.remove(i);
        return previous;
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.valueComparator;
    }

    private class TableComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1536L;

        private TableComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof MapEntryImpl) {
                o1 = ((MapEntryImpl)o1).getKey();
            }
            if (o2 instanceof MapEntryImpl) {
                o2 = ((MapEntryImpl)o2).getKey();
            }
            return FastSortedMapImpl.this.keyComparator.compare(o1, o2);
        }
    }
}

