/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.blocks;

import jwave.datatypes.Super;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.lines.Line;
import jwave.datatypes.lines.LineFull;
import jwave.exceptions.JWaveException;

public class BlockFull
extends Block {
    protected Line[] _arrLines = null;

    public BlockFull() {
    }

    public BlockFull(Block block) {
        super(block);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    this.set(i, j, block.get(i, j));
                }
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public BlockFull(int noOfRows, int noOfCols) {
        super(noOfRows, noOfCols);
    }

    public BlockFull(int offSetRow, int offSetCol, int noOfRows, int noOfCols) {
        super(offSetRow, offSetCol, noOfRows, noOfCols);
    }

    @Override
    public Block copy() {
        return new BlockFull(this);
    }

    @Override
    public boolean isAllocated() {
        boolean isAllocated = true;
        if (this._arrLines == null) {
            isAllocated = false;
        }
        return isAllocated;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._arrLines = new Line[this._noOfCols];
            for (int j = 0; j < this._noOfCols; ++j) {
                LineFull line = new LineFull(this._offSetRow, this._noOfRows);
                ((Super)line).alloc();
                this._arrLines[j] = line;
            }
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._arrLines != null) {
            for (int j = 0; j < this._noOfCols; ++j) {
                if (this._arrLines[j] == null) continue;
                Line line = this._arrLines[j];
                line.erase();
                this._arrLines[j] = null;
            }
            this._arrLines = null;
        }
    }

    @Override
    public double get(int i, int j) throws JWaveException {
        this.checkMemory();
        this.check(i, j);
        Line line = this._arrLines[j];
        double value = line.get(i);
        return value;
    }

    @Override
    public void set(int i, int j, double value) throws JWaveException {
        this.checkMemory();
        this.check(i, j);
        Line line = this._arrLines[j];
        line.set(i, value);
    }
}

