/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.identification_parameters;

import com.compomics.cli.identification_parameters.IdentificationParametersCLIParams;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.AndromedaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.CometParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.DirecTagParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsAmandaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsgfParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PNovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PepnovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.XtandemParameters;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import com.compomics.util.experiment.identification.ptm.PtmScore;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.FragmentationMethod;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.FractionSettings;
import com.compomics.util.preferences.GenePreferences;
import com.compomics.util.preferences.IdMatchValidationPreferences;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.PTMScoringPreferences;
import com.compomics.util.preferences.ProteinInferencePreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class IdentificationParametersInputBean {
    private IdentificationParameters identificationParameters;
    private File inputFile;
    private File destinationFile;
    private Boolean listMods = false;
    private Boolean listEnzymes = false;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private CommandLine commandLine;

    public static boolean isValidStartup(CommandLine aLine, boolean checkMandatoryParameters) {
        File fastaFile;
        List<String> supportedInput;
        String arg;
        List<String> supportedInput2;
        List<String> supportedInput22;
        File fastaFile2;
        ArrayList<String> possibleValues;
        String arg2;
        String arg22;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            return true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYMES.id)) {
            return true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PREC_PPM.id, arg22 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.FRAG_PPM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PREC_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.FRAG_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FI.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FI.id);
            possibleValues = new ArrayList<String>(3);
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(0));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(1));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(2));
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.FI.id, arg2, possibleValues)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.RI.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.RI.id);
            possibleValues = new ArrayList(3);
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(3));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(4));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(5));
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.RI.id, arg2, possibleValues)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIGESTION.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIGESTION.id);
            possibleValues = new ArrayList(DigestionPreferences.Specificity.values().length);
            DigestionPreferences.CleavagePreference[] cleavagePreferenceArray = DigestionPreferences.CleavagePreference.values();
            int n = cleavagePreferenceArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = cleavagePreferenceArray[i];
                possibleValues.add(((DigestionPreferences.CleavagePreference)((Object)object)).index + "");
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.DIGESTION.id, arg2, possibleValues)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            ArrayList<String> enzymes = CommandLineUtils.splitInput(arg2);
            for (String enzymeName : enzymes) {
                Enzyme enzyme = EnzymeFactory.getInstance().getEnzyme(enzymeName);
                if (enzyme != null) continue;
                System.out.println(System.getProperty("line.separator") + "Enzyme " + arg2 + " not recognized. Please add enzyme using the EnzymeCLI command." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
            ArrayList<String> mcsAsString = CommandLineUtils.splitInput(arg2);
            for (String mcAsString : mcsAsString) {
                if (CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MC.id, mcAsString, true)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SPECIFICITY.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SPECIFICITY.id);
            possibleValues = new ArrayList(DigestionPreferences.Specificity.values().length);
            for (DigestionPreferences.Specificity specificity : DigestionPreferences.Specificity.values()) {
                possibleValues.add(specificity.index + "");
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.SPECIFICITY.id, arg2, possibleValues)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id);
            if (arg2.equals("")) {
                System.out.println(System.getProperty("line.separator") + "No input file specified!" + System.getProperty("line.separator"));
                return false;
            }
            File fileIn = new File(arg2);
            try {
                IdentificationParameters.getIdentificationParameters(fileIn);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while importing the parameters file " + fileIn + " (see below)." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OUT.id)) {
            if (aLine.getOptionValue(IdentificationParametersCLIParams.OUT.id).equals("")) {
                System.out.println(System.getProperty("line.separator") + "No output file specified!" + System.getProperty("line.separator"));
                return false;
            }
        } else if (checkMandatoryParameters) {
            System.out.println(System.getProperty("line.separator") + "No output file specified!" + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DB.id) && !(fastaFile2 = new File(arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DB.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "Database not found." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MIN_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MAX_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_ISOTOPE.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MIN_ISOTOPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_ISOTOPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_ISOTOPE.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MAX_ISOTOPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_ISOTOPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.OMSSA_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id), supportedInput22 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_NEUTRON.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_METHIONINE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id), supportedInput2 = Arrays.asList("all", "valid", "stochastic"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_DECOY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MSGF_DECOY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_DECOY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id), supportedInput2 = Arrays.asList("0", "1", "2", "3"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id), supportedInput2 = Arrays.asList("0", "1", "2", "3"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PROTOCOL.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_PROTOCOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PROTOCOL.id), supportedInput2 = Arrays.asList("0", "1", "2", "3", "4", "5"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_TERMINI.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_TERMINI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TERMINI.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_TASKS.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MSGF_TASKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TASKS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOW_MEM_MODE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_LOW_MEM_MODE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOW_MEM_MODE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id), supportedInput2 = Arrays.asList("mzIdentML", "pepXML"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REQ_PTMS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_REQ_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REQ_PTMS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id), supportedInput2 = Arrays.asList("1", "2", "8", "9"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id), 1, 5)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_METH.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_REMOVE_METH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_METH.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_OUTPUT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_OUTPUT.id);
            supportedInput2 = new ArrayList<String>();
            for (CometParameters.CometOutputFormat cometOutputFormat : CometParameters.CometOutputFormat.values()) {
                supportedInput2.add(cometOutputFormat.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.COMET_OUTPUT.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id), supportedInput2 = Arrays.asList("none", "shuffle", "peptide-reverse", "protein-reverse"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id), supportedInput2 = Arrays.asList("N", "C", "NC"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_VERBOSITY.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_VERBOSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_VERBOSITY.id), supportedInput2 = Arrays.asList("0", "10", "20", "30", "40", "50", "60"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id), supportedInput2 = Arrays.asList("full-digest", "partial-digest"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id), supportedInput2 = Arrays.asList("1", "2", "3", "all"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_CONCAT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_CONCAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CONCAT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id), supportedInput2 = Arrays.asList("HCD", "CID", "ETD"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : AndromedaParameters.AndromedaDecoyMode.values()) {
                supportedInput2.add(enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id), 1, 20)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id), supportedInput2 = Arrays.asList("CID_IT_TRYP"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id), 0, 100)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id), supportedInput2 = Arrays.asList("HCD", "CID", "ETD"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id), supportedInput2 = Arrays.asList("HCD", "CID"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id), supportedInput2 = Arrays.asList("Trap", "TOF", "FT"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id) && CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id) && !CommandParameter.isSequenceMatchingType(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id), 0.0, 1.0)) {
            return false;
        }
        Integer min = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id)) {
            String arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id, arg3, false)) {
                return false;
            }
            min = new Integer(arg3);
        }
        Integer max = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id, arg, false)) {
                return false;
            }
            max = new Integer(arg);
        }
        if (min != null && max != null && max <= min) {
            System.out.println(System.getProperty("line.separator") + IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id + " <= " + IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id + System.getProperty("line.separator"));
            return false;
        }
        min = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MIN.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MIN.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_MC_MIN.id, arg, true)) {
                return false;
            }
            min = new Integer(arg);
        }
        max = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MAX.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MAX.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_MC_MAX.id, arg, false)) {
                return false;
            }
            max = new Integer(arg);
        }
        if (min != null && max != null && max < min) {
            System.out.println(System.getProperty("line.separator") + IdentificationParametersCLIParams.IMPORT_MC_MAX.id + " < " + IdentificationParametersCLIParams.IMPORT_MC_MIN.id + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_SCORE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_SCORE.id);
            try {
                int scoreId = new Integer(arg);
                PtmScore.getScore(scoreId);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "Error when parsing " + IdentificationParametersCLIParams.PTM_SCORE.id + ". Option found: " + arg + "." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_THRESHOLD.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_THRESHOLD.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id) && !CommandParameter.isSequenceMatchingType(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_ALIGNMENT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PTM_ALIGNMENT.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_ALIGNMENT.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DB_PI.id) && !(fastaFile = new File(arg = aLine.getOptionValue(IdentificationParametersCLIParams.DB_PI.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "Protein inference database not found." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PSM_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PSM_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPTIDE_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPTIDE_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEPARATE_PSMs.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.SEPARATE_PSMs.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SEPARATE_PSMs.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEPARATE_PEPTIDES.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.SEPARATE_PSMs.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SEPARATE_PEPTIDES.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MERGE_SUBGROUPS.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MERGE_SUBGROUPS.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.MERGE_SUBGROUPS.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        return !aLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id) || CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id), 0.0, 100.0);
    }

    public IdentificationParametersInputBean(CommandLine aLine) throws IOException, ClassNotFoundException {
        String arg;
        this.commandLine = aLine;
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            this.listMods = true;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ENZYMES.id)) {
            this.listEnzymes = true;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id);
            this.inputFile = new File(arg);
            this.identificationParameters = IdentificationParameters.getIdentificationParameters(this.inputFile);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OUT.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OUT.id);
            if (!arg.endsWith(".par")) {
                arg = arg + ".par";
            }
            this.destinationFile = new File(arg);
        }
        this.updateIdentificationParameters();
    }

    public void updateIdentificationParameters() throws FileNotFoundException, IOException, ClassNotFoundException {
        FractionSettings fractionSettings;
        boolean value;
        Integer intValue;
        Double value2;
        IdMatchValidationPreferences idMatchValidationPreferences;
        String arg;
        PTMScoringPreferences ptmScoringPreferences;
        Object value3;
        SequenceMatchingPreferences sequenceMatchingPreferences;
        String arg2;
        AnnotationSettings annotationSettings;
        boolean value4;
        Integer intValue2;
        String arg3;
        GenePreferences genePreferences;
        String arg4;
        NovorParameters novorParameters;
        Integer option;
        String arg5;
        PNovoParameters pNovoParameters;
        Number option2;
        String arg6;
        DirecTagParameters direcTagParameters;
        Integer option3;
        String arg7;
        PepnovoParameters pepnovoParameters;
        Number option4;
        String arg8;
        AndromedaParameters andromedaParameters;
        Number option5;
        String arg9;
        TideParameters tideParameters;
        Number option6;
        String arg10;
        CometParameters cometParameters;
        Integer option7;
        String arg11;
        MsAmandaParameters msAmandaParameters;
        Number option8;
        String arg12;
        MyriMatchParameters myriMatchParameters;
        Integer option9;
        String arg13;
        MsgfParameters msgfParameters;
        Number option10;
        String arg14;
        XtandemParameters xtandemParameters;
        Number option11;
        OmssaParameters omssaParameters;
        Integer algorithmIndex;
        IdentificationAlgorithmParameter identificationAlgorithmParameter;
        Integer option12;
        PTM modification;
        ArrayList<String> args;
        String arg15;
        PtmSettings ptmSettings;
        ArrayList<Integer> ions;
        ArrayList<String> args2;
        DigestionPreferences.Specificity specificity;
        Enzyme enzyme;
        Integer option13;
        String arg16;
        DigestionPreferences digestionPreferences;
        Number option14;
        String arg17;
        SearchParameters searchParameters = null;
        if (this.identificationParameters != null) {
            searchParameters = this.identificationParameters.getSearchParameters();
        }
        if (searchParameters == null) {
            searchParameters = new SearchParameters();
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id)) {
            arg17 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id);
            option14 = new Integer(arg17);
            switch (option14) {
                case 1: {
                    searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                    break;
                }
                case 0: {
                    searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.PREC_PPM.id + ": " + arg17 + ". 0 or 1 expected.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id)) {
            arg17 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id);
            option14 = new Integer(arg17);
            if (option14 == 1) {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id)) {
            arg17 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id);
            option14 = new Double(arg17);
            searchParameters.setPrecursorAccuracy((Double)option14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id)) {
            arg17 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id);
            option14 = new Double(arg17);
            searchParameters.setFragmentIonAccuracy((Double)option14);
        }
        if ((digestionPreferences = searchParameters.getDigestionPreferences()) == null) {
            digestionPreferences = DigestionPreferences.getDefaultPreferences();
            searchParameters.setDigestionPreferences(digestionPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIGESTION.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIGESTION.id);
            option13 = new Integer(arg16);
            DigestionPreferences.CleavagePreference cleavagePreference = DigestionPreferences.CleavagePreference.getCleavagePreferences(option13);
            if (digestionPreferences.getCleavagePreference() != null && digestionPreferences.getCleavagePreference() != cleavagePreference) {
                digestionPreferences.clear();
            }
            digestionPreferences.setCleavagePreference(cleavagePreference);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            ArrayList<String> args3;
            if (digestionPreferences.hasEnzymes()) {
                digestionPreferences.clearEnzymes();
            }
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            ArrayList<String> enzymes = CommandLineUtils.splitInput(arg16);
            ArrayList<Integer> mcs = null;
            Iterator<String> specificities = null;
            if (this.commandLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
                arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
                args3 = CommandLineUtils.splitInput(arg16);
                mcs = new ArrayList<Integer>(args3.size());
                for (String stringValue : args3) {
                    mcs.add(new Integer(stringValue));
                }
            }
            if (this.commandLine.hasOption(IdentificationParametersCLIParams.SPECIFICITY.id)) {
                arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SPECIFICITY.id);
                args3 = CommandLineUtils.splitInput(arg16);
                specificities = new ArrayList(args3.size());
                for (String stringValue : args3) {
                    ((ArrayList)((Object)specificities)).add((String)((Object)DigestionPreferences.Specificity.getSpecificity(new Integer(stringValue))));
                }
            }
            for (int i = 0; i < enzymes.size(); ++i) {
                String enzymeName = enzymes.get(i);
                enzyme = this.enzymeFactory.getEnzyme(enzymeName);
                digestionPreferences.addEnzyme(enzyme);
                Integer mc = mcs != null ? (Integer)mcs.get(i) : Integer.valueOf(2);
                digestionPreferences.setnMissedCleavages(enzymeName, mc);
                specificity = specificities != null ? (DigestionPreferences.Specificity)((Object)((ArrayList)((Object)specificities)).get(i)) : DigestionPreferences.Specificity.specific;
                digestionPreferences.setSpecificity(enzymeName, specificity);
            }
        } else if (digestionPreferences.getCleavagePreference() != null && digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme && !digestionPreferences.hasEnzymes()) {
            String enzymeName = "Trypsin";
            Enzyme enzyme2 = this.enzymeFactory.getEnzyme(enzymeName);
            digestionPreferences.addEnzyme(enzyme2);
            digestionPreferences.setnMissedCleavages(enzymeName, 2);
            digestionPreferences.setSpecificity(enzymeName, DigestionPreferences.Specificity.specific);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DB.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DB.id);
            File fastaFile = new File(arg16);
            searchParameters.setFastaFile(fastaFile);
            if (this.identificationParameters != null && !this.commandLine.hasOption(IdentificationParametersCLIParams.DB_PI.id)) {
                ProteinInferencePreferences proteinInferencePreferences = this.identificationParameters.getProteinInferencePreferences();
                proteinInferencePreferences.setProteinSequenceDatabase(fastaFile);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FI.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FI.id);
            args2 = CommandLineUtils.splitInput(arg16);
            ions = new ArrayList<Integer>(args2.size());
            for (String ionName : args2) {
                ions.add(PeptideFragmentIon.getIonType(ionName));
            }
            searchParameters.setForwardIons(ions);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.RI.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.RI.id);
            args2 = CommandLineUtils.splitInput(arg16);
            ions = new ArrayList(args2.size());
            for (String ionName : args2) {
                ions.add(PeptideFragmentIon.getIonType(ionName));
            }
            searchParameters.setRewindIons(ions);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id);
            option13 = new Integer(arg16);
            searchParameters.setMinChargeSearched(new Charge(1, option13));
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id)) {
            arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id);
            option13 = new Integer(arg16);
            searchParameters.setMaxChargeSearched(new Charge(1, option13));
        }
        if ((ptmSettings = searchParameters.getPtmSettings()) == null) {
            ptmSettings = new PtmSettings();
            searchParameters.setPtmSettings(ptmSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            arg15 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            ptmSettings.clearFixedModifications();
            args = CommandLineUtils.splitInput(arg15);
            for (String ptmName : args) {
                modification = this.ptmFactory.getPTM(ptmName);
                ptmSettings.addFixedModification(modification);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg15 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            ptmSettings.clearVariableModifications();
            args = CommandLineUtils.splitInput(arg15);
            for (String ptmName : args) {
                modification = this.ptmFactory.getPTM(ptmName);
                ptmSettings.addVariableModification(modification);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MIN_ISOTOPE.id)) {
            arg15 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MIN_ISOTOPE.id);
            option12 = new Integer(arg15);
            searchParameters.setMinIsotopicCorrection(option12);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MAX_ISOTOPE.id)) {
            arg15 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MAX_ISOTOPE.id);
            option12 = new Integer(arg15);
            searchParameters.setMaxIsotopicCorrection(option12);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.omssa.getIndex()))) == null) {
            omssaParameters = new OmssaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, omssaParameters);
        } else {
            omssaParameters = (OmssaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id)) {
            String arg18 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id);
            option11 = new Integer(arg18);
            omssaParameters.setRemovePrecursor((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id)) {
            String arg19 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id);
            option11 = new Integer(arg19);
            omssaParameters.setScalePrecursor((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id)) {
            String arg20 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id);
            option11 = new Integer(arg20);
            omssaParameters.setEstimateCharge((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id)) {
            String arg21 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id);
            option11 = new Double(arg21);
            omssaParameters.setMaxEValue((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id)) {
            String arg22 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id);
            option11 = new Integer(arg22);
            omssaParameters.setHitListLength((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id)) {
            String arg23 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id);
            option11 = new Integer(arg23);
            omssaParameters.setMinPeptideLength((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id)) {
            String arg24 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id);
            option11 = new Integer(arg24);
            omssaParameters.setMaxPeptideLength((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id)) {
            String arg25 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id);
            option11 = new Integer(arg25);
            omssaParameters.setSelectedOutput(OmssaParameters.getOmssaOutputTypes()[(Integer)option11]);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id)) {
            String arg26 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id);
            option11 = new Integer(arg26);
            omssaParameters.setMemoryMappedSequenceLibraries((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id)) {
            String arg27 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id);
            option11 = new Double(arg27);
            omssaParameters.setNeutronThreshold((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id)) {
            String arg28 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id);
            option11 = new Double(arg28);
            omssaParameters.setLowIntensityCutOff((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id)) {
            String arg29 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id);
            option11 = new Double(arg29);
            omssaParameters.setHighIntensityCutOff((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id)) {
            String arg30 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id);
            option11 = new Double(arg30);
            omssaParameters.setIntensityCutOffIncrement((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id)) {
            String arg31 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id);
            option11 = new Integer(arg31);
            omssaParameters.setSingleChargeWindow((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id)) {
            String arg32 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id);
            option11 = new Integer(arg32);
            omssaParameters.setDoubleChargeWindow((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id)) {
            String arg33 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id);
            option11 = new Integer(arg33);
            omssaParameters.setnPeaksInSingleChargeWindow((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id)) {
            String arg34 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id);
            option11 = new Integer(arg34);
            omssaParameters.setnPeaksInDoubleChargeWindow((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id)) {
            String arg35 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id);
            option11 = new Integer(arg35);
            omssaParameters.setnAnnotatedMostIntensePeaks((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id)) {
            String arg36 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id);
            option11 = new Integer(arg36);
            omssaParameters.setMinAnnotatedPeaks((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id)) {
            String arg37 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id);
            option11 = new Integer(arg37);
            omssaParameters.setMinPeaks((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id)) {
            String arg38 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id);
            option11 = new Integer(arg38);
            omssaParameters.setCleaveNterMethionine((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id)) {
            String arg39 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id);
            option11 = new Integer(arg39);
            omssaParameters.setMaxMzLadders((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id)) {
            String arg40 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id);
            option11 = new Integer(arg40);
            omssaParameters.setMaxFragmentCharge((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id)) {
            String arg41 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id);
            option11 = new Double(arg41);
            omssaParameters.setFractionOfPeaksForChargeEstimation((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id)) {
            String arg42 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id);
            option11 = new Integer(arg42);
            omssaParameters.setDetermineChargePlusOneAlgorithmically((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id)) {
            String arg43 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id);
            option11 = new Integer(arg43);
            omssaParameters.setSearchPositiveIons((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id)) {
            String arg44 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id);
            option11 = new Integer(arg44);
            omssaParameters.setMinPrecPerSpectrum((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id)) {
            String arg45 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id);
            option11 = new Integer(arg45);
            omssaParameters.setSearchForwardFragmentFirst((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id)) {
            String arg46 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id);
            option11 = new Integer(arg46);
            omssaParameters.setSearchRewindFragments((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id)) {
            String arg47 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id);
            option11 = new Integer(arg47);
            omssaParameters.setMaxFragmentPerSeries((Integer)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id)) {
            String arg48 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id);
            option11 = new Integer(arg48);
            omssaParameters.setUseCorrelationCorrectionScore((Integer)option11 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id)) {
            String arg49 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id);
            option11 = new Double(arg49);
            omssaParameters.setConsecutiveIonProbability((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id)) {
            String arg50 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id);
            option11 = new Double(arg50);
            omssaParameters.setIterativeSequenceEvalue((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id)) {
            String arg51 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id);
            option11 = new Double(arg51);
            omssaParameters.setIterativeSpectrumEvalue((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id)) {
            String arg52 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id);
            option11 = new Double(arg52);
            omssaParameters.setIterativeReplaceEvalue((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id)) {
            String arg53 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id);
            option11 = new Integer(arg53);
            omssaParameters.setMaxFragmentPerSeries((Integer)option11);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.xtandem.getIndex()))) == null) {
            xtandemParameters = new XtandemParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, xtandemParameters);
        } else {
            xtandemParameters = (XtandemParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id);
            option10 = new Double(arg14);
            xtandemParameters.setDynamicRange((Double)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setnPeaks((Integer)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id);
            option10 = new Double(arg14);
            xtandemParameters.setMinFragmentMz((Double)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setMinPeaksPerSpectrum((Integer)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id);
            option10 = new Integer(arg14);
            xtandemParameters.setUseNoiseSuppression((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id);
            option10 = new Double(arg14);
            xtandemParameters.setMinPrecursorMass((Double)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id);
            option10 = new Integer(arg14);
            xtandemParameters.setProteinQuickAcetyl((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id);
            option10 = new Integer(arg14);
            xtandemParameters.setQuickPyrolidone((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setStpBias((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefine((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id);
            option10 = new Double(arg14);
            xtandemParameters.setMaximumExpectationValueRefinement((Double)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefineUnanticipatedCleavages((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefineSemi((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id);
            option10 = new Integer(arg14);
            xtandemParameters.setPotentialModificationsForFullRefinment((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefinePointMutations((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefineSnaps((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id);
            option10 = new Integer(arg14);
            xtandemParameters.setRefineSpectrumSynthesis((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id);
            option10 = new Double(arg14);
            xtandemParameters.setMaxEValue((Double)option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id);
            xtandemParameters.setOutputResults(arg14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id);
            xtandemParameters.setOutputResults(arg14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id);
            option10 = new Integer(arg14);
            xtandemParameters.setOutputSequences((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id);
            option10 = new Integer(arg14);
            xtandemParameters.setOutputSpectra((Integer)option10 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id)) {
            arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id);
            xtandemParameters.setSkylinePath(arg14);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.msgf.getIndex()))) == null) {
            msgfParameters = new MsgfParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, msgfParameters);
        } else {
            msgfParameters = (MsgfParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_DECOY.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_DECOY.id);
            option9 = new Integer(arg13);
            msgfParameters.setSearchDecoyDatabase(option9 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id);
            Integer instrumentID = new Integer(arg13);
            msgfParameters.setInstrumentID(instrumentID);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id);
            option9 = new Integer(arg13);
            msgfParameters.setFragmentationType(option9);
        } else {
            Integer instrumentId = msgfParameters.getInstrumentID();
            if (instrumentId == 1 || instrumentId == 3) {
                msgfParameters.setFragmentationType(3);
            } else {
                msgfParameters.setFragmentationType(0);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_PROTOCOL.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PROTOCOL.id);
            option9 = new Integer(arg13);
            msgfParameters.setProtocol(option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id);
            option9 = new Integer(arg13);
            msgfParameters.setMinPeptideLength(option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id);
            option9 = new Integer(arg13);
            msgfParameters.setMaxPeptideLength(option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id);
            option9 = new Integer(arg13);
            msgfParameters.setNumberOfSpectrumMarches(option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id);
            option9 = new Integer(arg13);
            msgfParameters.setAdditionalOutput(option9 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_TERMINI.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TERMINI.id);
            option9 = new Integer(arg13);
            msgfParameters.setNumberTolerableTermini(option9);
        } else if (digestionPreferences.getCleavagePreference() != null && digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            enzyme = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme.getName();
            specificity = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity) {
                case specific: {
                    msgfParameters.setNumberTolerableTermini(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    msgfParameters.setNumberTolerableTermini(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity) + " not supported.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_PTMS.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PTMS.id);
            option9 = new Integer(arg13);
            msgfParameters.setNumberOfPtmsPerPeptide(option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_TASKS.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TASKS.id);
            option9 = new Integer(arg13);
            msgfParameters.setNumberOfTasks(option9);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.myriMatch.getIndex()))) == null) {
            myriMatchParameters = new MyriMatchParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, myriMatchParameters);
        } else {
            myriMatchParameters = (MyriMatchParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setMinPeptideLength((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setMaxPeptideLength((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id);
            option8 = new Double(arg12);
            myriMatchParameters.setMinPrecursorMass((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id);
            option8 = new Double(arg12);
            myriMatchParameters.setMaxPrecursorMass((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setNumberOfSpectrumMatches((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setMaxDynamicMods((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id);
            myriMatchParameters.setFragmentationRule(arg12);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setMinTerminiCleavages((Integer)option8);
        } else if (digestionPreferences.getCleavagePreference() != null && digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            Enzyme enzyme3 = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme3.getName();
            DigestionPreferences.Specificity specificity2 = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity2) {
                case specific: {
                    myriMatchParameters.setMinTerminiCleavages(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    myriMatchParameters.setMinTerminiCleavages(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity2) + " not supported.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setUseSmartPlusThreeModel((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setComputeXCorr((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id);
            option8 = new Double(arg12);
            myriMatchParameters.setTicCutoffPercentage((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setNumIntensityClasses((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setClassSizeMultiplier((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setNumberOfBatches((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id);
            option8 = new Integer(arg12);
            myriMatchParameters.setMaxPeakCount((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id);
            myriMatchParameters.setOutputFormat(arg12);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.msAmanda.getIndex()))) == null) {
            msAmandaParameters = new MsAmandaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, msAmandaParameters);
        } else {
            msAmandaParameters = (MsAmandaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id);
            option7 = new Integer(arg11);
            msAmandaParameters.setGenerateDecoyDatabase(option7 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id);
            msAmandaParameters.setInstrumentID(arg11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id);
            option7 = new Integer(arg11);
            msAmandaParameters.setMaxRank(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id);
            option7 = new Integer(arg11);
            msAmandaParameters.setMonoIsotopic(option7 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOW_MEM_MODE.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOW_MEM_MODE.id);
            option7 = new Integer(arg11);
            msAmandaParameters.setLowMemoryMode(option7 == 1);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.comet.getIndex()))) == null) {
            cometParameters = new CometParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, cometParameters);
        } else {
            cometParameters = (CometParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id);
            option6 = new Integer(arg10);
            cometParameters.setNumberOfSpectrumMatches((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_PTMS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_PTMS.id);
            option6 = new Integer(arg10);
            cometParameters.setMaxVariableMods((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REQ_PTMS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REQ_PTMS.id);
            option6 = new Integer(arg10);
            cometParameters.setRequireVariableMods((Integer)option6 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id);
            option6 = new Integer(arg10);
            cometParameters.setMinPeaks((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id);
            option6 = new Double(arg10);
            cometParameters.setMinPeakIntensity((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id);
            option6 = new Integer(arg10);
            cometParameters.setRemovePrecursor((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id);
            option6 = new Double(arg10);
            cometParameters.setRemovePrecursorTolerance((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id);
            option6 = new Double(arg10);
            cometParameters.setLowerClearMzRange((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id);
            option6 = new Double(arg10);
            cometParameters.setUpperClearMzRange((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id);
            option6 = new Integer(arg10);
            cometParameters.setEnzymeType((Integer)option6);
        } else if (digestionPreferences.getCleavagePreference() != null && digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            Enzyme enzyme4 = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme4.getName();
            DigestionPreferences.Specificity specificity3 = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity3) {
                case specific: {
                    cometParameters.setEnzymeType(2);
                    break;
                }
                case semiSpecific: {
                    cometParameters.setEnzymeType(1);
                    break;
                }
                case specificNTermOnly: {
                    cometParameters.setEnzymeType(8);
                    break;
                }
                case specificCTermOnly: {
                    cometParameters.setEnzymeType(9);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity3) + " not supported.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id);
            option6 = new Integer(arg10);
            cometParameters.setIsotopeCorrection((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id);
            option6 = new Double(arg10);
            cometParameters.setMinPrecursorMass((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id);
            option6 = new Double(arg10);
            cometParameters.setMaxPrecursorMass((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id);
            option6 = new Integer(arg10);
            cometParameters.setMaxFragmentCharge((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_METH.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_METH.id);
            option6 = new Integer(arg10);
            cometParameters.setRemoveMethionine((Integer)option6 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id);
            option6 = new Integer(arg10);
            cometParameters.setBatchSize((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id);
            option6 = new Integer(arg10);
            cometParameters.setTheoreticalFragmentIonsSumOnly((Integer)option6 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id);
            option6 = new Double(arg10);
            cometParameters.setFragmentBinOffset((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_OUTPUT.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_OUTPUT.id);
            if (arg10.equalsIgnoreCase(CometParameters.CometOutputFormat.PepXML.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.PepXML);
            } else if (arg10.equalsIgnoreCase(CometParameters.CometOutputFormat.Percolator.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.Percolator);
            } else if (arg10.equalsIgnoreCase(CometParameters.CometOutputFormat.SQT.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.SQT);
            } else if (arg10.equalsIgnoreCase(CometParameters.CometOutputFormat.TXT.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.TXT);
            }
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.tide.getIndex()))) == null) {
            tideParameters = new TideParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, tideParameters);
        } else {
            tideParameters = (TideParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS.id);
            option5 = new Integer(arg9);
            tideParameters.setMaxVariablePtmsPerPeptide((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id);
            option5 = new Integer(arg9);
            tideParameters.setMaxVariablePtmsPerTypePerPeptide((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id);
            option5 = new Integer(arg9);
            tideParameters.setMinPeptideLength((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id);
            option5 = new Integer(arg9);
            tideParameters.setMaxPeptideLength((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id);
            option5 = new Double(arg9);
            tideParameters.setMinPrecursorMass((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id);
            option5 = new Double(arg9);
            tideParameters.setMaxPrecursorMass((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id);
            tideParameters.setDecoyFormat(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id);
            tideParameters.setKeepTerminalAminoAcids(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id);
            option5 = new Integer(arg9);
            tideParameters.setDecoySeed((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id);
            tideParameters.setOutputFolderName(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id);
            option5 = new Integer(arg9);
            tideParameters.setPrintPeptides((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_VERBOSITY.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_VERBOSITY.id);
            option5 = new Integer(arg9);
            tideParameters.setVerbosity((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id);
            option5 = new Integer(arg9);
            tideParameters.setMonoisotopicPrecursor((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id);
            option5 = new Integer(arg9);
            tideParameters.setClipNtermMethionine((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id);
            tideParameters.setDigestionType(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id);
            option5 = new Integer(arg9);
            tideParameters.setComputeSpScore((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id);
            option5 = new Integer(arg9);
            tideParameters.setNumberOfSpectrumMatches((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id);
            option5 = new Integer(arg9);
            tideParameters.setComputeExactPValues((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id);
            option5 = new Double(arg9);
            tideParameters.setMinSpectrumMz((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id);
            option5 = new Double(arg9);
            tideParameters.setMaxSpectrumMz((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id);
            option5 = new Integer(arg9);
            tideParameters.setMinSpectrumPeaks((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id);
            tideParameters.setSpectrumCharges(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id);
            option5 = new Integer(arg9);
            tideParameters.setRemovePrecursor((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id);
            option5 = new Double(arg9);
            tideParameters.setRemovePrecursorTolerance((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id);
            option5 = new Integer(arg9);
            tideParameters.setPrintProgressIndicatorSize((Integer)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id);
            option5 = new Integer(arg9);
            tideParameters.setUseFlankingPeaks((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id);
            option5 = new Integer(arg9);
            tideParameters.setUseNeutralLossPeaks((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id);
            option5 = new Double(arg9);
            tideParameters.setMzBinWidth((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id);
            option5 = new Double(arg9);
            tideParameters.setMzBinOffset((Double)option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_CONCAT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CONCAT.id);
            option5 = new Integer(arg9);
            tideParameters.setConcatenatTargetDecoy((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id);
            tideParameters.setStoreSpectraFileName(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id);
            option5 = new Integer(arg9);
            tideParameters.setTextOutput((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id);
            option5 = new Integer(arg9);
            tideParameters.setSqtOutput((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id);
            option5 = new Integer(arg9);
            tideParameters.setPepXmlOutput((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id);
            option5 = new Integer(arg9);
            tideParameters.setMzidOutput((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id);
            option5 = new Integer(arg9);
            tideParameters.setPinOutput((Integer)option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id);
            option5 = new Integer(arg9);
            tideParameters.setRemoveTempFolders((Integer)option5 == 1);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.andromeda.getIndex()))) == null) {
            andromedaParameters = new AndromedaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, andromedaParameters);
        } else {
            andromedaParameters = (AndromedaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id);
            option4 = new Double(arg8);
            andromedaParameters.setMaxPeptideMass((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id);
            option4 = new Integer(arg8);
            andromedaParameters.setMaxCombinations((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id);
            option4 = new Integer(arg8);
            andromedaParameters.setTopPeaksWindow((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id);
            option4 = new Integer(arg8);
            andromedaParameters.setIncludeWater((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id);
            option4 = new Integer(arg8);
            andromedaParameters.setIncludeAmmonia((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id);
            option4 = new Integer(arg8);
            andromedaParameters.setDependentLosses((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id);
            option4 = new Integer(arg8);
            andromedaParameters.setFragmentAll((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id);
            option4 = new Integer(arg8);
            andromedaParameters.setEmpiricalCorrection((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id);
            option4 = new Integer(arg8);
            andromedaParameters.setHigherCharge((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id);
            if (arg8.equalsIgnoreCase("CID")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.CID);
            } else if (arg8.equalsIgnoreCase("HCD")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.HCD);
            } else if (arg8.equalsIgnoreCase("ETD")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.ETD);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id);
            option4 = new Integer(arg8);
            andromedaParameters.setMaxNumberOfModifications((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id);
            option4 = new Integer(arg8);
            andromedaParameters.setMinPeptideLengthNoEnzyme((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id);
            option4 = new Integer(arg8);
            andromedaParameters.setMaxPeptideLengthNoEnzyme((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id);
            option4 = new Integer(arg8);
            andromedaParameters.setEqualIL((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id);
            option4 = new Integer(arg8);
            andromedaParameters.setNumberOfCandidates((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id);
            if (arg8.equalsIgnoreCase("none")) {
                andromedaParameters.setDecoyMode(AndromedaParameters.AndromedaDecoyMode.none);
            } else if (arg8.equalsIgnoreCase("reverse")) {
                andromedaParameters.setDecoyMode(AndromedaParameters.AndromedaDecoyMode.reverse);
            }
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.pepnovo.getIndex()))) == null) {
            pepnovoParameters = new PepnovoParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, pepnovoParameters);
        } else {
            pepnovoParameters = (PepnovoParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setHitListLength(option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setEstimateCharge(option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setCorrectPrecursorMass(option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setDiscardLowQualitySpectra(option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setDiscardLowQualitySpectra(option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id);
            pepnovoParameters.setFragmentationModel(arg7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id);
            option3 = new Integer(arg7);
            pepnovoParameters.setGenerateQuery(option3 == 1);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.direcTag.getIndex()))) == null) {
            direcTagParameters = new DirecTagParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, direcTagParameters);
        } else {
            direcTagParameters = (DirecTagParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id);
            option2 = new Integer(arg6);
            direcTagParameters.setTicCutoffPercentage(((Integer)option2).intValue());
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id);
            option2 = new Integer(arg6);
            direcTagParameters.setMaxPeakCount((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id);
            option2 = new Integer(arg6);
            direcTagParameters.setNumIntensityClasses((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id);
            option2 = new Integer(arg6);
            direcTagParameters.setAdjustPrecursorMass((Integer)option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id);
            option2 = new Double(arg6);
            direcTagParameters.setMinPrecursorAdjustment((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id);
            option2 = new Double(arg6);
            direcTagParameters.setMaxPrecursorAdjustment((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id);
            option2 = new Double(arg6);
            direcTagParameters.setPrecursorAdjustmentStep((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id);
            option2 = new Integer(arg6);
            direcTagParameters.setNumChargeStates((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id);
            direcTagParameters.setOutputSuffix(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id);
            option2 = new Integer(arg6);
            direcTagParameters.setUseChargeStateFromMS((Integer)option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id);
            option2 = new Integer(arg6);
            direcTagParameters.setDuplicateSpectra((Integer)option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id);
            option2 = new Integer(arg6);
            direcTagParameters.setDeisotopingMode((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id);
            option2 = new Double(arg6);
            direcTagParameters.setIsotopeMzTolerance((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id);
            option2 = new Double(arg6);
            direcTagParameters.setComplementMzTolerance((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id);
            option2 = new Integer(arg6);
            direcTagParameters.setTagLength((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id);
            option2 = new Integer(arg6);
            direcTagParameters.setMaxDynamicMods((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id);
            option2 = new Integer(arg6);
            direcTagParameters.setMaxTagCount((Integer)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id);
            option2 = new Double(arg6);
            direcTagParameters.setIntensityScoreWeight((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id);
            option2 = new Double(arg6);
            direcTagParameters.setMzFidelityScoreWeight((Double)option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id);
            option2 = new Double(arg6);
            direcTagParameters.setComplementScoreWeight((Double)option2);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.pNovo.getIndex()))) == null) {
            pNovoParameters = new PNovoParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, pNovoParameters);
        } else {
            pNovoParameters = (PNovoParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id);
            option = new Integer(arg5);
            pNovoParameters.setNumberOfPeptides(option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id);
            option = new Integer(arg5);
            pNovoParameters.setLowerPrecursorMass(option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id);
            option = new Integer(arg5);
            pNovoParameters.setUpperPrecursorMass(option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id);
            pNovoParameters.setActicationType(arg5);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.novor.getIndex()))) == null) {
            novorParameters = new NovorParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, novorParameters);
        } else {
            novorParameters = (NovorParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id);
            novorParameters.setFragmentationMethod(arg4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id);
            novorParameters.setMassAnalyzer(arg4);
        }
        if (this.identificationParameters != null) {
            this.identificationParameters.setSearchParameters(searchParameters);
        } else {
            this.identificationParameters = new IdentificationParameters(searchParameters);
        }
        if (this.identificationParameters.getName() == null && this.destinationFile != null) {
            this.identificationParameters.setName(this.destinationFile.getName().substring(0, this.destinationFile.getName().lastIndexOf(".")));
        }
        if ((genePreferences = this.identificationParameters.getGenePreferences()) == null) {
            genePreferences = new GenePreferences();
            this.identificationParameters.setGenePreferences(genePreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.USE_GENE_MAPPING.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.USE_GENE_MAPPING.id);
            intValue2 = new Integer(arg3);
            switch (intValue2) {
                case 1: {
                    value4 = true;
                    break;
                }
                case 0: {
                    value4 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.USE_GENE_MAPPING.id + ": " + arg3 + ". 0 or 1 expected.");
                }
            }
            genePreferences.setUseGeneMapping(value4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id);
            intValue2 = new Integer(arg3);
            switch (intValue2) {
                case 1: {
                    value4 = true;
                    break;
                }
                case 0: {
                    value4 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id + ": " + arg3 + ". 0 or 1 expected.");
                }
            }
            genePreferences.setAutoUpdate(value4);
        }
        if ((annotationSettings = this.identificationParameters.getAnnotationPreferences()) == null) {
            annotationSettings = new AnnotationSettings(searchParameters);
            this.identificationParameters.setAnnotationSettings(annotationSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id)) {
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id);
            Double value5 = new Double(arg2);
            annotationSettings.setIntensityLimit(value5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id)) {
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id);
            Double value6 = new Double(arg2);
            annotationSettings.setFragmentIonAccuracy(value6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id)) {
            boolean value7;
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id);
            Integer intValue3 = new Integer(arg2);
            switch (intValue3) {
                case 1: {
                    value7 = true;
                    break;
                }
                case 0: {
                    value7 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id + ": " + arg2 + ". 0 or 1 expected.");
                }
            }
            SpectrumAnnotator.TiesResolution tiesResolution = value7 ? SpectrumAnnotator.TiesResolution.mostAccurateMz : SpectrumAnnotator.TiesResolution.mostIntense;
            annotationSettings.setTiesResolution(tiesResolution);
        }
        if ((sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingPreferences()) == null) {
            sequenceMatchingPreferences = new SequenceMatchingPreferences();
            this.identificationParameters.setSequenceMatchingPreferences(sequenceMatchingPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_INDEX_TYPE.id)) {
            String arg54 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_INDEX_TYPE.id);
            Integer intValue4 = new Integer(arg54);
            value3 = PeptideMapperType.getPeptideMapperType(intValue4);
            sequenceMatchingPreferences.setPeptideMapperType((PeptideMapperType)((Object)value3));
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id)) {
            String arg55 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id);
            Integer intValue5 = new Integer(arg55);
            value3 = SequenceMatchingPreferences.MatchingType.getMatchingType(intValue5);
            sequenceMatchingPreferences.setSequenceMatchingType((SequenceMatchingPreferences.MatchingType)((Object)value3));
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id)) {
            String arg56 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id);
            Double value8 = new Double(arg56);
            sequenceMatchingPreferences.setLimitX(value8);
        }
        PeptideAssumptionFilter peptideAssumptionFilter = this.identificationParameters.getPeptideAssumptionFilter();
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id)) {
            String arg57 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id);
            value3 = new Integer(arg57);
            peptideAssumptionFilter.setMinPepLength((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id)) {
            String arg58 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id);
            value3 = new Integer(arg58);
            peptideAssumptionFilter.setMaxPepLength((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MIN.id)) {
            String arg59 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MIN.id);
            value3 = new Integer(arg59);
            peptideAssumptionFilter.setMinMissedCleavages((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MAX.id)) {
            String arg60 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MAX.id);
            value3 = new Integer(arg60);
            peptideAssumptionFilter.setMaxMissedCleavages((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id)) {
            String arg61 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id);
            value3 = new Double(arg61);
            peptideAssumptionFilter.setMaxMzDeviation((Double)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id)) {
            String arg62 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id);
            Integer option15 = new Integer(arg62);
            switch (option15) {
                case 1: {
                    peptideAssumptionFilter.setIsPpm(true);
                    break;
                }
                case 0: {
                    peptideAssumptionFilter.setIsPpm(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id + ": " + arg62 + ". 0 or 1 expected.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id)) {
            boolean value9;
            String arg63 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id);
            Integer intValue6 = new Integer(arg63);
            switch (intValue6) {
                case 1: {
                    value9 = true;
                    break;
                }
                case 0: {
                    value9 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id + ": " + arg63 + ". 0 or 1 expected.");
                }
            }
            peptideAssumptionFilter.setRemoveUnknownPTMs(value9);
        }
        if ((ptmScoringPreferences = this.identificationParameters.getPtmScoringPreferences()) == null) {
            ptmScoringPreferences = new PTMScoringPreferences();
            this.identificationParameters.setPtmScoringPreferences(ptmScoringPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_SCORE.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_SCORE.id);
            Integer intValue7 = new Integer(arg);
            PtmScore ptmScore = PtmScore.getScore(intValue7);
            if (ptmScore == PtmScore.None) {
                ptmScoringPreferences.setProbabilitsticScoreCalculation(false);
            } else {
                ptmScoringPreferences.setProbabilitsticScoreCalculation(true);
                ptmScoringPreferences.setSelectedProbabilisticScore(ptmScore);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_THRESHOLD.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_THRESHOLD.id);
            Double value10 = new Double(arg);
            ptmScoringPreferences.setEstimateFlr(false);
            ptmScoringPreferences.setProbabilisticScoreThreshold(value10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id)) {
            boolean value11;
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id);
            Integer intValue8 = new Integer(arg);
            switch (intValue8) {
                case 1: {
                    value11 = true;
                    break;
                }
                case 0: {
                    value11 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id + ": " + arg + ". 0 or 1 expected.");
                }
            }
            ptmScoringPreferences.setProbabilisticScoreNeutralLosses(value11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id);
            Integer intValue9 = new Integer(arg);
            SequenceMatchingPreferences.MatchingType value12 = SequenceMatchingPreferences.MatchingType.getMatchingType(intValue9);
            SequenceMatchingPreferences ptmSequenceMatchingPreferences = new SequenceMatchingPreferences();
            ptmSequenceMatchingPreferences.setLimitX(sequenceMatchingPreferences.getLimitX());
            ptmSequenceMatchingPreferences.setSequenceMatchingType(value12);
            ptmScoringPreferences.setSequenceMatchingPreferences(ptmSequenceMatchingPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_ALIGNMENT.id)) {
            boolean value13;
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_ALIGNMENT.id);
            Integer intValue10 = new Integer(arg);
            switch (intValue10) {
                case 1: {
                    value13 = true;
                    break;
                }
                case 0: {
                    value13 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.PTM_ALIGNMENT.id + ": " + arg + ". 0 or 1 expected.");
                }
            }
            ptmScoringPreferences.setAlignNonConfidentPTMs(value13);
        }
        ProteinInferencePreferences proteinInferencePreferences = this.identificationParameters.getProteinInferencePreferences();
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DB_PI.id)) {
            String arg64 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DB_PI.id);
            File fastaFile = new File(arg64);
            proteinInferencePreferences.setProteinSequenceDatabase(fastaFile);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id)) {
            boolean value14;
            String arg65 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id);
            Integer intValue11 = new Integer(arg65);
            switch (intValue11) {
                case 1: {
                    value14 = true;
                    break;
                }
                case 0: {
                    value14 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id + ": " + arg65 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroups(value14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id)) {
            boolean value15;
            String arg66 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id);
            Integer intValue12 = new Integer(arg66);
            switch (intValue12) {
                case 1: {
                    value15 = true;
                    break;
                }
                case 0: {
                    value15 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_SCORE.id + ": " + arg66 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsScore(value15);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id)) {
            boolean value16;
            String arg67 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id);
            Integer intValue13 = new Integer(arg67);
            switch (intValue13) {
                case 1: {
                    value16 = true;
                    break;
                }
                case 0: {
                    value16 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id + ": " + arg67 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsEnzymaticity(value16);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id)) {
            boolean value17;
            String arg68 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id);
            Integer intValue14 = new Integer(arg68);
            switch (intValue14) {
                case 1: {
                    value17 = true;
                    break;
                }
                case 0: {
                    value17 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id + ": " + arg68 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsEvidence(value17);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id)) {
            boolean value18;
            String arg69 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id);
            Integer intValue15 = new Integer(arg69);
            switch (intValue15) {
                case 1: {
                    value18 = true;
                    break;
                }
                case 0: {
                    value18 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_UNCHARACTERIZED.id + ": " + arg69 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsUncharacterized(value18);
        }
        if ((idMatchValidationPreferences = this.identificationParameters.getIdValidationPreferences()) == null) {
            idMatchValidationPreferences = new IdMatchValidationPreferences();
            this.identificationParameters.setIdValidationPreferences(idMatchValidationPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PSM_FDR.id)) {
            String arg70 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PSM_FDR.id);
            value2 = new Double(arg70);
            idMatchValidationPreferences.setDefaultPsmFDR(value2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPTIDE_FDR.id)) {
            String arg71 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPTIDE_FDR.id);
            value2 = new Double(arg71);
            idMatchValidationPreferences.setDefaultPeptideFDR(value2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FDR.id)) {
            String arg72 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FDR.id);
            value2 = new Double(arg72);
            idMatchValidationPreferences.setDefaultProteinFDR(value2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEPARATE_PSMs.id)) {
            String arg73 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEPARATE_PSMs.id);
            intValue = new Integer(arg73);
            switch (intValue) {
                case 1: {
                    value = true;
                    break;
                }
                case 0: {
                    value = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SEPARATE_PSMs.id + ": " + arg73 + ". 0 or 1 expected.");
                }
            }
            idMatchValidationPreferences.setSeparatePsms(value);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEPARATE_PEPTIDES.id)) {
            String arg74 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEPARATE_PEPTIDES.id);
            intValue = new Integer(arg74);
            switch (intValue) {
                case 1: {
                    value = true;
                    break;
                }
                case 0: {
                    value = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SEPARATE_PEPTIDES.id + ": " + arg74 + ". 0 or 1 expected.");
                }
            }
            idMatchValidationPreferences.setSeparatePeptides(value);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MERGE_SUBGROUPS.id)) {
            String arg75 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MERGE_SUBGROUPS.id);
            intValue = new Integer(arg75);
            switch (intValue) {
                case 1: {
                    value = true;
                    break;
                }
                case 0: {
                    value = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.MERGE_SUBGROUPS.id + ": " + arg75 + ". 0 or 1 expected.");
                }
            }
            idMatchValidationPreferences.setMergeSmallSubgroups(value);
        }
        if ((fractionSettings = this.identificationParameters.getFractionSettings()) == null) {
            fractionSettings = new FractionSettings();
            this.identificationParameters.setFractionSettings(fractionSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id)) {
            String arg76 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id);
            Double value19 = new Double(arg76);
            fractionSettings.setProteinConfidenceMwPlots(value19);
        }
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParameters;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public Boolean isListMods() {
        return this.listMods;
    }

    public Boolean isListEnzymes() {
        return this.listEnzymes;
    }

    public static boolean isValidModifications(CommandLine aLine) throws IOException {
        PTM ptm;
        ArrayList<String> args;
        String arg;
        boolean error = false;
        if (aLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = PTMFactory.getInstance().getPTM(ptmName);
                    if (ptm != null && ptm != PTMFactory.unknownPTM) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (IllegalArgumentException e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the fixed modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                error = true;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = PTMFactory.getInstance().getPTM(ptmName);
                    if (ptm != null && ptm != PTMFactory.unknownPTM) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (IllegalArgumentException e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the variable modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                error = true;
            }
        }
        return !error;
    }
}

