/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Enzyme
extends ExperimentObject {
    static final long serialVersionUID = -1852087173903613377L;
    private int id;
    private String name;
    private ArrayList<Character> aminoAcidBefore = new ArrayList(0);
    private ArrayList<Character> aminoAcidAfter = new ArrayList(0);
    private ArrayList<Character> restrictionBefore = new ArrayList(0);
    private ArrayList<Character> restrictionAfter = new ArrayList(0);
    private HashSet<Character> aminoAcidBeforeSet = new HashSet(0);
    private HashSet<Character> aminoAcidAfterSet = new HashSet(0);
    private HashSet<Character> restrictionBeforeSet = new HashSet(0);
    private HashSet<Character> restrictionAfterSet = new HashSet(0);
    private Boolean isSemiSpecific = false;
    private Boolean isWholeProtein = false;
    private CvTerm cvTerm;

    public Enzyme(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public void backwardCompatibilityFix() {
        if (this.aminoAcidAfterSet == null && this.aminoAcidAfter != null) {
            this.aminoAcidAfterSet = new HashSet<Character>(this.aminoAcidAfter);
        }
        if (this.aminoAcidBeforeSet == null && this.aminoAcidBefore != null) {
            this.aminoAcidBeforeSet = new HashSet<Character>(this.aminoAcidBefore);
        }
        if (this.restrictionAfterSet == null && this.restrictionAfter != null) {
            this.restrictionAfterSet = new HashSet<Character>(this.restrictionAfter);
        }
        if (this.restrictionBeforeSet == null && this.restrictionBefore != null) {
            this.restrictionBeforeSet = new HashSet<Character>(this.restrictionBefore);
        }
    }

    public void addAminoAcidAfter(Character aminoAcid) {
        this.aminoAcidAfterSet.add(aminoAcid);
    }

    public HashSet<Character> getAminoAcidAfter() {
        return this.aminoAcidAfterSet;
    }

    public void addAminoAcidBefore(Character aminoAcid) {
        this.aminoAcidBeforeSet.add(aminoAcid);
    }

    public HashSet<Character> getAminoAcidBefore() {
        return this.aminoAcidBeforeSet;
    }

    public void addRestrictionAfter(Character aminoAcid) {
        this.restrictionAfterSet.add(aminoAcid);
    }

    public HashSet<Character> getRestrictionAfter() {
        return this.restrictionAfterSet;
    }

    public void addRestrictionBefore(Character aminoAcid) {
        this.restrictionBeforeSet.add(aminoAcid);
    }

    public HashSet<Character> getRestrictionBefore() {
        return this.restrictionBeforeSet;
    }

    public boolean isCleavageSite(String aaBefore, String aaAfter) {
        if (aaBefore.length() == 0 || aaAfter.length() == 0) {
            return true;
        }
        return this.isCleavageSite(Character.valueOf(aaBefore.charAt(aaBefore.length() - 1)), Character.valueOf(aaAfter.charAt(0)));
    }

    public boolean isCleavageSite(Character aaBefore, Character aaAfter) {
        boolean restriction;
        AminoAcid aminoAcid1 = AminoAcid.getAminoAcid(aaBefore.charValue());
        AminoAcid aminoAcid2 = AminoAcid.getAminoAcid(aaAfter.charValue());
        for (char possibleAaBefore : aminoAcid1.getSubAminoAcids()) {
            if (!this.aminoAcidBeforeSet.contains(Character.valueOf(possibleAaBefore))) continue;
            restriction = false;
            for (char possibleAaAfter : aminoAcid2.getSubAminoAcids()) {
                if (!this.restrictionAfterSet.contains(Character.valueOf(possibleAaAfter))) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        for (char possibleAaAfter : aminoAcid2.getSubAminoAcids()) {
            if (!this.aminoAcidAfterSet.contains(Character.valueOf(possibleAaAfter))) continue;
            restriction = false;
            for (char possibleAaBefore : aminoAcid1.getSubAminoAcids()) {
                if (!this.restrictionBeforeSet.contains(Character.valueOf(possibleAaBefore))) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        return false;
    }

    public boolean isCleavageSiteNoCombination(Character aaBefore, Character aaAfter) {
        return this.aminoAcidBeforeSet.contains(aaBefore) && !this.restrictionAfterSet.contains(aaAfter) || this.aminoAcidAfterSet.contains(aaAfter) && !this.restrictionBeforeSet.contains(aaBefore);
    }

    public int getNmissedCleavages(String sequence) {
        int result = 0;
        if (sequence.length() > 1) {
            for (int i = 0; i < sequence.length() - 1; ++i) {
                if (!this.isCleavageSite(Character.valueOf(sequence.charAt(i)), Character.valueOf(sequence.charAt(i + 1)))) continue;
                ++result;
            }
        }
        return result;
    }

    public HashSet<String> digest(String sequence, int nMissedCleavages, Integer nMin, Integer nMax) {
        int i;
        char aaAfter = sequence.charAt(0);
        StringBuilder currentPeptide = new StringBuilder();
        currentPeptide.append(aaAfter);
        HashSet<String> results = new HashSet<String>();
        HashMap mc = new HashMap();
        for (i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList(nMissedCleavages));
        }
        for (i = 1; i < sequence.length(); ++i) {
            char aa = sequence.charAt(i);
            char aaBefore = aaAfter;
            aaAfter = aa;
            if (this.isCleavageSite(Character.valueOf(aaBefore), Character.valueOf(aaAfter)) && currentPeptide.length() != 0) {
                String currentPeptideString = currentPeptide.toString();
                if (!(nMin != null && currentPeptide.length() < nMin || nMax != null && currentPeptide.length() > nMax)) {
                    results.add(currentPeptideString);
                }
                Iterator iterator = mc.keySet().iterator();
                while (iterator.hasNext()) {
                    int nMc = (Integer)iterator.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptideString);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    StringBuilder mcSequence = new StringBuilder();
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence.append(subPeptide);
                    }
                    if (nMin != null && mcSequence.length() < nMin || nMax != null && mcSequence.length() > nMax) continue;
                    results.add(mcSequence.toString());
                }
                currentPeptide = new StringBuilder();
            }
            currentPeptide.append(aa);
        }
        String currentPeptideString = currentPeptide.toString();
        if (!(nMin != null && currentPeptide.length() < nMin || nMax != null && currentPeptide.length() > nMax)) {
            results.add(currentPeptideString);
        }
        Iterator iterator = mc.keySet().iterator();
        while (iterator.hasNext()) {
            int nMc = (Integer)iterator.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptideString);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            StringBuilder mcSequence = new StringBuilder();
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence.append(subPeptide);
            }
            if (nMin != null && mcSequence.length() < nMin || nMax != null && mcSequence.length() > nMax) continue;
            results.add(mcSequence.toString());
        }
        return results;
    }

    public HashSet<String> digest(String sequence, int nMissedCleavages, Double massMin, Double massMax) {
        char aaAfter = sequence.charAt(0);
        StringBuilder currentPeptide = new StringBuilder();
        currentPeptide.append(aaAfter);
        Double currentMass = AminoAcid.getAminoAcid(aaAfter).getMonoisotopicMass();
        HashSet<String> results = new HashSet<String>();
        HashMap mc = new HashMap();
        for (int i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList(nMissedCleavages));
        }
        HashMap<String, Double> peptideMasses = new HashMap<String, Double>();
        for (int i = 1; i < sequence.length(); ++i) {
            char aa = sequence.charAt(i);
            char aaBefore = aaAfter;
            aaAfter = aa;
            if (this.isCleavageSite(Character.valueOf(aaBefore), Character.valueOf(aaAfter)) && currentPeptide.length() > 0) {
                String currentPeptideString = currentPeptide.toString();
                if ((massMin == null || currentMass >= massMin) && (massMax == null || currentMass <= massMax)) {
                    results.add(currentPeptideString);
                }
                Iterator iterator = mc.keySet().iterator();
                while (iterator.hasNext()) {
                    int nMc = (Integer)iterator.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptideString);
                    peptideMasses.put(currentPeptideString, currentMass);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    StringBuilder mcSequence = new StringBuilder();
                    Double mcMass = 0.0;
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence.append(subPeptide);
                        mcMass = mcMass + (Double)peptideMasses.get(subPeptide);
                    }
                    if (massMin != null && !(mcMass >= massMin) || massMax != null && !(mcMass <= massMax)) continue;
                    results.add(mcSequence.toString());
                }
                currentPeptide = new StringBuilder();
            }
            currentPeptide.append(aa);
            currentMass = currentMass + AminoAcid.getAminoAcid(aa).getMonoisotopicMass();
        }
        String currentPeptideString = currentPeptide.toString();
        if ((massMin == null || currentMass >= massMin) && (massMax == null || currentMass <= massMax)) {
            results.add(currentPeptideString);
        }
        Iterator iterator = mc.keySet().iterator();
        while (iterator.hasNext()) {
            int nMc = (Integer)iterator.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptideString);
            peptideMasses.put(currentPeptideString, currentMass);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            StringBuilder mcSequence = new StringBuilder();
            Double mcMass = 0.0;
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence.append(subPeptide);
                mcMass = mcMass + (Double)peptideMasses.get(subPeptide);
            }
            if (massMin != null && !(mcMass >= massMin) || massMax != null && !(mcMass <= massMax)) continue;
            results.add(mcSequence.toString());
        }
        return results;
    }

    public boolean equals(Enzyme otherEnzyme) {
        if (otherEnzyme == null) {
            return false;
        }
        if (this.getId() != otherEnzyme.getId()) {
            return false;
        }
        if (!this.getName().equalsIgnoreCase(otherEnzyme.getName())) {
            return false;
        }
        if (!this.getAminoAcidBefore().equals(otherEnzyme.getAminoAcidBefore())) {
            return false;
        }
        if (!this.getRestrictionBefore().equals(otherEnzyme.getRestrictionBefore())) {
            return false;
        }
        if (!this.getAminoAcidAfter().equals(otherEnzyme.getAminoAcidAfter())) {
            return false;
        }
        return this.getRestrictionAfter().equals(otherEnzyme.getRestrictionAfter());
    }

    public String getDescription() {
        String description = "Cleaves ";
        if (!this.getAminoAcidBefore().isEmpty()) {
            description = description + "after ";
            for (Character aa : this.getAminoAcidBefore()) {
                description = description + aa;
            }
            if (!this.getAminoAcidAfter().isEmpty()) {
                description = description + " and ";
            }
        }
        if (!this.getAminoAcidAfter().isEmpty()) {
            description = description + "before ";
            for (Character aa : this.getAminoAcidBefore()) {
                description = description + aa;
            }
        }
        if (!this.getRestrictionBefore().isEmpty()) {
            description = description + " not preceeded by ";
            for (Character aa : this.getRestrictionBefore()) {
                description = description + aa;
            }
            if (!this.getRestrictionAfter().isEmpty()) {
                description = description + " and ";
            }
        }
        if (!this.getRestrictionAfter().isEmpty()) {
            description = description + " not followed by ";
            for (Character aa : this.getRestrictionAfter()) {
                description = description + aa;
            }
        }
        return description;
    }

    public CvTerm getCvTerm() {
        return this.cvTerm;
    }

    public void setCvTerm(CvTerm cvTerm) {
        this.cvTerm = cvTerm;
    }

    public boolean isUnspecific() {
        return this.id == 17;
    }

    public boolean isSemiSpecific() {
        if (this.isSemiSpecific == null) {
            this.isSemiSpecific = false;
        }
        return this.isSemiSpecific;
    }

    public boolean isWholeProtein() {
        if (this.isWholeProtein == null) {
            this.isWholeProtein = this.name.equalsIgnoreCase("Whole Protein") || this.name.equalsIgnoreCase("Top-Down");
        }
        return this.isWholeProtein;
    }
}

