/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.statistics.distributions.BinomialDistribution;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.MathUtils;

public class AScore {
    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, AnnotationSettings annotationPreferences, SpecificAnnotationSettings specificAnnotationPreferences, boolean accountNeutralLosses, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences, PeptideSpectrumAnnotator spectrumAnnotator) throws IOException, InterruptedException, ClassNotFoundException, SQLException, MathException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for A-score calculation.");
        }
        int nPTM = 0;
        if (peptide.isModified()) {
            for (ModificationMatch modMatch : peptide.getModificationMatches()) {
                if (!modMatch.isVariable()) continue;
                for (PTM ptm : ptms) {
                    if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                    ++nPTM;
                }
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for A-score calculation.");
        }
        PTM refPTM = ptms.get(0);
        double ptmMass = refPTM.getMass();
        NeutralLossesMap annotationNeutralLosses = specificAnnotationPreferences.getNeutralLossesMap();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (String neutralLossName : annotationNeutralLosses.getAccountedNeutralLosses()) {
                NeutralLoss neutralLoss = NeutralLoss.getNeutralLoss(neutralLossName);
                if (!(Math.abs(neutralLoss.getMass() - ptmMass) > specificAnnotationPreferences.getFragmentIonAccuracyInDa(spectrum.getMaxMz()))) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, (Integer)1, (Integer)1);
            }
        }
        int peptideLength = peptide.getSequence().length();
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (PTM ptm : ptms) {
            if (ptm.isNTerm()) {
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(1)) continue;
                possibleSites.add(0);
                continue;
            }
            if (ptm.isCTerm()) {
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(peptideLength)) continue;
                possibleSites.add(peptideLength + 1);
                continue;
            }
            for (int potentialSite : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        if (possibleSites.size() > nPTM) {
            Collections.sort(possibleSites);
            Peptide noModPeptide = Peptide.getNoModPeptide(peptide, ptms);
            HashMap<Integer, MSnSpectrum> spectrumMap = AScore.getReducedSpectra(spectrum, specificAnnotationPreferences.getFragmentIonAccuracyInDa(spectrum.getMaxMz()), 10);
            HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = AScore.getPositionToScoreMap(peptide, noModPeptide, possibleSites, spectrum, spectrumMap, annotationPreferences, specificAnnotationPreferences, spectrumAnnotator, refPTM);
            HashMap<Double, ArrayList<Integer>> peptideScoreToPostitionMap = AScore.getPeptideScoreToPositionMap(positionToScoreMap);
            ArrayList<Double> scores = new ArrayList<Double>(peptideScoreToPostitionMap.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            ArrayList<Integer> bestScoringSites = peptideScoreToPostitionMap.get(scores.get(0));
            if (bestScoringSites.size() == 1) {
                int bestPosition = bestScoringSites.get(0);
                ArrayList<Integer> secondScoringSites = null;
                for (int i = 1; i < scores.size() && (secondScoringSites == null || secondScoringSites.isEmpty()); ++i) {
                    secondScoringSites = peptideScoreToPostitionMap.get(scores.get(i));
                }
                if (secondScoringSites == null || secondScoringSites.isEmpty()) {
                    throw new IllegalArgumentException("Only one site found in peptide score to position map when estimating the A-score for spectrum " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                }
                HashMap<Integer, Double> lowestScoreMap = null;
                Double lowestScore = null;
                for (int secondPosition : secondScoringSites) {
                    int bestDepth = AScore.getBestDepth(positionToScoreMap, bestPosition, secondPosition);
                    HashMap<Integer, Double> tempMap = AScore.getScoreForPositions(peptide, noModPeptide, refPTM, bestPosition, secondPosition, annotationPreferences, specificAnnotationPreferences, spectrumAnnotator, bestDepth, spectrumMap.get(bestDepth));
                    Double tempMapLowestScore = null;
                    for (int tempPos : tempMap.keySet()) {
                        double tempScore = tempMap.get(tempPos);
                        if (tempMapLowestScore == null || tempScore < tempMapLowestScore) {
                            tempMapLowestScore = tempScore;
                        }
                        if (tempMapLowestScore != 0.0) continue;
                        break;
                    }
                    if (tempMapLowestScore == null) {
                        throw new IllegalArgumentException("No secondary position score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                    }
                    if (lowestScore == null || tempMapLowestScore < lowestScore) {
                        lowestScore = tempMapLowestScore;
                        lowestScoreMap = tempMap;
                        continue;
                    }
                    if (!tempMapLowestScore.equals(lowestScore)) continue;
                    lowestScoreMap.putAll(tempMap);
                }
                if (lowestScoreMap == null) {
                    throw new IllegalArgumentException("No A-score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                }
                return lowestScoreMap;
            }
            HashMap<Integer, Double> lowestScoreMap = null;
            Double lowestScore = null;
            for (int bestPosition : bestScoringSites) {
                for (int secondPosition : bestScoringSites) {
                    if (bestPosition == secondPosition) continue;
                    int bestDepth = AScore.getBestDepth(positionToScoreMap, bestPosition, secondPosition);
                    HashMap<Integer, Double> tempMap = AScore.getScoreForPositions(peptide, noModPeptide, refPTM, bestPosition, secondPosition, annotationPreferences, specificAnnotationPreferences, spectrumAnnotator, bestDepth, spectrumMap.get(bestDepth));
                    Double tempMapLowestScore = null;
                    for (int tempPos : tempMap.keySet()) {
                        double tempScore = tempMap.get(tempPos);
                        if (tempMapLowestScore != null && !(tempScore < tempMapLowestScore)) continue;
                        tempMapLowestScore = tempScore;
                    }
                    if (tempMapLowestScore == null) {
                        throw new IllegalArgumentException("No secondary position score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                    }
                    if (lowestScore == null || tempMapLowestScore < lowestScore) {
                        lowestScore = tempMapLowestScore;
                        lowestScoreMap = tempMap;
                        continue;
                    }
                    if (!tempMapLowestScore.equals(lowestScore)) continue;
                    lowestScoreMap.putAll(tempMap);
                }
                if (lowestScore != 0.0) continue;
                break;
            }
            if (lowestScoreMap == null) {
                throw new IllegalArgumentException("No A-score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
            }
            return lowestScoreMap;
        }
        if (possibleSites.size() == nPTM) {
            HashMap<Integer, Double> result = new HashMap<Integer, Double>();
            Iterator iterator = possibleSites.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                result.put(pos, 100.0);
            }
            return result;
        }
        throw new IllegalArgumentException("Found less potential modification sites than PTMs during A-score calculation. Peptide key: " + peptide.getKey());
    }

    private static int getBestDepth(HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap, int bestPosition, int secondPosition) {
        Double maxDiff = 0.0;
        int bestI = 0;
        for (int i = 1; i <= 10; ++i) {
            double diff = positionToScoreMap.get(bestPosition).get(i) - positionToScoreMap.get(secondPosition).get(i);
            if (!(diff > maxDiff)) continue;
            bestI = i - 1;
            maxDiff = diff;
        }
        return bestI;
    }

    private static HashMap<Integer, Double> getScoreForPositions(Peptide peptide, Peptide noModPeptide, PTM refPTM, int bestPosition, int secondPosition, AnnotationSettings annotationPreferences, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator spectrumAnnotator, int bestDepth, MSnSpectrum spectrumAtBestDepth) throws MathException, InterruptedException {
        Double score;
        Double score1;
        HashMap<Integer, Double> result = new HashMap<Integer, Double>(2);
        int N = 0;
        int posMin = Math.min(bestPosition, secondPosition);
        int posMax = Math.max(bestPosition, secondPosition);
        for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(specificAnnotationPreferences, peptide).values()) {
            for (Ion ion : ions) {
                int aa;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++N;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++N;
            }
        }
        double p = ((double)bestDepth + 1.0) / 100.0;
        Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
        tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMin));
        ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrumAtBestDepth, tempPeptide, false);
        int n = 0;
        for (IonMatch match : matches) {
            int aa;
            Ion ion = match.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                aa = fragmentIon.getNumber();
                if (aa <= posMin || aa > posMax) continue;
                ++n;
                continue;
            }
            if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
            ++n;
        }
        BinomialDistribution distribution = new BinomialDistribution(N, p);
        Double p1 = distribution.getDescendingCumulativeProbabilityAt(n);
        tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
        tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMax));
        matches = spectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrumAtBestDepth, tempPeptide, false);
        n = 0;
        for (IonMatch match : matches) {
            int aa;
            Ion ion = match.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                aa = fragmentIon.getNumber();
                if (aa <= posMin || aa > posMax) continue;
                ++n;
                continue;
            }
            if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
            ++n;
        }
        Double p2 = distribution.getDescendingCumulativeProbabilityAt(n);
        if (p1.equals(p2)) {
            result.put(posMin, 0.0);
            result.put(posMax, 0.0);
        } else if (p1 < p2) {
            score1 = p1 == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(-10.0 * MathUtils.log((double)10.0, (double)p1));
            Double score2 = p2 == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(-10.0 * MathUtils.log((double)10.0, (double)p2));
            score = score1 - score2;
            result.put(posMin, score);
        } else {
            score1 = p1 == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(-10.0 * MathUtils.log((double)10.0, (double)p1));
            Double score2 = p2 == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(-10.0 * MathUtils.log((double)10.0, (double)p2));
            score = score2 - score1;
            result.put(posMax, score);
        }
        return result;
    }

    public static HashMap<Double, ArrayList<Integer>> getPeptideScoreToPositionMap(HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap) {
        HashMap<Double, ArrayList<Integer>> result = new HashMap<Double, ArrayList<Integer>>();
        for (int pos : positionToScoreMap.keySet()) {
            ArrayList<Integer> sites;
            Double peptideScore = 0.0;
            Double depthScore = positionToScoreMap.get(pos).get(1);
            if (depthScore != null) {
                peptideScore = peptideScore + 0.5 * depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(2)) != null) {
                peptideScore = peptideScore + 0.75 * depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(3)) != null) {
                peptideScore = peptideScore + depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(4)) != null) {
                peptideScore = peptideScore + depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(5)) != null) {
                peptideScore = peptideScore + depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(6)) != null) {
                peptideScore = peptideScore + depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(7)) != null) {
                peptideScore = peptideScore + 0.75 * depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(8)) != null) {
                peptideScore = peptideScore + 0.5 * depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(9)) != null) {
                peptideScore = peptideScore + 0.25 * depthScore;
            }
            if ((depthScore = positionToScoreMap.get(pos).get(10)) != null) {
                peptideScore = peptideScore + 0.25 * depthScore;
            }
            if ((sites = result.get(peptideScore)) == null) {
                sites = new ArrayList(2);
                result.put(peptideScore, sites);
            }
            sites.add(pos);
        }
        return result;
    }

    public static HashMap<Integer, HashMap<Integer, Double>> getPositionToScoreMap(Peptide peptide, Peptide noModPeptide, ArrayList<Integer> possibleSites, MSnSpectrum spectrum, HashMap<Integer, MSnSpectrum> spectrumMap, AnnotationSettings annotationPreferences, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator spectrumAnnotator, PTM refPTM) throws MathException, InterruptedException {
        HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = new HashMap<Integer, HashMap<Integer, Double>>();
        int N = 0;
        for (ArrayList<Ion> fragmentIons : spectrumAnnotator.getExpectedIons(specificAnnotationPreferences, peptide).values()) {
            N += fragmentIons.size();
        }
        String sequence = noModPeptide.getSequence();
        int sequenceLength = sequence.length();
        for (int i = 0; i < spectrumMap.size(); ++i) {
            double p = ((double)i + 1.0) / 100.0;
            for (int pos : possibleSites) {
                Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
                int position = pos == 0 ? 1 : (pos == sequenceLength + 1 ? sequenceLength : pos);
                tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, position));
                ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrumMap.get(i), tempPeptide, false);
                int n = matches.size();
                BinomialDistribution distribution = new BinomialDistribution(N, p);
                Double bigP = distribution.getDescendingCumulativeProbabilityAt(n);
                Double score = -10.0 * MathUtils.log((double)10.0, (double)bigP);
                HashMap<Integer, Double> scoresAtPosition = positionToScoreMap.get(pos);
                if (scoresAtPosition == null) {
                    scoresAtPosition = new HashMap(2);
                    positionToScoreMap.put(pos, scoresAtPosition);
                }
                scoresAtPosition.put(i + 1, score);
            }
        }
        return positionToScoreMap;
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance) {
        return AScore.getReducedSpectra(baseSpectrum, mzTolerance, -1);
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance, int depthMax) {
        int i;
        double currentmzMin;
        HashMap<Integer, MSnSpectrum> result = new HashMap<Integer, MSnSpectrum>();
        HashMap<Double, Peak> peakMap = baseSpectrum.getPeakMap();
        ArrayList<Double> mz = new ArrayList<Double>(peakMap.keySet());
        Collections.sort(mz);
        double mzMax = mz.get(mz.size() - 1);
        int cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            int cptTemp = 0;
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                ++cptTemp;
                ++cpt;
            }
            if (depthMax != -1 || cptTemp <= depthMax) continue;
            depthMax = cptTemp;
        }
        for (i = 0; i < depthMax; ++i) {
            result.put(i, new MSnSpectrum(2, baseSpectrum.getPrecursor(), baseSpectrum.getSpectrumTitle() + "_" + i, new HashMap<Double, Peak>(), "a score"));
        }
        cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            ArrayList<Double> intensities = new ArrayList<Double>();
            HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                Peak tempPeak = peakMap.get(mz.get(cpt));
                intensities.add(-tempPeak.intensity);
                tempMap.put(-tempPeak.intensity, tempPeak);
                ++cpt;
            }
            Collections.sort(intensities);
            for (i = 0; i < intensities.size(); ++i) {
                for (int j = i; j < depthMax; ++j) {
                    result.get(j).addPeak((Peak)tempMap.get(intensities.get(i)));
                }
            }
        }
        return result;
    }
}

