/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.RelatedIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;
import java.util.Iterator;

public class ImmoniumIonAnnotator {
    private final char[] aas;
    private final double[] immoniumIonsMz;
    private RelatedIon[] relatedIons;
    private double[] relatedIonsMz;

    public ImmoniumIonAnnotator(char[] peptideSequence) {
        this(peptideSequence, true, true);
    }

    public ImmoniumIonAnnotator(char[] peptideSequence, boolean immonium, boolean related) {
        this.aas = peptideSequence;
        this.immoniumIonsMz = new double[peptideSequence.length];
        this.relatedIons = new RelatedIon[0];
        this.relatedIonsMz = new double[0];
        for (int i = 1; i < this.aas.length; ++i) {
            ArrayList<RelatedIon> aaRelatedIons;
            char aa = this.aas[i];
            if (immonium) {
                this.immoniumIonsMz[i] = ImmoniumIon.getImmoniumIon(aa).getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
            }
            if (!related || (aaRelatedIons = RelatedIon.getRelatedIons(aa)) == null) continue;
            int j = this.relatedIons.length;
            int newLength = j + aaRelatedIons.size();
            RelatedIon[] newIons = new RelatedIon[newLength];
            double[] newMz = new double[newLength];
            System.arraycopy(this.relatedIons, 0, newIons, 0, this.relatedIons.length);
            System.arraycopy(this.relatedIonsMz, 0, newMz, 0, this.relatedIonsMz.length);
            Iterator<RelatedIon> iterator = aaRelatedIons.iterator();
            while (iterator.hasNext()) {
                RelatedIon relatedIon;
                newIons[j] = relatedIon = iterator.next();
                newMz[j++] = relatedIon.getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
            }
            this.relatedIons = newIons;
            this.relatedIonsMz = newMz;
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex) {
        ArrayList<Peak> peaks;
        double ionMz;
        int i;
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (i = 0; i < this.aas.length; ++i) {
            ionMz = this.immoniumIonsMz[i];
            char aa = this.aas[i];
            peaks = spectrumIndex.getMatchingPeaks(ionMz);
            for (Peak peak : peaks) {
                ImmoniumIon ion = ImmoniumIon.getImmoniumIon(aa);
                results.add(new IonMatch(peak, ion, 1));
            }
        }
        for (i = 0; i < this.relatedIons.length; ++i) {
            ionMz = this.relatedIonsMz[i];
            RelatedIon relatedIon = this.relatedIons[i];
            peaks = spectrumIndex.getMatchingPeaks(ionMz);
            for (Peak peak : peaks) {
                results.add(new IonMatch(peak, relatedIon, 1));
            }
        }
        return results;
    }
}

