/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Sample;
import com.compomics.util.experiment.normalization.NormalizationFactors;
import com.compomics.util.experiment.quantification.Quantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ReporterIonQuantification
extends Quantification {
    private HashMap<String, Sample> sampleAssignement = new HashMap();
    private HashMap<String, Integer> sampleIndexes = new HashMap();
    private ArrayList<String> controlSamples;
    private ReporterMethod reporterMethod;
    private NormalizationFactors normalizationFactors;

    public ReporterIonQuantification(Quantification.QuantificationMethod methodUsed) {
        this.methodUsed = methodUsed;
        this.normalizationFactors = new NormalizationFactors();
    }

    public void assignSample(String reporterName, Sample sample) {
        this.sampleAssignement.put(reporterName, sample);
    }

    public Integer getSampleIndex(String sampleReference) {
        if (this.sampleIndexes == null) {
            this.sampleIndexes = new HashMap();
        }
        return this.sampleIndexes.get(sampleReference);
    }

    public void setSampleIndex(String sampleReference, Integer index) {
        if (this.sampleIndexes == null) {
            this.sampleIndexes = new HashMap();
        }
        this.sampleIndexes.put(sampleReference, index);
    }

    public Sample getSample(String reporterIonName) {
        return this.sampleAssignement.get(reporterIonName);
    }

    public String getReporterIndex(Sample aSample) {
        for (String ionName : this.sampleAssignement.keySet()) {
            if (!this.sampleAssignement.get(ionName).isSameAs(aSample)) continue;
            return ionName;
        }
        return null;
    }

    public ReporterMethod getReporterMethod() {
        return this.reporterMethod;
    }

    public void setMethod(ReporterMethod reporterMethod) {
        this.reporterMethod = reporterMethod;
    }

    public static String getDefaultReference(String experimentReference, String sampleReference, int replicateNumber) {
        return Util.removeForbiddenCharacters(experimentReference + "_" + sampleReference + "_" + replicateNumber + "_reporterQuant");
    }

    public ArrayList<String> getControlSamples() {
        return this.controlSamples;
    }

    public void setControlSamples(ArrayList<String> controlSamples) {
        this.controlSamples = controlSamples;
    }

    public Set<String> getSampleIndexes() {
        return this.sampleAssignement.keySet();
    }

    public NormalizationFactors getNormalizationFactors() {
        return this.normalizationFactors;
    }

    public void setNormalizationFactors(NormalizationFactors normalizationFactors) {
        this.normalizationFactors = normalizationFactors;
    }
}

