/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import java.io.File;
import java.io.Serializable;

public class ProteinInferencePreferences
implements Serializable {
    static final long serialVersionUID = 447785006299636157L;
    private File proteinSequenceDatabase;
    private Boolean simplifyProteinGroups = true;
    private Boolean simplifyGroupsScore = true;
    private Boolean simplifyGroupsEvidence = true;
    private Boolean simplifyGroupsEnzymaticity = true;
    private Boolean simplifyGroupsUncharacterized = true;

    public File getProteinSequenceDatabase() {
        return this.proteinSequenceDatabase;
    }

    public void setProteinSequenceDatabase(File proteinSequenceDatabase) {
        this.proteinSequenceDatabase = proteinSequenceDatabase;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("DB: ");
        if (this.proteinSequenceDatabase != null) {
            output.append(this.proteinSequenceDatabase.getName());
        } else {
            output.append("not set");
        }
        output.append(".").append(newLine);
        output.append("Simplify Groups: ").append(this.getSimplifyGroups()).append(newLine);
        output.append("Simplify on score: ").append(this.getSimplifyGroupsScore()).append(newLine);
        output.append("Simplify on enzymaticity: ").append(this.getSimplifyGroupsEnzymaticity()).append(newLine);
        output.append("Simplify on evidence: ").append(this.getSimplifyGroupsEvidence()).append(newLine);
        output.append("Simplify uncharacterized: ").append(this.getSimplifyGroupsUncharacterized()).append(newLine);
        return output.toString();
    }

    public boolean equals(ProteinInferencePreferences otherProteinInferencePreferences) {
        if (otherProteinInferencePreferences == null) {
            return false;
        }
        if (this.proteinSequenceDatabase != null && otherProteinInferencePreferences.getProteinSequenceDatabase() == null || this.proteinSequenceDatabase == null && otherProteinInferencePreferences.getProteinSequenceDatabase() != null) {
            return false;
        }
        if (!this.getSimplifyGroups().equals(otherProteinInferencePreferences.getSimplifyGroups())) {
            return false;
        }
        if (!this.getSimplifyGroupsScore().equals(otherProteinInferencePreferences.getSimplifyGroupsScore())) {
            return false;
        }
        if (!this.getSimplifyGroupsEnzymaticity().equals(otherProteinInferencePreferences.getSimplifyGroupsEnzymaticity())) {
            return false;
        }
        if (!this.getSimplifyGroupsEvidence().equals(otherProteinInferencePreferences.getSimplifyGroupsEvidence())) {
            return false;
        }
        if (!this.getSimplifyGroupsUncharacterized().equals(otherProteinInferencePreferences.getSimplifyGroupsUncharacterized())) {
            return false;
        }
        return this.proteinSequenceDatabase == null || this.proteinSequenceDatabase.equals(otherProteinInferencePreferences.getProteinSequenceDatabase());
    }

    public Boolean getSimplifyGroups() {
        if (this.simplifyProteinGroups == null) {
            this.simplifyProteinGroups = true;
        }
        return this.simplifyProteinGroups;
    }

    public void setSimplifyGroups(Boolean simplifyProteinGroups) {
        this.simplifyProteinGroups = simplifyProteinGroups;
    }

    public Boolean getSimplifyGroupsScore() {
        if (this.simplifyGroupsScore == null) {
            this.simplifyGroupsScore = true;
        }
        return this.simplifyGroupsScore;
    }

    public void setSimplifyGroupsScore(Boolean simplifyGroupsScore) {
        this.simplifyGroupsScore = simplifyGroupsScore;
    }

    public Boolean getSimplifyGroupsEvidence() {
        if (this.simplifyGroupsEvidence == null) {
            this.simplifyGroupsEvidence = true;
        }
        return this.simplifyGroupsEvidence;
    }

    public void setSimplifyGroupsEvidence(Boolean simplifyGroupsEvidence) {
        this.simplifyGroupsEvidence = simplifyGroupsEvidence;
    }

    public Boolean getSimplifyGroupsEnzymaticity() {
        if (this.simplifyGroupsEnzymaticity == null) {
            this.simplifyGroupsEnzymaticity = true;
        }
        return this.simplifyGroupsEnzymaticity;
    }

    public void setSimplifyGroupsEnzymaticity(Boolean simplifyGroupsEnzymaticity) {
        this.simplifyGroupsEnzymaticity = simplifyGroupsEnzymaticity;
    }

    public Boolean getSimplifyGroupsUncharacterized() {
        if (this.simplifyGroupsUncharacterized == null) {
            this.simplifyGroupsUncharacterized = true;
        }
        return this.simplifyGroupsUncharacterized;
    }

    public void setSimplifyGroupsUncharacterized(Boolean simplifyGroupsUncharacterized) {
        this.simplifyGroupsUncharacterized = simplifyGroupsUncharacterized;
    }
}

