/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.array.operation.Exchange;
import org.ojalgo.array.operation.FillAll;
import org.ojalgo.array.operation.FillMatchingSingle;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.OperationVoid;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.math.MathType;

public class ArrayR064
extends PrimitiveArray {
    public static final DenseArray.Factory<Double> FACTORY = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        public MathType getMathType() {
            return MathType.R064;
        }

        @Override
        PlainArray<Double> makeDenseArray(long size) {
            return ArrayR064.make((int)size);
        }
    };
    public final double[] data;

    public static ArrayR064 make(int size) {
        return new ArrayR064(size);
    }

    public static ArrayR064 wrap(double ... data) {
        return new ArrayR064(data);
    }

    protected ArrayR064(double[] data) {
        super(FACTORY, data.length);
        this.data = data;
    }

    protected ArrayR064(int size) {
        super(FACTORY, size);
        this.data = new double[size];
    }

    @Override
    public void axpy(double a, Mutate1D.Modifiable<?> y) {
        AXPY.invoke(y, a, this.data);
    }

    @Override
    public double dot(Access1D<?> vector) {
        double retVal = PrimitiveMath.ZERO;
        int limit = Math.min(this.data.length, (int)vector.count());
        for (int i = 0; i < limit; ++i) {
            retVal += this.data[i] * vector.doubleValue(i);
        }
        return retVal;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayR064)) {
            return false;
        }
        ArrayR064 other = (ArrayR064)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (values instanceof ArrayR064) {
            FillMatchingSingle.fill(this.data, ((ArrayR064)values).data);
        } else {
            FillMatchingSingle.fill(this.data, values);
        }
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        int limit = MissingMath.toMinIntExact(this.count(), left.count(), right.count());
        OperationBinary.invoke(this.data, 0, limit, 1, left, function, right);
    }

    @Override
    public void fillMatching(UnaryFunction<Double> function, Access1D<Double> arguments) {
        int limit = MissingMath.toMinIntExact(this.count(), arguments.count());
        OperationUnary.invoke(this.data, 0, limit, 1, arguments, function);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + Arrays.hashCode(this.data);
    }

    @Override
    public final void reset() {
        Arrays.fill(this.data, PrimitiveMath.ZERO);
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data);
    }

    @Override
    public void sortDescending() {
        CorePrimitiveOperation.negate(this.data, 0, this.data.length, 1, this.data);
        Arrays.parallelSort(this.data);
        CorePrimitiveOperation.negate(this.data, 0, this.data.length, 1, this.data);
    }

    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.data, 0, this.data.length, 1040);
    }

    public DoubleStream stream(boolean parallel) {
        return StreamSupport.doubleStream(this.spliterator(), parallel);
    }

    @Override
    public void supplyTo(Mutate1D receiver) {
        int limit = Math.min(this.data.length, receiver.size());
        for (int i = 0; i < limit; ++i) {
            receiver.set((long)i, this.data[i]);
        }
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        int n = index;
        this.data[n] = this.data[n] + NumberDefinition.doubleValue(addend);
    }

    @Override
    protected void add(int index, double addend) {
        int n = index;
        this.data[n] = this.data[n] + addend;
    }

    @Override
    protected byte byteValue(int index) {
        return (byte)Math.round(this.data[index]);
    }

    protected final double[] copyOfData() {
        return COPY.copyOf(this.data);
    }

    @Override
    protected final double doubleValue(int index) {
        return this.data[index];
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        Exchange.exchange(this.data, firstA, firstB, step, count);
    }

    @Override
    protected final void fill(int first, int limit, int step, Double value) {
        FillAll.fill(this.data, first, limit, step, (double)value);
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<?> supplier) {
        FillAll.fill(this.data, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = values.doubleValue(valueIndex);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.data[index] = value;
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.data[index] = supplier.doubleValue();
    }

    @Override
    protected float floatValue(int index) {
        return (float)this.data[index];
    }

    @Override
    protected final Double get(int index) {
        return this.data[index];
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this.data, first, limit, step);
    }

    @Override
    protected int intValue(int index) {
        return (int)Math.round(this.data[index]);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.data[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.data[index]);
    }

    @Override
    protected long longValue(int index) {
        return Math.round(this.data[index]);
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        OperationBinary.invoke(this.data, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        OperationBinary.invoke(this.data, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        OperationUnary.invoke(this.data, first, limit, step, (Access1D<Double>)this, function);
    }

    @Override
    protected final void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.data[index] = modifier.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(Double number) {
        return Arrays.binarySearch(this.data, number);
    }

    @Override
    protected final void set(int index, Comparable<?> value) {
        this.data[index] = Scalar.doubleValue(value);
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = value;
    }

    @Override
    protected short shortValue(int index) {
        return (short)Math.round(this.data[index]);
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        OperationVoid.invoke(this.data, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(left.doubleValue(extIndex), this.data[intIndex]);
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.data[intIndex] = function.invoke(this.data[intIndex], right.doubleValue(extIndex));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(this.data[intIndex]);
    }

    @Override
    protected void set(int index, long value) {
        this.data[index] = value;
    }
}

