/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.array.operation.Exchange;
import org.ojalgo.array.operation.FillAll;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.OperationVoid;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.math.MathType;

public class ArrayZ008
extends PrimitiveArray {
    public static final DenseArray.Factory<Double> FACTORY = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        public MathType getMathType() {
            return MathType.Z008;
        }

        @Override
        PlainArray<Double> makeDenseArray(long size) {
            return ArrayZ008.make((int)size);
        }
    };
    public final byte[] data;

    public static ArrayZ008 make(int size) {
        return new ArrayZ008(size);
    }

    public static ArrayZ008 wrap(byte ... data) {
        return new ArrayZ008(data);
    }

    protected ArrayZ008(byte[] data) {
        super(FACTORY, data.length);
        this.data = data;
    }

    protected ArrayZ008(int size) {
        super(FACTORY, size);
        this.data = new byte[size];
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, (byte)0);
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data);
    }

    @Override
    public void sortDescending() {
        CorePrimitiveOperation.negate(this.data, 0, this.data.length, 1, this.data);
        Arrays.parallelSort(this.data);
        CorePrimitiveOperation.negate(this.data, 0, this.data.length, 1, this.data);
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        int n = index;
        this.data[n] = (byte)(this.data[n] + NumberDefinition.byteValue(addend));
    }

    @Override
    protected void add(int index, double addend) {
        int n = index;
        this.data[n] = (byte)(this.data[n] + (byte)Math.round(addend));
    }

    @Override
    protected void add(int index, byte addend) {
        int n = index;
        this.data[n] = (byte)(this.data[n] + addend);
    }

    @Override
    protected byte byteValue(int index) {
        return this.data[index];
    }

    @Override
    protected double doubleValue(int index) {
        return this.data[index];
    }

    @Override
    protected void exchange(int firstA, int firstB, int step, int count) {
        Exchange.exchange(this.data, firstA, firstB, step, count);
    }

    @Override
    protected void fill(int first, int limit, int step, Double value) {
        FillAll.fill(this.data, first, limit, step, value.byteValue());
    }

    @Override
    protected void fill(int first, int limit, int step, NullaryFunction<?> supplier) {
        FillAll.fill(this.data, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = values.byteValue(valueIndex);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.data[index] = value.byteValue();
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.data[index] = supplier.byteValue();
    }

    @Override
    protected float floatValue(int index) {
        return this.data[index];
    }

    @Override
    protected final Double get(int index) {
        return this.data[index];
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this.data, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.data[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.data[index]);
    }

    @Override
    protected void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        OperationBinary.invoke(this.data, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        OperationBinary.invoke(this.data, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        OperationUnary.invoke(this.data, first, limit, step, (Access1D<Double>)this, function);
    }

    @Override
    protected void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.data[index] = modifier.invoke(this.data[index]);
    }

    @Override
    protected int searchAscending(Double number) {
        return Arrays.binarySearch(this.data, number.byteValue());
    }

    @Override
    protected void set(int index, Comparable<?> number) {
        this.data[index] = Scalar.byteValue(number);
    }

    @Override
    protected void set(int index, double value) {
        this.data[index] = (byte)Math.round(value);
    }

    @Override
    protected void set(int index, byte value) {
        this.data[index] = value;
    }

    @Override
    protected void set(int index, float value) {
        this.data[index] = (byte)Math.round(value);
    }

    @Override
    protected void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        OperationVoid.invoke(this.data, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(left.byteValue(extIndex), this.data[intIndex]);
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.data[intIndex] = function.invoke(this.data[intIndex], right.byteValue(extIndex));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(this.data[intIndex]);
    }

    @Override
    protected void set(int index, long value) {
        this.data[index] = (byte)value;
    }
}

