/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapZ032
extends OffHeapArray {
    private final long myPointer;

    OffHeapZ032(long count) {
        super(OffHeapArray.Z032, count);
        this.myPointer = NativeMemory.allocateIntArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.intValue(addend));
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getInt(this.myPointer, index);
    }

    @Override
    public float floatValue(long index) {
        return NativeMemory.getInt(this.myPointer, index);
    }

    @Override
    public int intValue(long index) {
        return NativeMemory.getInt(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseIntArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.intValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setInt(this.myPointer, index, Math.toIntExact(Math.round(value)));
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setInt(this.myPointer, index, Math.round(value));
    }

    @Override
    public void set(long index, int value) {
        NativeMemory.setInt(this.myPointer, index, value);
    }
}

