/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.scalar.Scalar;

public abstract class ApplyLDL
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint) {
        double diagVal = data[iterationPoint + iterationPoint * structure];
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, -(diagVal * multipliers[j]), multipliers, 0, j, structure);
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int structure, int firstColumn, int columnLimit, N[] multipliers, int iterationPoint) {
        N diagVal = data[iterationPoint + iterationPoint * structure];
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, (int)(j * structure), (Scalar)((Scalar)((Scalar)diagVal.multiply((Scalar)multipliers[j].conjugate()).negate()).get()), multipliers, (int)0, (int)j, (int)structure);
        }
    }
}

