/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.type.function.TwoStepMapper;

public final class ProcessingService {
    public static final ProcessingService INSTANCE = new ProcessingService(DaemonPoolExecutor.INSTANCE);
    private final ExecutorService myExecutor;

    public static ProcessingService newInstance(String name) {
        return new ProcessingService(DaemonPoolExecutor.newCachedThreadPool(name));
    }

    public ProcessingService(ExecutorService executor) {
        this.myExecutor = executor;
    }

    public <W, R> Map<W, R> compute(Collection<W> work, Function<W, R> computer) {
        return this.compute(work, Parallelism.CORES, computer);
    }

    public <W, R> Map<W, R> compute(Collection<W> work, int parallelism, Function<W, R> computer) {
        return (Map)this.reduce(work, parallelism, () -> new TwoStepMapper.SimpleCache(computer));
    }

    public <W, R> Map<W, R> compute(Collection<W> work, IntSupplier parallelism, Function<W, R> computer) {
        return this.compute(work, parallelism.getAsInt(), computer);
    }

    public DivideAndConquer.Divider divider() {
        return new DivideAndConquer.Divider(this.myExecutor);
    }

    public ExecutorService getExecutor() {
        return this.myExecutor;
    }

    public <W, R> Collection<R> map(Collection<W> work, Function<W, R> mapper) {
        return this.map(work, Parallelism.CORES, mapper);
    }

    public <W, R> Collection<R> map(Collection<W> work, int parallelism, Function<W, R> mapper) {
        return this.compute(work, parallelism, mapper).values();
    }

    public <W, R> Collection<R> map(Collection<W> work, IntSupplier parallelism, Function<W, R> mapper) {
        return this.map(work, parallelism.getAsInt(), mapper);
    }

    public <W> void process(Collection<? extends W> work, Consumer<W> processor) {
        this.process(work, Parallelism.CORES, processor);
    }

    public <W> void process(Collection<? extends W> work, int parallelism, Consumer<W> processor) {
        int concurrency = Math.min(work.size(), parallelism);
        LinkedBlockingDeque<? extends W> queue = new LinkedBlockingDeque<W>(work);
        ArrayList<CallableConsumer<? extends W>> tasks = new ArrayList<CallableConsumer<? extends W>>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            tasks.add(new CallableConsumer<W>(queue, processor));
        }
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    public <W> void process(Collection<? extends W> work, IntSupplier parallelism, Consumer<W> processor) {
        this.process(work, parallelism.getAsInt(), processor);
    }

    public <W> void processPair(W work1, W work2, Consumer<W> processor) {
        this.process(Arrays.asList(work1, work2), processor);
    }

    public <W> void processTriplet(W work1, W work2, W work3, Consumer<W> processor) {
        this.process(Arrays.asList(work1, work2, work3), processor);
    }

    public <W, R> R reduce(Collection<W> work, int parallelism, Supplier<TwoStepMapper<W, R>> reducer) {
        int concurrency = Math.min(work.size(), parallelism);
        LinkedBlockingDeque<W> queue = new LinkedBlockingDeque<W>(work);
        ArrayList<CallableMapper<W, R>> tasks = new ArrayList<CallableMapper<W, R>>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            tasks.add(new CallableMapper<W, R>(queue, reducer.get()));
        }
        TwoStepMapper totalResults = reducer.get();
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                TwoStepMapper mapper = (TwoStepMapper)future.get();
                totalResults.merge(mapper.getResults());
                mapper.reset();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
        return totalResults.getResults();
    }

    public <W, R> R reduce(Collection<W> work, IntSupplier parallelism, Supplier<TwoStepMapper<W, R>> reducer) {
        return this.reduce(work, parallelism.getAsInt(), reducer);
    }

    public <W, R> R reduce(Collection<W> work, Supplier<TwoStepMapper<W, R>> reducer) {
        return this.reduce(work, Parallelism.CORES, reducer);
    }

    public void run(int parallelism, Runnable processor) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            tasks.add(Executors.callable(processor));
        }
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    public void run(IntSupplier parallelism, Runnable processor) {
        this.run(parallelism.getAsInt(), processor);
    }

    static final class CallableMapper<W, R>
    implements Callable<TwoStepMapper<W, R>> {
        private final TwoStepMapper<W, R> myMapper;
        private final Queue<W> myWork;

        CallableMapper(Queue<W> work, TwoStepMapper<W, R> mapper) {
            this.myWork = work;
            this.myMapper = mapper;
        }

        @Override
        public TwoStepMapper<W, R> call() throws Exception {
            Object item = null;
            while (true) {
                W w = this.myWork.poll();
                item = w;
                if (w == null) break;
                this.myMapper.consume(item);
            }
            return this.myMapper;
        }
    }

    static final class CallableConsumer<W>
    implements Callable<Boolean> {
        private final Consumer<W> myConsumer;
        private final Queue<W> myWork;

        CallableConsumer(Queue<W> work, Consumer<W> consumer) {
            this.myWork = work;
            this.myConsumer = consumer;
        }

        @Override
        public Boolean call() throws Exception {
            Object item = null;
            while (true) {
                W w = this.myWork.poll();
                item = w;
                if (w == null) break;
                this.myConsumer.accept(item);
            }
            return Boolean.TRUE;
        }
    }
}

