/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.batch;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.function.IntSupplier;
import org.ojalgo.data.batch.BatchNode;
import org.ojalgo.netio.DataInterpreter;
import org.ojalgo.netio.FromFileReader;

public final class BatchManager {
    private final File myBatchRootDirectory;
    private ExecutorService myExecutor = null;
    private Integer myFragmentation = null;
    private IntSupplier myParallelism = null;
    private Integer myQueueCapacity = null;

    public BatchManager(File batchRootDirectory) {
        this.myBatchRootDirectory = batchRootDirectory;
    }

    public void dispose() {
        FromFileReader.delete(this.myBatchRootDirectory);
    }

    public BatchManager executor(ExecutorService executor) {
        this.myExecutor = executor;
        return this;
    }

    public BatchManager fragmentation(int fragmentation) {
        this.myFragmentation = fragmentation;
        return this;
    }

    public <T> BatchNode.Builder<T> newNodeBuilder(String nodeName, DataInterpreter<T> dataInterpreter) {
        BatchNode.Builder<T> retVal = BatchNode.newBuilder(new File(this.myBatchRootDirectory, nodeName), dataInterpreter);
        if (this.myFragmentation != null) {
            retVal.fragmentation(this.myFragmentation);
        }
        if (this.myExecutor != null) {
            retVal.executor(this.myExecutor);
        }
        if (this.myParallelism != null) {
            retVal.parallelism(this.myParallelism);
        }
        if (this.myQueueCapacity != null) {
            retVal.queue(this.myQueueCapacity);
        }
        return retVal;
    }

    public BatchManager parallelism(int parallelism) {
        return this.parallelism(() -> parallelism);
    }

    public BatchManager parallelism(IntSupplier parallelism) {
        this.myParallelism = parallelism;
        return this;
    }

    public BatchManager queue(int capacity) {
        this.myQueueCapacity = capacity;
        return this;
    }
}

