/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;

@Deprecated
final class YahooSessionOld {
    private static final CalendarDateDuration DURATION_30_YEARS = new CalendarDateDuration(30.0, CalendarDateUnit.YEAR);
    private static final String END = "\">";
    private static final String FINANCE_YAHOO_COM = "finance.yahoo.com";
    private static final String GUCE_OATH_COM = "guce.oath.com";
    private static final String INPUT_TYPE_HIDDEN_NAME_BRAND_BID_VALUE = "<input type=\"hidden\" name=\"brandBid\" value=\"";
    private static final String INPUT_TYPE_HIDDEN_NAME_CSRF_TOKEN_VALUE = "<input type=\"hidden\" name=\"csrfToken\" value=\"";
    private static final String INTERVAL = "interval";
    private static final String QUERY1_FINANCE_YAHOO_COM = "query1.finance.yahoo.com";
    static final String BRAND_BID = "brandBid";
    static final String CRUMB = "crumb";
    static final String CSRF_TOKEN = "csrfToken";
    static boolean debug = false;
    static final String SESSION_ID = "sessionId";
    private final ResourceLocator.Session mySession = ResourceLocator.session();

    static ResourceLocator.Request buildChallengeRequest(ResourceLocator.Session session, String symbol) {
        return session.request().host(FINANCE_YAHOO_COM).path("/quote/" + symbol + "/options");
    }

    static ResourceLocator.Request buildConsentRequest(ResourceLocator.Session session, ResourceLocator.Request challengeRequest) {
        String sessionID = session.getParameterValue(SESSION_ID);
        String csrfToken = session.getParameterValue(CSRF_TOKEN);
        String brandBid = session.getParameterValue(BRAND_BID);
        ResourceLocator.Request request = session.request().method(ResourceLocator.Method.POST).host(GUCE_OATH_COM).path("/consent");
        request.form("country", "SE");
        request.form("ybarNamespace", "YAHOO");
        request.form("previousStep", "");
        request.form("tosId", "eu");
        request.form("jurisdiction", "");
        request.form("originalDoneUrl", challengeRequest.toString());
        request.form(BRAND_BID, brandBid);
        request.form(SESSION_ID, sessionID);
        request.form("agree", "agree");
        request.form("locale", "sv-SE");
        request.form("isSDK", "false");
        request.form(CSRF_TOKEN, csrfToken);
        request.form("inline", "false");
        request.form("namespace", "yahoo");
        request.form("consentCollectionStep", "EU_SINGLEPAGE");
        request.form("doneUrl", "https://guce.yahoo.com/copyConsent?sessionId=" + sessionID + "&inline=false&lang=sv-SE");
        request.form("startStep", "EU_SINGLEPAGE");
        request.form("userType", "NON_REG");
        return request;
    }

    static ResourceLocator.Request buildCrumbRequest(ResourceLocator.Session session) {
        return session.request().host(QUERY1_FINANCE_YAHOO_COM).path("/v1/test/getcrumb");
    }

    static ResourceLocator.Request buildDataRequest(ResourceLocator.Session session, String symbol, CalendarDateUnit resolution) {
        ResourceLocator.Request request = session.request().host(QUERY1_FINANCE_YAHOO_COM).path("/v7/finance/download/" + symbol);
        switch (resolution) {
            case MONTH: {
                request.query(INTERVAL, "1mo");
                break;
            }
            case WEEK: {
                request.query(INTERVAL, "1wk");
                break;
            }
            default: {
                request.query(INTERVAL, "1d");
            }
        }
        request.query("events", "history");
        Instant now = Instant.now();
        Instant past = now.minus(DURATION_30_YEARS.toDurationInMillis(), ChronoUnit.MILLIS);
        request.query("period1", Long.toString(past.getEpochSecond()));
        request.query("period2", Long.toString(now.getEpochSecond()));
        request.query(CRUMB, session.getParameterValue(CRUMB));
        return request;
    }

    static void scrapeChallengeResponse(ResourceLocator.Session session, ResourceLocator.Response challengeResponse) {
        String challengeResponseBody = challengeResponse.toString();
        ResourceLocator.Request finalRequest = challengeResponse.getRequest();
        String sessionId = finalRequest.getQueryValue(SESSION_ID);
        session.parameter(SESSION_ID, sessionId);
        int begin = challengeResponseBody.indexOf(INPUT_TYPE_HIDDEN_NAME_CSRF_TOKEN_VALUE);
        int end = 0;
        if (begin >= 0) {
            end = challengeResponseBody.indexOf(END, begin += INPUT_TYPE_HIDDEN_NAME_CSRF_TOKEN_VALUE.length());
            String csrfToken = challengeResponseBody.substring(begin, end);
            session.parameter(CSRF_TOKEN, csrfToken);
        }
        if ((begin = challengeResponseBody.indexOf(INPUT_TYPE_HIDDEN_NAME_BRAND_BID_VALUE)) >= 0) {
            end = challengeResponseBody.indexOf(END, begin += INPUT_TYPE_HIDDEN_NAME_BRAND_BID_VALUE.length());
            String brandBid = challengeResponseBody.substring(begin, end);
            session.parameter(BRAND_BID, brandBid);
        }
    }

    static void scrapeCrumbResponse(ResourceLocator.Session session, ResourceLocator.Response crumbResponse) {
        session.parameter(CRUMB, crumbResponse.toString());
    }

    YahooSessionOld() {
    }

    Fetcher newFetcher(String symbol, CalendarDateUnit resolution) {
        return new Fetcher(this.mySession, symbol, resolution);
    }

    @Deprecated
    static final class Fetcher
    implements DataFetcher {
        private final CalendarDateUnit myResolution;
        private final ResourceLocator.Session mySession;
        private final String mySymbol;

        Fetcher(ResourceLocator.Session session, String symbol, CalendarDateUnit resolution) {
            this.mySession = session;
            this.mySymbol = symbol;
            this.myResolution = resolution;
        }

        @Override
        public InputStream getInputStream() {
            String crumb;
            if (debug) {
                BasicLogger.debug();
                BasicLogger.debug("Begin getStreamOfCSV");
                BasicLogger.debug();
            }
            if ((crumb = this.mySession.getParameterValue(YahooSessionOld.CRUMB)) == null || crumb.length() <= 0) {
                ResourceLocator.Request challengeRequest = YahooSessionOld.buildChallengeRequest(this.mySession, this.mySymbol);
                ResourceLocator.Response challengeResponse = challengeRequest.response();
                if (debug) {
                    challengeRequest.print(BasicLogger.DEBUG);
                    challengeResponse.print(BasicLogger.DEBUG);
                }
                if (challengeResponse.toString() != null && !challengeRequest.equals(challengeResponse.getRequest())) {
                    YahooSessionOld.scrapeChallengeResponse(this.mySession, challengeResponse);
                    ResourceLocator.Request consentRequest = YahooSessionOld.buildConsentRequest(this.mySession, challengeRequest);
                    ResourceLocator.Response consentResponse = consentRequest.response();
                    if (consentResponse.toString() != null && debug) {
                        consentRequest.print(BasicLogger.DEBUG);
                        consentResponse.print(BasicLogger.DEBUG);
                    }
                }
                ResourceLocator.Request crumbRequest = YahooSessionOld.buildCrumbRequest(this.mySession);
                ResourceLocator.Response crumbResponse = crumbRequest.response();
                if (debug) {
                    crumbRequest.print(BasicLogger.DEBUG);
                    crumbResponse.print(BasicLogger.DEBUG);
                }
                YahooSessionOld.scrapeCrumbResponse(this.mySession, crumbResponse);
            }
            if (debug) {
                BasicLogger.debug();
                BasicLogger.debug("Should be ok now - crumb and cookie");
                this.mySession.print(BasicLogger.DEBUG);
                BasicLogger.debug();
            }
            ResourceLocator.Request request = YahooSessionOld.buildDataRequest(this.mySession, this.mySymbol, this.myResolution);
            ResourceLocator.Response response = request.response();
            return response.getInputStream();
        }

        @Override
        public CalendarDateUnit getResolution() {
            return this.myResolution;
        }

        @Override
        public String getSymbol() {
            return this.mySymbol;
        }
    }
}

