/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.constant.QuadrupleMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Scalar;

public final class QuadrupleAggregator
extends AggregatorSet<Quadruple> {
    private static final ThreadLocal<AggregatorFunction<Quadruple>> AVERAGE = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return (Quadruple)this.myNumber.divide(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    ++this.myCount;
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myCount = 0;
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> CARDINALITY = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;

                @Override
                public Quadruple get() {
                    return Quadruple.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(Quadruple anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, PrimitiveMath.ABS.invoke(anArg.doubleValue()))) {
                        ++this.myCount;
                    }
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> LARGEST = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = QuadrupleMath.MAX.invoke(this.myNumber, QuadrupleMath.ABS.invoke(anArg));
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> MAX = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.NEGATIVE_INFINITY;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = QuadrupleMath.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.NEGATIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> MIN = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.POSITIVE_INFINITY;

                @Override
                public Quadruple get() {
                    if (Quadruple.isInfinite(this.myNumber)) {
                        return Quadruple.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = QuadrupleMath.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> NORM1 = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = this.myNumber.add(PrimitiveMath.ABS.invoke(anArg.doubleValue()));
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> NORM2 = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return Quadruple.valueOf(PrimitiveMath.SQRT.invoke(PrimitiveMath.ABS.invoke(this.myNumber.doubleValue())));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    double tmpMod = PrimitiveMath.ABS.invoke(anArg.doubleValue());
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> PRODUCT = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ONE;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ONE;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> PRODUCT2 = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ONE;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ONE;
                    return this;
                }
            };
        }
    };
    private static final QuadrupleAggregator SET = new QuadrupleAggregator();
    private static final ThreadLocal<AggregatorFunction<Quadruple>> SMALLEST = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.POSITIVE_INFINITY;

                @Override
                public Quadruple get() {
                    if (Quadruple.isInfinite(this.myNumber)) {
                        return Quadruple.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    if (!Quadruple.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = QuadrupleMath.MIN.invoke(this.myNumber, QuadrupleMath.ABS.invoke(anArg));
                    }
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> SUM = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quadruple>> SUM2 = new ThreadLocal<AggregatorFunction<Quadruple>>(){

        @Override
        protected AggregatorFunction<Quadruple> initialValue() {
            return new RationalAggregatorFunction(){
                private Quadruple myNumber = Quadruple.ZERO;

                @Override
                public Quadruple get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quadruple anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<Quadruple> reset() {
                    this.myNumber = Quadruple.ZERO;
                    return this;
                }
            };
        }
    };

    public static QuadrupleAggregator getSet() {
        return SET;
    }

    private QuadrupleAggregator() {
    }

    @Override
    public AggregatorFunction<Quadruple> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<Quadruple> sum2() {
        return SUM2.get().reset();
    }

    static abstract class RationalAggregatorFunction
    implements AggregatorFunction<Quadruple> {
        RationalAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((Quadruple)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(Quadruple.valueOf(anArg));
        }

        @Override
        public final void invoke(float anArg) {
            this.invoke(Quadruple.valueOf(anArg));
        }

        @Override
        public final Scalar<Quadruple> toScalar() {
            return (Scalar)this.get();
        }
    }
}

