/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.structure.Structure2D;

public final class MatrixR064
extends BasicMatrix<Double, MatrixR064> {
    public static final Factory FACTORY = new Factory();

    MatrixR064(ElementsSupplier<Double> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    @Override
    Cholesky<Double> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.R064.make(typical);
    }

    @Override
    DeterminantTask<Double> newDeterminantTask(Structure2D template) {
        return DeterminantTask.R064.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<Double> newEigenvalue(Structure2D typical) {
        return Eigenvalue.R064.make(typical, this.isHermitian());
    }

    @Override
    MatrixR064 newInstance(ElementsSupplier<Double> store) {
        return new MatrixR064(store);
    }

    @Override
    InverterTask<Double> newInverterTask(Structure2D base) {
        return InverterTask.R064.make(base, this.isHermitian(), false);
    }

    @Override
    LDL<Double> newLDL(Structure2D typical) {
        return (LDL)LDL.R064.make(typical);
    }

    @Override
    LU<Double> newLU(Structure2D typical) {
        return (LU)LU.R064.make(typical);
    }

    @Override
    QR<Double> newQR(Structure2D typical) {
        return QR.R064.make(typical);
    }

    @Override
    SingularValue<Double> newSingularValue(Structure2D typical) {
        return SingularValue.R064.make(typical);
    }

    @Override
    SolverTask<Double> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.R064.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<Double, MatrixR064, SparseStore<Double>> {
        SparseReceiver(SparseStore<Double> delegate) {
            super(delegate);
        }

        @Override
        MatrixR064 instantiate(MatrixStore<Double> store) {
            return (MatrixR064)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<Double, MatrixR064, DenseReceiver, SparseReceiver> {
        Factory() {
            super(MatrixR064.class, Primitive64Store.FACTORY);
        }

        @Override
        DenseReceiver dense(PhysicalStore<Double> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<Double> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<Double, MatrixR064, PhysicalStore<Double>> {
        DenseReceiver(PhysicalStore<Double> delegate) {
            super(delegate);
        }

        @Override
        MatrixR064 instantiate(MatrixStore<Double> store) {
            return (MatrixR064)FACTORY.instantiate(store);
        }
    }
}

