/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;

final class OffsetStore<N extends Comparable<N>>
extends SelectingStore<N> {
    private final int myRowOffset;
    private final int myColumnOffset;

    OffsetStore(MatrixStore<N> base, int rowOffset, int columnOffset) {
        super(base, base.countRows() - (long)rowOffset, base.countColumns() - (long)columnOffset);
        this.myRowOffset = rowOffset;
        this.myColumnOffset = columnOffset;
    }

    OffsetStore(MatrixStore<N> base, long rowOffset, long columnOffset) {
        super(base, base.countRows() - rowOffset, base.countColumns() - columnOffset);
        this.myRowOffset = Math.toIntExact(rowOffset);
        this.myColumnOffset = Math.toIntExact(columnOffset);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.base().doubleValue((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
    }

    @Override
    public N get(long row, long col) {
        return this.base().get((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
    }
}

