/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public class InMemoryFile {
    private byte[] myInitialContents;
    private ByteArrayInputStream myInputStream = null;
    private String myName = null;
    private ByteArrayOutputStream myOutputStream = null;
    private String myType = null;

    public InMemoryFile() {
        this.myInitialContents = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public InMemoryFile(byte[] contents) {
        this.myInitialContents = contents;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public InMemoryFile(String contents) {
        this.myInitialContents = contents.getBytes();
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public byte[] getContentsAsByteArray() {
        if (this.myInitialContents != null) {
            return this.myInitialContents;
        }
        if (this.myOutputStream != null) {
            return this.myOutputStream.toByteArray();
        }
        throw new IllegalStateException();
    }

    public String getContentsAsString() {
        if (this.myInitialContents != null) {
            return new String(this.myInitialContents);
        }
        if (this.myOutputStream != null) {
            return this.myOutputStream.toString();
        }
        throw new IllegalStateException();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.myName);
    }

    public InMemoryFile name(String name) {
        this.setName(name);
        return this;
    }

    public InMemoryFile type(String type) {
        this.setType(type);
        return this;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.myType);
    }

    public InputStream newInputStream() {
        byte[] contents = this.getContentsAsByteArray();
        this.myInputStream = new ByteArrayInputStream(contents);
        this.myOutputStream = null;
        return this.myInputStream;
    }

    public OutputStream newOutputStream() {
        this.myOutputStream = new ByteArrayOutputStream();
        this.myInputStream = null;
        this.myInitialContents = null;
        return this.myOutputStream;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setType(String type) {
        this.myType = type;
    }
}

