/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.netio.ASCII;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;

final class FileFormatMPS {
    private static final String COMMENT = "*";
    private static final String COMMENT_REF = "&";
    private static final int[] FIELD_START = new int[]{1, 4, 14, 24, 39, 49, 64};
    private static final String INTEND = "INTEND";
    private static final String INTORG = "INTORG";
    private static final String MARKER = "MARKER";
    private static final String MAX = "MAX";
    private static final String SPACE = " ";
    private final Map<String, Row> myRows = new HashMap<String, Row>();
    private final Map<String, Column> myColumns = new HashMap<String, Column>();
    private final FieldPredicate myExistingColumn = (line, start, index, field) -> this.myColumns.containsKey(field);
    private final FieldPredicate myExistingRow = (line, start, index, field) -> this.myRows.containsKey(field);
    private final String[] myFields = new String[6];
    private String myIdBOUNDS = null;
    private String myIdRANGES = null;
    private String myIdRHS = null;
    private String myIdRowN = null;
    private boolean myIntegerMarker = false;
    private final FieldPredicate myMatchingBOUNDS = (line, start, index, field) -> {
        if (this.myIdBOUNDS != null) {
            return this.myIdBOUNDS.equals(field);
        }
        return this.nameColumns(line, field);
    };
    private final FieldPredicate myMatchingRANGES = (line, start, index, field) -> {
        if (this.myIdRANGES != null) {
            return this.myIdRANGES.equals(field);
        }
        return this.nameRows(line, field);
    };
    private final FieldPredicate myMatchingRHS = (line, start, index, field) -> {
        if (this.myIdRHS != null) {
            return this.myIdRHS.equals(field);
        }
        return this.nameRows(line, field);
    };
    private final ExpressionsBasedModel myModel = new ExpressionsBasedModel();
    private String myName;
    private Expression myQuadObjExpr = null;
    private final FieldPredicate[] myVerifierBOUNDS;
    private final FieldPredicate[] myVerifierCOLUMNS;
    private final FieldPredicate[] myVerifierQ;
    private final FieldPredicate[] myVerifierRANGES;
    private final FieldPredicate[] myVerifierRHS;
    private final FieldPredicate[] myVerifierROWS = new FieldPredicate[]{FieldPredicate.ROW_TYPE, FieldPredicate.ROW_NAME, FieldPredicate.NOT_USED, FieldPredicate.NOT_USED, FieldPredicate.NOT_USED, FieldPredicate.NOT_USED};

    static ExpressionsBasedModel read(InputStream input) {
        FileFormatMPS retVal = new FileFormatMPS();
        FileSection section = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.startsWith(COMMENT) || line.startsWith(COMMENT_REF)) continue;
                if (line.startsWith(SPACE)) {
                    retVal.parseSectionLine(section, line);
                    continue;
                }
                section = retVal.identifySection(line);
            }
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
        return retVal.getModel();
    }

    FileFormatMPS() {
        this.myVerifierCOLUMNS = new FieldPredicate[]{FieldPredicate.EMPTY, FieldPredicate.COLUMN_NAME, this.myExistingRow, FieldPredicate.NUMBER, this.myExistingRow, FieldPredicate.NUMBER};
        this.myVerifierRHS = new FieldPredicate[]{FieldPredicate.EMPTY, this.myMatchingRHS, this.myExistingRow, FieldPredicate.NUMBER, this.myExistingRow, FieldPredicate.NUMBER};
        this.myVerifierRANGES = new FieldPredicate[]{FieldPredicate.EMPTY, this.myMatchingRANGES, this.myExistingRow, FieldPredicate.NUMBER, this.myExistingRow, FieldPredicate.NUMBER};
        this.myVerifierBOUNDS = new FieldPredicate[]{FieldPredicate.BOUND_TYPE, this.myMatchingBOUNDS, this.myExistingColumn, FieldPredicate.NUMBER, this.myExistingColumn, FieldPredicate.NUMBER};
        this.myVerifierQ = new FieldPredicate[]{FieldPredicate.EMPTY, this.myExistingColumn, this.myExistingColumn, FieldPredicate.NUMBER, FieldPredicate.NOT_USED, FieldPredicate.NOT_USED};
    }

    public String toString() {
        return this.myModel.toString();
    }

    private void extractFields(String line, FieldPredicate[] verifiers) {
        int first = -1;
        int limit = -1;
        boolean word = false;
        int length = line.length();
        int f = 0;
        for (int i = 1; i < length; ++i) {
            char tecken = line.charAt(i);
            if (i == 4) {
                f = Math.max(f, 1);
            } else if (!word && i == 14) {
                f = Math.max(f, 2);
            }
            if (!word && !ASCII.isSpace(tecken)) {
                word = true;
                first = i;
            } else if (word && ASCII.isSpace(tecken)) {
                word = false;
                limit = i;
            }
            if (word && i + 1 == length) {
                word = false;
                limit = i + 1;
            }
            if (limit <= first) continue;
            String field = line.substring(first, limit);
            if (!verifiers[f].test(line, FIELD_START[f], i, field)) {
                word = true;
            } else {
                this.myFields[f++] = field;
                first = -1;
            }
            limit = -1;
        }
    }

    private ExpressionsBasedModel getModel() {
        return this.myModel;
    }

    private FileSection identifySection(String line) {
        String tmpArgument;
        String tmpSection;
        int tmpSplit = line.indexOf(SPACE);
        if (tmpSplit != -1) {
            tmpSection = line.substring(0, tmpSplit).trim();
            tmpArgument = line.substring(tmpSplit).trim();
        } else {
            tmpSection = line.trim();
            tmpArgument = "";
        }
        FileSection retVal = FileSection.valueOf(tmpSection);
        switch (retVal) {
            case NAME: {
                this.myName = tmpArgument;
                break;
            }
        }
        return retVal;
    }

    private void parseSectionLine(FileSection section, String line) {
        Arrays.fill(this.myFields, null);
        switch (section) {
            case NAME: {
                break;
            }
            case OBJSENSE: {
                if (line.contains(MAX)) {
                    this.myModel.setOptimisationSense(Optimisation.Sense.MAX);
                    break;
                }
                this.myModel.setOptimisationSense(Optimisation.Sense.MIN);
                break;
            }
            case OBJNAME: {
                break;
            }
            case ROWS: {
                this.extractFields(line, this.myVerifierROWS);
                RowType rowType = RowType.valueOf(this.myFields[0]);
                String rowName = this.myFields[1].trim();
                if (this.myIdRowN == null && rowType == RowType.N) {
                    this.myIdRowN = rowName;
                }
                this.myRows.put(this.myFields[1], new Row(rowName, rowType, this.myIdRowN));
                break;
            }
            case COLUMNS: {
                if (line.contains(MARKER)) {
                    if (line.contains(INTORG)) {
                        this.myIntegerMarker = true;
                        break;
                    }
                    if (!line.contains(INTEND)) break;
                    this.myIntegerMarker = false;
                    break;
                }
                this.extractFields(line, this.myVerifierCOLUMNS);
                Column tmpColumn = this.myColumns.computeIfAbsent(this.myFields[1].trim(), x$0 -> new Column((String)x$0));
                tmpColumn.setRowValue(this.myFields[2], new BigDecimal(this.myFields[3]));
                if (this.myFields[4] != null) {
                    tmpColumn.setRowValue(this.myFields[4], new BigDecimal(this.myFields[5]));
                }
                if (!this.myIntegerMarker) break;
                tmpColumn.integer(this.myIntegerMarker);
                break;
            }
            case RHS: {
                this.extractFields(line, this.myVerifierRHS);
                if (this.myIdRHS == null) {
                    this.myIdRHS = this.myFields[1];
                } else if (!this.myIdRHS.equals(this.myFields[1])) break;
                this.myRows.get(this.myFields[2]).rhs(new BigDecimal(this.myFields[3]));
                if (this.myFields[4] == null) break;
                this.myRows.get(this.myFields[4]).rhs(new BigDecimal(this.myFields[5]));
                break;
            }
            case RANGES: {
                this.extractFields(line, this.myVerifierRANGES);
                if (this.myIdRANGES == null) {
                    this.myIdRANGES = this.myFields[1];
                } else if (!this.myIdRANGES.equals(this.myFields[1])) break;
                this.myRows.get(this.myFields[2]).range(new BigDecimal(this.myFields[3]));
                if (this.myFields[4] == null) break;
                this.myRows.get(this.myFields[4]).range(new BigDecimal(this.myFields[5]));
                break;
            }
            case BOUNDS: {
                this.extractFields(line, this.myVerifierBOUNDS);
                if (this.myIdBOUNDS == null) {
                    this.myIdBOUNDS = this.myFields[1];
                } else if (!this.myIdBOUNDS.equals(this.myFields[1])) break;
                BoundType boundType = BoundType.valueOf(this.myFields[0]);
                this.myColumns.get(this.myFields[2]).bound(boundType, this.myFields[3] != null ? new BigDecimal(this.myFields[3]) : null);
                break;
            }
            case QUADOBJ: {
                this.extractFields(line, this.myVerifierQ);
                if (this.myQuadObjExpr == null) {
                    this.myQuadObjExpr = (Expression)this.myModel.newExpression(section.name()).weight(BigMath.HALF);
                }
                Variable var1 = this.myColumns.get(this.myFields[1]).getVariable();
                Variable var2 = this.myColumns.get(this.myFields[2]).getVariable();
                BigDecimal param3 = new BigDecimal(this.myFields[3]);
                this.myQuadObjExpr.set(var1, var2, param3);
                if (var1.equals(var2)) break;
                this.myQuadObjExpr.set(var2, var1, param3);
                break;
            }
            case QMATRIX: {
                this.extractFields(line, this.myVerifierQ);
                if (this.myQuadObjExpr == null) {
                    this.myQuadObjExpr = (Expression)this.myModel.newExpression(section.name()).weight(BigMath.HALF);
                }
                Variable varA = this.myColumns.get(this.myFields[1]).getVariable();
                Variable varB = this.myColumns.get(this.myFields[2]).getVariable();
                BigDecimal paramC = new BigDecimal(this.myFields[3]);
                this.myQuadObjExpr.set(varA, varB, paramC);
                break;
            }
            case ENDATA: {
                break;
            }
        }
    }

    boolean nameColumns(String line, String field) {
        String[] parts = line.split("\\s+");
        if (parts.length == 7 && field.equals(parts[parts.length - 5]) && this.myColumns.containsKey(parts[parts.length - 4]) && this.myColumns.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 5 && field.equals(parts[parts.length - 3]) && this.myColumns.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 6 && this.myColumns.containsKey(parts[parts.length - 4]) && this.myColumns.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 4 && this.myColumns.containsKey(parts[parts.length - 2])) {
            return true;
        }
        return line.substring(FIELD_START[1], FIELD_START[2]).trim().equals(field);
    }

    boolean nameRows(String line, String field) {
        String[] parts = line.split("\\s+");
        if (parts.length == 6 && field.equals(parts[parts.length - 5]) && this.myRows.containsKey(parts[parts.length - 4]) && this.myRows.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 4 && field.equals(parts[parts.length - 3]) && this.myRows.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 5 && this.myRows.containsKey(parts[parts.length - 4]) && this.myRows.containsKey(parts[parts.length - 2])) {
            return true;
        }
        if (parts.length == 3 && this.myRows.containsKey(parts[parts.length - 2])) {
            return true;
        }
        return line.substring(FIELD_START[1], FIELD_START[2]).trim().equals(field);
    }

    static enum RowType {
        E,
        G,
        L,
        N;

    }

    final class Row {
        private final Expression myExpression;
        private final RowType myType;

        Row(String name, RowType rowType, String objName) {
            this.myExpression = FileFormatMPS.this.myModel.newExpression(name);
            this.myType = rowType;
            if (this.myType == RowType.N && name.equals(objName)) {
                this.myExpression.weight(BigMath.ONE);
            } else {
                this.myExpression.weight(null);
                this.rhs(BigMath.ZERO);
            }
        }

        Expression getExpression() {
            return this.myExpression;
        }

        RowType getType() {
            return this.myType;
        }

        Row range(BigDecimal value) {
            switch (this.myType) {
                case E: {
                    int tmpSignum = value.signum();
                    if (tmpSignum == 1) {
                        this.myExpression.upper(this.myExpression.getLowerLimit().add(value));
                        break;
                    }
                    if (tmpSignum != -1) break;
                    this.myExpression.lower(this.myExpression.getUpperLimit().add(value));
                    break;
                }
                case L: {
                    this.myExpression.lower(this.myExpression.getUpperLimit().subtract(value.abs()));
                    break;
                }
                case G: {
                    this.myExpression.upper(this.myExpression.getLowerLimit().add(value.abs()));
                    break;
                }
            }
            return this;
        }

        Row rhs(BigDecimal value) {
            switch (this.myType) {
                case E: {
                    this.myExpression.level(value);
                    break;
                }
                case L: {
                    this.myExpression.upper(value);
                    break;
                }
                case G: {
                    this.myExpression.lower(value);
                    break;
                }
                case N: {
                    this.myExpression.addObjectiveConstant(value.negate());
                    break;
                }
            }
            return this;
        }

        void setColumnValue(String columnName, BigDecimal value) {
            this.myExpression.set(FileFormatMPS.this.myColumns.get(columnName).getVariable(), value);
        }
    }

    static enum FileSection {
        BOUNDS,
        COLUMNS,
        ENDATA,
        NAME,
        OBJNAME,
        OBJSENSE,
        QMATRIX,
        QUADOBJ,
        RANGES,
        RHS,
        ROWS,
        SOS;

    }

    static interface FieldPredicate {
        public static final FieldPredicate BOUND_TYPE = (line, start, index, field) -> field != null && field.length() == 2;
        public static final FieldPredicate COLUMN_NAME = (line, start, index, field) -> field != null && Math.max(field.length(), index - start) >= 8;
        public static final FieldPredicate EMPTY = (line, start, index, field) -> field == null || field.length() == 0;
        public static final FieldPredicate NOT_USED = (line, start, index, field) -> false;
        public static final FieldPredicate NUMBER = (line, start, index, field) -> field.length() > 0;
        public static final FieldPredicate ROW_NAME = (line, start, index, field) -> {
            if (field.length() <= 0) {
                return false;
            }
            for (int i = index + 1; i < line.length(); ++i) {
                if (ASCII.isSpace(line.charAt(i))) continue;
                return false;
            }
            return true;
        };
        public static final FieldPredicate ROW_TYPE = (line, start, index, field) -> field != null && field.length() == 1;

        public boolean test(String var1, int var2, int var3, String var4);
    }

    static enum ColumnMarker {
        INTEND,
        INTORG;

    }

    final class Column {
        private boolean mySemicontinuous = false;
        private final Variable myVariable;

        Column(String name) {
            this.myVariable = new Variable(name);
            FileFormatMPS.this.myModel.addVariable(this.myVariable);
            this.bound(BoundType.PL, null);
        }

        Column bound(BoundType type, BigDecimal value) {
            switch (type) {
                case LO: {
                    this.myVariable.lower((Comparable)value);
                    break;
                }
                case UP: {
                    this.myVariable.upper((Comparable)value);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower((Comparable)BigMath.ZERO);
                    break;
                }
                case FX: {
                    this.myVariable.level(value);
                    break;
                }
                case FR: {
                    this.myVariable.level(null);
                    break;
                }
                case MI: {
                    this.myVariable.lower((Comparable)null);
                    if (this.myVariable.isUpperLimitSet()) break;
                    this.myVariable.upper((Comparable)BigMath.ZERO);
                    break;
                }
                case PL: {
                    this.myVariable.upper((Comparable)null);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower((Comparable)BigMath.ZERO);
                    break;
                }
                case BV: {
                    ((Variable)((Variable)this.myVariable.lower((Comparable)BigMath.ZERO)).upper((Comparable)BigMath.ONE)).integer(true);
                    break;
                }
                case LI: {
                    ((Variable)((Variable)this.myVariable.lower((Comparable)value)).upper((Comparable)null)).integer(true);
                    break;
                }
                case UI: {
                    ((Variable)this.myVariable.upper((Comparable)value)).integer(true);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower((Comparable)BigMath.ZERO);
                    break;
                }
                case SC: {
                    this.mySemicontinuous = true;
                    this.myVariable.upper((Comparable)value);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower((Comparable)BigMath.ONE);
                    break;
                }
            }
            return this;
        }

        Variable getVariable() {
            return this.myVariable;
        }

        Column integer(boolean flag) {
            this.myVariable.setInteger(flag);
            return this;
        }

        boolean isSemicontinuous() {
            return this.mySemicontinuous;
        }

        void setRowValue(String rowName, BigDecimal value) {
            Row row = FileFormatMPS.this.myRows.get(rowName);
            Expression expression = row.getExpression();
            expression.set(this.myVariable, value);
        }
    }

    static enum BoundType {
        BV,
        FR,
        FX,
        LI,
        LO,
        MI,
        PL,
        SC,
        UI,
        UP;

    }
}

