/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.Stopwatch;
import org.ojalgo.type.context.NumberContext;

public abstract class GenericSolver
implements Optimisation.Solver {
    @Deprecated
    protected static final NumberContext ACCURACY = NumberContext.of(12, 14).withMode(RoundingMode.HALF_DOWN);
    public final Optimisation.Options options;
    private transient String myClassSimpleName = null;
    private final AtomicInteger myIterationsCount = new AtomicInteger(0);
    private Optimisation.State myState = Optimisation.State.UNEXPLORED;
    private final Stopwatch myStopwatch = new Stopwatch();

    private GenericSolver() {
        this(new Optimisation.Options());
    }

    protected GenericSolver(Optimisation.Options solverOptions) {
        ProgrammingError.throwIfNull((Object)solverOptions);
        this.options = solverOptions;
    }

    protected final int countIterations() {
        return this.myIterationsCount.get();
    }

    protected final long countTime() {
        return this.myStopwatch.countMillis();
    }

    protected final void error(String messagePattern, Object ... arguments) {
        BasicLogger.error(messagePattern, arguments);
    }

    protected final String getClassSimpleName() {
        if (this.myClassSimpleName == null) {
            this.myClassSimpleName = this.getClass().getSimpleName();
        }
        return this.myClassSimpleName;
    }

    protected final CalendarDateDuration getDuration() {
        return this.myStopwatch.stop(CalendarDateUnit.SECOND);
    }

    protected Optimisation.State getState() {
        return this.myState;
    }

    protected final int incrementIterationsCount() {
        int iterationsDone = this.myIterationsCount.incrementAndGet();
        if (this.isLogProgress() && iterationsDone % 100000 == 0) {
            this.logProgress(iterationsDone, this.getClassSimpleName(), this.getDuration());
        }
        return iterationsDone;
    }

    protected final boolean isIterationAllowed() {
        if (this.myState.isFailure() || Thread.currentThread().isInterrupted() || this.myState.isOptimal()) {
            return false;
        }
        if (this.myState.isFeasible() && (this.countTime() >= this.options.time_suffice || this.countIterations() >= this.options.iterations_suffice)) {
            return false;
        }
        return this.countTime() < this.options.time_abort && this.countIterations() < this.options.iterations_abort;
    }

    protected final boolean isLogDebug() {
        return this.options.logger_detailed && this.isLogProgress();
    }

    protected final boolean isLogOff() {
        return this.options.logger_appender == null || !this.options.logger_solver.isAssignableFrom(this.getClass());
    }

    protected final boolean isLogProgress() {
        return this.options.logger_appender != null && this.options.logger_solver.isAssignableFrom(this.getClass());
    }

    protected final void log() {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println();
        }
    }

    protected final void log(int tabs, String messagePattern, Object ... arguments) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println(tabs, messagePattern, arguments);
        }
    }

    protected final void log(String descripttion, Access2D<?> matrix) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.printmtrx(descripttion, matrix, this.options.print);
        }
    }

    protected final void log(String messagePattern, Object ... arguments) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println(messagePattern, arguments);
        }
    }

    protected void logProgress(int iterationsDone, String classSimpleName, CalendarDateDuration duration) {
        this.log("Done {} {} iterations in {}.", iterationsDone, classSimpleName, duration);
    }

    protected final void resetIterationsCount() {
        this.myIterationsCount.set(0);
        this.myStopwatch.reset();
    }

    protected final void setState(Optimisation.State state) {
        Objects.requireNonNull(state);
        this.myState = state;
    }

    public static abstract class Builder<B extends Builder<B, S>, S extends GenericSolver>
    implements Optimisation.ProblemStructure {
        private static final PhysicalStore.Factory<Double, Primitive64Store> FACTORY = Primitive64Store.FACTORY;
        private Map<String, MultiaryFunction.TwiceDifferentiable<Double>> myAdditionalConstraints = null;
        private RowsSupplier<Double> myAE = null;
        private RowsSupplier<Double> myAI = null;
        private MatrixStore<Double> myBE = null;
        private MatrixStore<Double> myBI = null;
        private Primitive64Store myLowerBounds = null;
        private transient int myNumberOfVariables = -1;
        private MultiaryFunction.TwiceDifferentiable<Double> myObjective = null;
        private Primitive64Store myUpperBounds = null;

        private static MatrixStore<Double> add(RowsSupplier<Double> baseA, MatrixStore<Double> baseB, Access2D<?> addA, Access1D<?> addB) {
            ProgrammingError.throwIfNull(addA, addB);
            ProgrammingError.throwIfNotEqualRowDimensions(addA, addB);
            int baseRowDim = baseA.getRowDim();
            int addRowDim = addA.getRowDim();
            int addColDim = addA.getColDim();
            baseA.addRows(addRowDim);
            if (addA instanceof SparseStore) {
                ((SparseStore)addA).nonzeros().forEach(nz -> baseA.getRow(baseRowDim + Math.toIntExact(nz.row())).set(nz.column(), nz.doubleValue()));
            } else {
                for (int i = 0; i < addRowDim; ++i) {
                    SparseArray<Double> tmpRow = baseA.getRow(baseRowDim + i);
                    for (int j = 0; j < addColDim; ++j) {
                        double value = addA.doubleValue(i, j);
                        if (value == PrimitiveMath.ZERO) continue;
                        tmpRow.set((long)j, value);
                    }
                }
            }
            Primitive64Store retB = (Primitive64Store)FACTORY.make(baseRowDim + addRowDim, 1);
            retB.fillMatching(baseB);
            retB.regionByOffsets(baseRowDim, 0).fillMatching(addB);
            return retB;
        }

        protected static final void append(StringBuilder builder, String label, MatrixStore<Double> matrix) {
            if (builder != null && label != null && matrix != null) {
                builder.append("\n[");
                builder.append(label);
                builder.append("] = ");
                builder.append(Access2D.toString(matrix));
            }
        }

        protected Builder() {
        }

        public final S build() {
            this.validate();
            return this.doBuild(new Optimisation.Options());
        }

        public final S build(Optimisation.Options options) {
            ProgrammingError.throwIfNull((Object)options);
            this.validate();
            return this.doBuild(options);
        }

        @Override
        public int countAdditionalConstraints() {
            return this.myAdditionalConstraints != null ? this.myAdditionalConstraints.size() : 0;
        }

        @Override
        public int countConstraints() {
            return this.countEqualityConstraints() + this.countInequalityConstraints() + this.countAdditionalConstraints();
        }

        @Override
        public int countEqualityConstraints() {
            return this.myAE != null ? this.myAE.getRowDim() : 0;
        }

        @Override
        public int countInequalityConstraints() {
            return this.myAI != null ? this.myAI.getRowDim() : 0;
        }

        @Override
        public int countVariables() {
            if (this.myNumberOfVariables < 0) {
                this.myNumberOfVariables = this.doCountVariables();
            }
            return this.myNumberOfVariables;
        }

        public void reset() {
            if (this.myAdditionalConstraints != null) {
                this.myAdditionalConstraints.clear();
            }
            this.myAdditionalConstraints = null;
            this.myAE = null;
            this.myAI = null;
            this.myBE = null;
            this.myBI = null;
            this.myLowerBounds = null;
            this.myObjective = null;
            this.myUpperBounds = null;
            this.myNumberOfVariables = -1;
        }

        public final Optimisation.Result solve() {
            return this.build().solve();
        }

        public final String toString() {
            String simpleName = this.getClass().getSimpleName();
            StringBuilder retVal = new StringBuilder();
            retVal.append("<");
            retVal.append(simpleName);
            retVal.append(">");
            this.append(retVal);
            retVal.append("\n</");
            retVal.append(simpleName);
            retVal.append(">");
            return retVal.toString();
        }

        protected void append(StringBuilder builder) {
            Builder.append(builder, "AE", this.getAE());
            Builder.append(builder, "BE", this.getBE());
            Builder.append(builder, "AI", this.getAI());
            Builder.append(builder, "BI", this.getBI());
            Builder.append(builder, "C", this.getC());
        }

        protected abstract S doBuild(Optimisation.Options var1);

        protected int doCountVariables() {
            if (this.myAE != null) {
                return this.myAE.getColDim();
            }
            if (this.myAI != null) {
                return this.myAI.getColDim();
            }
            if (this.myObjective != null) {
                return this.myObjective.arity();
            }
            throw new ProgrammingError("Cannot deduce the number of variables!");
        }

        protected B equalities(Access2D<?> mtrxAE, Access1D<?> mtrxBE) {
            this.setEqualities(mtrxAE, mtrxBE);
            return (B)this;
        }

        protected B equality(double rhs, double ... factors) {
            Primitive64Store mBody = (Primitive64Store)FACTORY.make(1, this.countVariables());
            int limit = Math.min(factors.length, this.countVariables());
            for (int i = 0; i < limit; ++i) {
                mBody.set((long)i, factors[i]);
            }
            MatrixStore<Double> mRHS = FACTORY.makeSingle(rhs);
            this.addEqualities(mBody, mRHS);
            return (B)this;
        }

        protected MatrixStore<Double> getAE() {
            if (this.myAE != null) {
                return this.myAE.get();
            }
            return FACTORY.makeZero(0L, this.countVariables());
        }

        protected SparseArray<Double> getAE(int row) {
            return this.myAE.getRow(row);
        }

        protected RowsSupplier<Double> getAE(int ... rows) {
            return this.myAE.selectRows(rows);
        }

        protected MatrixStore<Double> getAI() {
            if (this.myAI != null) {
                return this.myAI.get();
            }
            return FACTORY.makeZero(0L, this.countVariables());
        }

        protected SparseArray<Double> getAI(int row) {
            return this.myAI.getRow(row);
        }

        protected RowsSupplier<Double> getAI(int ... rows) {
            return this.myAI.selectRows(rows);
        }

        protected MatrixStore<Double> getBE() {
            if (this.myBE != null) {
                return this.myBE;
            }
            return FACTORY.makeZero(0L, 1L);
        }

        protected double getBE(int row) {
            return this.myBE.doubleValue(row);
        }

        protected MatrixStore<Double> getBI() {
            if (this.myBI != null) {
                return this.myBI;
            }
            return FACTORY.makeZero(0L, 1L);
        }

        protected double getBI(int row) {
            return this.myBI.doubleValue(row);
        }

        protected MatrixStore<Double> getC() {
            return this.getObjective().getLinearFactors(false);
        }

        protected PhysicalStore.Factory<Double, Primitive64Store> getFactory() {
            return FACTORY;
        }

        protected Primitive64Store getLowerBounds(double defaultValue) {
            if (this.myLowerBounds == null) {
                this.myLowerBounds = (Primitive64Store)FACTORY.make(this.countVariables(), 1);
                this.myLowerBounds.fillAll(defaultValue);
            }
            return this.myLowerBounds;
        }

        protected MultiaryFunction.TwiceDifferentiable<Double> getObjective() {
            return this.myObjective;
        }

        protected <T extends MultiaryFunction.TwiceDifferentiable<Double>> T getObjective(Class<T> type) {
            return (T)this.myObjective;
        }

        protected Access2D.RowView<Double> getRowsAE() {
            return this.myAE.rows();
        }

        protected Access2D.RowView<Double> getRowsAI() {
            return this.myAI.rows();
        }

        protected Primitive64Store getUpperBounds(double defaultValue) {
            if (this.myUpperBounds == null) {
                this.myUpperBounds = (Primitive64Store)FACTORY.make(this.countVariables(), 1);
                this.myUpperBounds.fillAll(defaultValue);
            }
            return this.myUpperBounds;
        }

        protected B inequalities(Access2D<?> mtrxAI, Access1D<?> mtrxBI) {
            this.setInequalities(mtrxAI, mtrxBI);
            return (B)this;
        }

        protected B inequality(double rhs, double ... factors) {
            Primitive64Store mBody = (Primitive64Store)FACTORY.make(1, this.countVariables());
            int limit = Math.min(factors.length, this.countVariables());
            for (int i = 0; i < limit; ++i) {
                mBody.set((long)i, factors[i]);
            }
            MatrixStore<Double> mRHS = FACTORY.makeSingle(rhs);
            this.addInequalities(mBody, mRHS);
            return (B)this;
        }

        protected void setNumberOfVariables(int numberOfVariables) {
            if (numberOfVariables < 0) {
                throw new IllegalArgumentException();
            }
            if (this.myNumberOfVariables >= 0 && this.myNumberOfVariables != numberOfVariables) {
                throw new IllegalStateException();
            }
            this.myNumberOfVariables = numberOfVariables;
        }

        protected void setObjective(MultiaryFunction.TwiceDifferentiable<Double> objective) {
            ProgrammingError.throwIfNull(objective);
            this.myObjective = objective;
        }

        void addConstraint(String key, MultiaryFunction.TwiceDifferentiable<Double> value) {
            if (this.myAdditionalConstraints == null) {
                this.myAdditionalConstraints = new HashMap<String, MultiaryFunction.TwiceDifferentiable<Double>>();
            }
            this.myAdditionalConstraints.put(key, value);
        }

        void addEqualities(MatrixStore<?> mtrxAE, MatrixStore<?> mtrxBE) {
            ProgrammingError.throwIfNull(mtrxAE, mtrxBE);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAE, mtrxBE);
            if (this.myAE == null || this.myBE == null) {
                this.myAE = FACTORY.makeRowsSupplier(mtrxAE.getColDim());
                this.myBE = FACTORY.makeZero(0L, 1L);
            }
            this.myBE = Builder.add(this.myAE, this.myBE, mtrxAE, mtrxBE);
        }

        void addInequalities(MatrixStore<?> mtrxAI, MatrixStore<?> mtrxBI) {
            ProgrammingError.throwIfNull(mtrxAI, mtrxBI);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAI, mtrxBI);
            if (this.myAI == null || this.myBI == null) {
                this.myAI = FACTORY.makeRowsSupplier(mtrxAI.getColDim());
                this.myBI = FACTORY.makeZero(0L, 0L);
            }
            this.myBI = Builder.add(this.myAI, this.myBI, mtrxAI, mtrxBI);
        }

        void newEqualities(int nbEqualities, int nbVariables) {
            MatrixStore mtrxAE = (MatrixStore)FACTORY.make(nbEqualities, nbVariables);
            MatrixStore mtrxBE = (MatrixStore)FACTORY.make(nbEqualities, 1);
            this.setEqualities(mtrxAE, mtrxBE);
        }

        void newInequalities(int nbInequalities, int nbVariables) {
            RowsSupplier<Double> mtrxAI = FACTORY.makeRowsSupplier(nbVariables);
            mtrxAI.addRows(nbInequalities);
            MatrixStore mtrxBI = (MatrixStore)FACTORY.make(nbInequalities, 1);
            this.setInequalities(mtrxAI, mtrxBI);
        }

        void setBounds(Access1D<Double> lower, Access1D<Double> upper) {
            ProgrammingError.throwIfNull(lower, upper);
            this.myLowerBounds = lower instanceof Primitive64Store ? (Primitive64Store)lower : (Primitive64Store)FACTORY.columns(lower);
            this.myUpperBounds = upper instanceof Primitive64Store ? (Primitive64Store)upper : (Primitive64Store)FACTORY.columns(upper);
        }

        void setEqualities(Access2D<?> mtrxAE, Access1D<?> mtrxBE) {
            ProgrammingError.throwIfNull(mtrxAE, mtrxBE);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAE, mtrxBE);
            this.myAE = FACTORY.makeRowsSupplier(mtrxAE.getColDim());
            this.myBE = FACTORY.makeZero(0L, 0L);
            this.myBE = Builder.add(this.myAE, this.myBE, mtrxAE, mtrxBE);
        }

        void setInequalities(Access2D<?> mtrxAI, Access1D<?> mtrxBI) {
            ProgrammingError.throwIfNull(mtrxAI, mtrxBI);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAI, mtrxBI);
            this.myAI = FACTORY.makeRowsSupplier(mtrxAI.getColDim());
            this.myBI = FACTORY.makeZero(0L, 0L);
            this.myBI = Builder.add(this.myAI, this.myBI, mtrxAI, mtrxBI);
        }

        void validate() {
            ProgrammingError.throwIfNull(this.myObjective);
            if (this.myAE != null || this.myBE != null) {
                ProgrammingError.throwIfNull(this.myAE, this.myBE);
                ProgrammingError.throwIfNotEqualRowDimensions(this.myAE, this.myBE);
            }
            if (this.myAI != null || this.myBI != null) {
                ProgrammingError.throwIfNull(this.myAI, this.myBI);
                ProgrammingError.throwIfNotEqualRowDimensions(this.myAI, this.myBI);
            }
            int nbVariables = this.countVariables();
            if (this.myAE != null && this.myAE.getColDim() != nbVariables) {
                throw new ProgrammingError("AE has the wrong number of columns!");
            }
            if (this.myBE != null && this.myBE.getColDim() != 1) {
                throw new ProgrammingError("BE must have precisely one column!");
            }
            if (this.myAI != null && this.myAI.getColDim() != nbVariables) {
                throw new ProgrammingError("AI has the wrong number of columns!");
            }
            if (this.myBI != null && this.myBI.getColDim() != 1) {
                throw new ProgrammingError("BI must have precisely one column!");
            }
            if (this.myObjective != null && this.myObjective.arity() != nbVariables) {
                throw new ProgrammingError("The objective function has the wrong arity!");
            }
        }
    }
}

