/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.PureQuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class ConvexObjectiveFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Quadratic<N> {
    private final LinearFunction<N> myLinear;
    private final PureQuadraticFunction<N> myPureQuadratic;
    private final Scalar.Factory<N> myScalarFactory;

    ConvexObjectiveFunction(PhysicalStore.Factory<N, ?> factory, int nbVars) {
        this((PhysicalStore)factory.make(nbVars, nbVars), (PhysicalStore)factory.make(nbVars, 1));
    }

    ConvexObjectiveFunction(PhysicalStore<N> quadratic, PhysicalStore<N> linear) {
        this.myScalarFactory = quadratic.physical().scalar();
        this.myPureQuadratic = PureQuadraticFunction.wrap(quadratic);
        this.myLinear = LinearFunction.wrap(linear);
        if (this.myPureQuadratic.arity() != this.myLinear.arity()) {
            throw new IllegalArgumentException("Must have the same arity!");
        }
    }

    @Override
    public int arity() {
        return this.myLinear.arity();
    }

    @Override
    public N getConstant() {
        return this.myPureQuadratic.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.myPureQuadratic.getGradient(point).subtract(this.myLinear.getGradient(point));
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myPureQuadratic.getHessian(point);
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        return this.myLinear.getLinearFactors(!negated);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        Scalar<N> zero = this.myScalarFactory.zero();
        Scalar<N> one = this.myScalarFactory.one();
        Scalar<N> two = one.add(one);
        Scalar retVal = ((Scalar)zero.add(this.myPureQuadratic.invoke(arg))).divide(two);
        retVal = (Scalar)retVal.subtract(this.myLinear.invoke(arg));
        retVal.add(this.getConstant());
        return (N)((Comparable)retVal.get());
    }

    @Override
    public PhysicalStore<N> linear() {
        return this.myLinear.linear();
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return this.myPureQuadratic.quadratic();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myPureQuadratic.setConstant(constant);
    }
}

