/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Structure1D;

public interface Structure2D
extends Structure1D {
    public static int column(int index, int structure) {
        return index / structure;
    }

    public static int column(int index, int[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static int column(long index, int structure) {
        return (int)(index / (long)structure);
    }

    public static long column(long index, long structure) {
        return index / structure;
    }

    public static long column(long index, long[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static long count(long numberOfRows, long numberOfColumnns) {
        return numberOfRows * numberOfColumnns;
    }

    public static int firstInColumn(Structure1D structure, int col, int defaultAndMinimum) {
        return structure instanceof Structure2D ? Math.max(((Structure2D)structure).firstInColumn(col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static long firstInColumn(Structure1D structure, long col, long defaultAndMinimum) {
        return structure instanceof Structure2D ? Math.max((long)((Structure2D)structure).firstInColumn((int)col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static int firstInRow(Structure1D structure, int row, int defaultAndMinimum) {
        return structure instanceof Structure2D ? Math.max(((Structure2D)structure).firstInRow(row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static long firstInRow(Structure1D structure, long row, long defaultAndMinimum) {
        return structure instanceof Structure2D ? Math.max((long)((Structure2D)structure).firstInRow((int)row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static long index(long structure, long row, long column) {
        return row + column * structure;
    }

    public static int limitOfColumn(Structure1D structure, int col, int defaultAndMaximum) {
        return structure instanceof Structure2D ? Math.min(((Structure2D)structure).limitOfColumn(col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static long limitOfColumn(Structure1D structure, long col, long defaultAndMaximum) {
        return structure instanceof Structure2D ? Math.min((long)((Structure2D)structure).limitOfColumn((int)col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static int limitOfRow(Structure1D structure, int row, int defaultAndMaximum) {
        return structure instanceof Structure2D ? Math.min(((Structure2D)structure).limitOfRow(row), defaultAndMaximum) : defaultAndMaximum;
    }

    public static long limitOfRow(Structure1D structure, long row, long defaultAndMaximum) {
        return structure instanceof Structure2D ? Math.min((long)((Structure2D)structure).limitOfRow((int)row), defaultAndMaximum) : defaultAndMaximum;
    }

    @Deprecated
    public static void loopMatching(Structure2D structureA, Structure2D structureB, RowColumnCallback callback) {
        long tmpCountRows = Math.min(structureA.countRows(), structureB.countRows());
        long tmpCountColumns = Math.min(structureA.countColumns(), structureB.countColumns());
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    public static <R, C> RowColumnMapper<R, C> mapperOf(Structure2D structure, Structure1D.IndexMapper<R> rowMappwer, Structure1D.IndexMapper<C> columnMappwer) {
        return new RowColumnMapper<R, C>(structure, rowMappwer, columnMappwer);
    }

    public static int row(int index, int structure) {
        return index % structure;
    }

    public static int row(int index, int[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    public static int row(long index, int structure) {
        return (int)(index % (long)structure);
    }

    public static long row(long index, long structure) {
        return index % structure;
    }

    public static long row(long index, long[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    @Override
    default public long count() {
        return this.countRows() * this.countColumns();
    }

    public long countColumns();

    public long countRows();

    default public int firstInColumn(int col) {
        return 0;
    }

    default public int firstInRow(int row) {
        return 0;
    }

    default public int getColDim() {
        return Math.toIntExact(this.countColumns());
    }

    default public int getMaxDim() {
        return Math.toIntExact(Math.max(this.countRows(), this.countColumns()));
    }

    default public int getMinDim() {
        return Math.toIntExact(Math.min(this.countRows(), this.countColumns()));
    }

    default public int getRowDim() {
        return Math.toIntExact(this.countRows());
    }

    default public boolean isEmpty() {
        return this.countRows() <= 0L || this.countColumns() <= 0L;
    }

    default public boolean isFat() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows < this.countColumns();
    }

    default public boolean isScalar() {
        return this.countRows() == 1L && this.countColumns() == 1L;
    }

    default public boolean isSquare() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows == this.countColumns();
    }

    default public boolean isTall() {
        long tmpCountColumns = this.countColumns();
        return tmpCountColumns > 0L && this.countRows() > tmpCountColumns;
    }

    default public boolean isVector() {
        return this.countColumns() == 1L || this.countRows() == 1L;
    }

    default public int limitOfColumn(int col) {
        return this.getRowDim();
    }

    default public int limitOfRow(int row) {
        return this.getColDim();
    }

    @Deprecated
    default public void loopAll(RowColumnCallback callback) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    @Deprecated
    default public void loopColumn(long row, long col, RowColumnCallback callback) {
        long limit = this.countRows();
        for (long i = row; i < limit; ++i) {
            callback.call(i, col);
        }
    }

    @Deprecated
    default public void loopColumn(long col, RowColumnCallback callback) {
        this.loopColumn(0L, col, callback);
    }

    @Deprecated
    default public void loopDiagonal(long row, long col, RowColumnCallback callback) {
        long limit = Math.min(this.countRows() - row, this.countColumns() - col);
        for (long ij = 0L; ij < limit; ++ij) {
            callback.call(row + ij, col + ij);
        }
    }

    @Deprecated
    default public void loopRow(long row, long col, RowColumnCallback callback) {
        long limit = this.countColumns();
        for (long j = col; j < limit; ++j) {
            callback.call(row, j);
        }
    }

    @Deprecated
    default public void loopRow(long row, RowColumnCallback callback) {
        this.loopRow(row, 0L, callback);
    }

    public static class RowColumnMapper<R, C>
    implements Structure1D.IndexMapper<RowColumnKey<R, C>> {
        private final Structure1D.IndexMapper<C> myColumnMapper;
        private final Structure1D.IndexMapper<R> myRowMapper;
        private final long myStructure;

        protected RowColumnMapper(Structure2D structure, Structure1D.IndexMapper<R> rowMapper, Structure1D.IndexMapper<C> columnMapper) {
            this.myStructure = structure.countRows();
            this.myRowMapper = rowMapper;
            this.myColumnMapper = columnMapper;
        }

        public long toColumnIndex(C columnKey) {
            return this.myColumnMapper.toIndex(columnKey);
        }

        public C toColumnKey(long index) {
            long col = Structure2D.column(index, this.myStructure);
            return this.myColumnMapper.toKey(col);
        }

        public long toIndex(R rowKey, C colKey) {
            long row = this.myRowMapper.toIndex(rowKey);
            long col = this.myColumnMapper.toIndex(colKey);
            return Structure2D.index(this.myStructure, row, col);
        }

        @Override
        public long toIndex(RowColumnKey<R, C> key) {
            return this.toIndex(key.row, key.column);
        }

        @Override
        public RowColumnKey<R, C> toKey(long index) {
            return RowColumnKey.of(this.toRowKey(index), this.toColumnKey(index));
        }

        public long toRowIndex(R rowKey) {
            return this.myRowMapper.toIndex(rowKey);
        }

        public R toRowKey(long index) {
            long row = Structure2D.row(index, this.myStructure);
            return this.myRowMapper.toKey(row);
        }
    }

    public static class RowColumnKey<R, C> {
        public final C column;
        public final R row;

        public static <R, C> RowColumnKey<R, C> of(R row, C col) {
            return new RowColumnKey<R, C>(row, col);
        }

        public RowColumnKey(R theRow, C theCol) {
            this.row = theRow;
            this.column = theCol;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof RowColumnKey)) {
                return false;
            }
            RowColumnKey other = (RowColumnKey)obj;
            if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
                return false;
            }
            return !(this.row == null ? other.row != null : !this.row.equals(other.row));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            return 31 * result + (this.row == null ? 0 : this.row.hashCode());
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface RowColumnCallback {
        public void call(long var1, long var3);
    }

    public static interface Reshapable
    extends Structure2D {
        public Structure1D flatten();

        public Structure2D reshape(long var1, long var3);
    }

    public static interface ReducibleTo1D<R extends Structure1D>
    extends Structure2D {
        public R reduceColumns(Aggregator var1);

        public R reduceRows(Aggregator var1);
    }

    public static final class LongRowColumn
    implements Comparable<LongRowColumn> {
        public final long column;
        public final long row;
        private transient Structure1D.LongIndex myColumn = null;
        private transient Structure1D.LongIndex myRow = null;

        public LongRowColumn(long aRow, long aCol) {
            this.row = aRow;
            this.column = aCol;
        }

        public LongRowColumn(Structure1D.LongIndex aRow, Structure1D.LongIndex aCol) {
            this.row = aRow.index;
            this.column = aCol.index;
            this.myRow = aRow;
            this.myColumn = aCol;
        }

        private LongRowColumn() {
            this(-1L, -1L);
        }

        public Structure1D.LongIndex column() {
            if (this.myColumn == null) {
                this.myColumn = Structure1D.LongIndex.of(this.column);
            }
            return this.myColumn;
        }

        @Override
        public int compareTo(LongRowColumn ref) {
            if (this.column == ref.column) {
                return Long.compare(this.row, ref.row);
            }
            return Long.compare(this.column, ref.column);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LongRowColumn)) {
                return false;
            }
            LongRowColumn other = (LongRowColumn)obj;
            return this.column == other.column && this.row == other.row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.column ^ this.column >>> 32);
            return 31 * result + (int)(this.row ^ this.row >>> 32);
        }

        public Structure1D.LongIndex row() {
            if (this.myRow == null) {
                this.myRow = Structure1D.LongIndex.of(this.row);
            }
            return this.myRow;
        }

        public String toString() {
            return "<" + Long.toString(this.row) + "," + Long.toString(this.column) + ">";
        }
    }

    public static interface Logical<S extends Structure2D, B extends Logical<S, B>>
    extends Structure2D {
        public B above(long var1);

        public B above(S ... var1);

        public B above(S var1);

        public B below(long var1);

        public B below(S ... var1);

        public B below(S var1);

        public B bidiagonal(boolean var1);

        default public B column(int column) {
            return this.columns(column);
        }

        default public B column(long column) {
            return this.columns(column);
        }

        public B columns(int ... var1);

        default public B columns(long ... columns) {
            return this.columns(Structure1D.toIntIndexes(columns));
        }

        public B conjugate();

        public B diagonal();

        public B diagonally(S ... var1);

        public B hermitian(boolean var1);

        public B hessenberg(boolean var1);

        public B left(long var1);

        public B left(S ... var1);

        public B left(S var1);

        public B limits(long var1, long var3);

        public B offsets(long var1, long var3);

        public B repeat(int var1, int var2);

        public B right(long var1);

        public B right(S ... var1);

        public B right(S var1);

        default public B row(int row) {
            return this.rows(row);
        }

        default public B row(long row) {
            return this.rows(row);
        }

        public B rows(int ... var1);

        default public B rows(long ... rows) {
            return this.rows(Structure1D.toIntIndexes(rows));
        }

        public B superimpose(long var1, long var3, S var5);

        default public B superimpose(S matrix) {
            return this.superimpose(0L, 0L, matrix);
        }

        public B symmetric(boolean var1);

        public B transpose();

        public B triangular(boolean var1, boolean var2);

        public B tridiagonal();
    }

    public static final class IntRowColumn
    implements Comparable<IntRowColumn> {
        public final int column;
        public final int row;
        private transient Structure1D.IntIndex myColumn = null;
        private transient Structure1D.IntIndex myRow = null;

        public IntRowColumn(int aRow, int aCol) {
            this.row = aRow;
            this.column = aCol;
        }

        public IntRowColumn(Structure1D.IntIndex aRow, Structure1D.IntIndex aCol) {
            this.row = aRow.index;
            this.column = aCol.index;
            this.myRow = aRow;
            this.myColumn = aCol;
        }

        private IntRowColumn() {
            this(-1, -1);
        }

        public Structure1D.IntIndex column() {
            if (this.myColumn == null) {
                this.myColumn = Structure1D.IntIndex.of(this.column);
            }
            return this.myColumn;
        }

        @Override
        public int compareTo(IntRowColumn ref) {
            if (this.column == ref.column) {
                return Integer.compare(this.row, ref.row);
            }
            return Integer.compare(this.column, ref.column);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IntRowColumn other = (IntRowColumn)obj;
            return this.column == other.column && this.row == other.row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.column;
            return 31 * result + this.row;
        }

        public Structure1D.IntIndex row() {
            if (this.myRow == null) {
                this.myRow = Structure1D.IntIndex.of(this.row);
            }
            return this.myRow;
        }

        public String toString() {
            return "<" + Integer.toString(this.row) + "," + Integer.toString(this.column) + ">";
        }
    }
}

