/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import org.ojalgo.array.Array2D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.tensor.ArrayBasedTensor;
import org.ojalgo.tensor.TensorFactory2D;
import org.ojalgo.type.math.MathType;

public final class MatrixTensor<N extends Comparable<N>>
extends ArrayBasedTensor<N, MatrixTensor<N>>
implements Access2D<N>,
Mutate2D.Receiver<N> {
    private final Array2D<N> myArray;
    private final Array2D.Factory<N> myFactory;

    public static <N extends Comparable<N>> TensorFactory2D<N, MatrixTensor<N>> factory(DenseArray.Factory<N> arrayFactory) {
        return new TensorFactory2D(new Factory<N>(arrayFactory));
    }

    MatrixTensor(Array2D.Factory<N> factory, int dimensions) {
        super(2, dimensions, factory.function(), factory.scalar());
        this.myFactory = factory;
        this.myArray = (Array2D)factory.make(dimensions, dimensions);
    }

    @Override
    public MatrixTensor<N> add(MatrixTensor<N> addend) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.add(((MatrixTensor)retVal).getArray(), this.myArray, addend);
        return retVal;
    }

    @Override
    public byte byteValue(long row, long col) {
        return this.myArray.byteValue(row, col);
    }

    @Override
    public MatrixTensor<N> conjugate() {
        ArrayBasedTensor retVal = this.newSameShape();
        Array2D<N> array = ((MatrixTensor)retVal).getArray();
        for (int j = 0; j < this.dimensions(); ++j) {
            for (int i = 0; i < this.dimensions(); ++i) {
                array.set((long)i, (long)j, (Comparable<?>)this.myArray.get(j, i));
            }
        }
        return retVal;
    }

    @Override
    public long count() {
        return this.myArray.count();
    }

    @Override
    public long countColumns() {
        return this.myArray.countColumns();
    }

    @Override
    public long countRows() {
        return this.myArray.countRows();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myArray.doubleValue(row, col);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof MatrixTensor)) {
            return false;
        }
        MatrixTensor other = (MatrixTensor)obj;
        if (this.myArray == null ? other.myArray != null : !this.myArray.equals(other.myArray)) {
            return false;
        }
        return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
    }

    @Override
    public float floatValue(long row, long col) {
        return this.myArray.floatValue(row, col);
    }

    @Override
    public N get(long row, long col) {
        return this.myArray.get(row, col);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myArray == null ? 0 : this.myArray.hashCode());
        return 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
    }

    @Override
    public int intValue(long row, long col) {
        return this.myArray.intValue(row, col);
    }

    @Override
    public long longValue(long row, long col) {
        return this.myArray.longValue(row, col);
    }

    @Override
    public MatrixTensor<N> multiply(double scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((MatrixTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public MatrixTensor<N> multiply(N scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((MatrixTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public MatrixTensor<N> negate() {
        ArrayBasedTensor retVal = this.newSameShape();
        this.negate(((MatrixTensor)retVal).getArray(), this.myArray);
        return retVal;
    }

    @Override
    public double norm() {
        return this.norm(this.myArray);
    }

    @Override
    public void set(long row, long col, byte value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, float value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, int value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, long value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public void set(long row, long col, short value) {
        this.myArray.set(row, col, value);
    }

    @Override
    public short shortValue(long row, long col) {
        return this.myArray.shortValue(row, col);
    }

    public String toString() {
        return Access2D.toString(this.myArray);
    }

    Array2D<N> getArray() {
        return this.myArray;
    }

    @Override
    MatrixTensor<N> newSameShape() {
        return new MatrixTensor<N>(this.myFactory, this.dimensions());
    }

    static final class Factory<N extends Comparable<N>>
    extends ArrayBasedTensor.Factory<N>
    implements Factory2D<MatrixTensor<N>> {
        private final Array2D.Factory<N> myFactory;

        Factory(DenseArray.Factory<N> arrayFactory) {
            super(arrayFactory);
            this.myFactory = Array2D.factory(arrayFactory);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof Factory)) {
                return false;
            }
            Factory other = (Factory)obj;
            return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            return 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        }

        @Override
        public MatrixTensor<N> make(long rows, long columns) {
            if (rows != columns) {
                throw new IllegalArgumentException();
            }
            return new MatrixTensor<N>(this.myFactory, Math.toIntExact(rows));
        }

        @Override
        public MathType getMathType() {
            return this.myFactory.getMathType();
        }
    }
}

