/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.threading.task;

import fr.profi.mzscope.ConverterListener;
import fr.profi.mzscope.ConverterManager;
import fr.profi.mzscope.threading.queue.AbstractCallback;
import fr.profi.mzscope.threading.queue.AbstractTask;
import fr.profi.mzscope.threading.task.ConvertRawFile2MzdbCallback;
import fr.profi.mzscope.threading.task.TaskError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ConvertRawFile2MzdbTask
extends AbstractTask {
    private File m_file;
    private Process m_conversionProcess = null;
    private String m_outputTempFilePath = null;
    private String m_outputMzdbFilePath = null;
    private ConverterListener m_converterListener;

    public ConvertRawFile2MzdbTask(AbstractCallback callback, File f) {
        super(callback);
        this.m_file = f;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getUniqueKey() {
        return this.m_file.getName().toLowerCase();
    }

    public File getFile() {
        return this.m_file;
    }

    public void setListener(ConverterListener listener) {
        this.m_converterListener = listener;
    }

    @Override
    public boolean precheck() {
        boolean deleted;
        int index;
        this.logger.debug("file conversion precheck " + this.getFile().getAbsolutePath());
        if (!ConverterManager.getConverterExeFile().exists()) {
            this.logger.warn("Converter executable doesn't exists.");
            return false;
        }
        String path = this.getFile().getAbsolutePath();
        String mzdbFilePath = path.substring(0, (index = path.lastIndexOf(".")) + 1) + "mzdb";
        File mzdbFile = new File(mzdbFilePath);
        if (mzdbFile.exists()) {
            this.m_taskError = new TaskError("mzDB file corresponding to " + this.getFile().getAbsolutePath() + " already exists.");
            this.logger.warn("mzDB file corresponding to " + this.getFile().getAbsolutePath() + " already exists.");
            return false;
        }
        this.m_outputMzdbFilePath = mzdbFilePath;
        String mzdbTmpFilePath = path.substring(0, index + 1) + "mzdb.tmp";
        File tempFile = new File(mzdbTmpFilePath);
        if (tempFile.exists() && !(deleted = tempFile.delete())) {
            this.m_taskError = new TaskError("Can't delete temp file " + tempFile.getAbsolutePath());
            this.logger.warn("Can't delete file " + tempFile.getAbsolutePath());
            return false;
        }
        this.m_outputTempFilePath = mzdbTmpFilePath;
        return true;
    }

    @Override
    public boolean runTask() {
        if (this.m_converterListener != null) {
            this.m_converterListener.convertStart(this.getFile());
        }
        if (!this.precheck()) {
            if (this.m_callback instanceof ConvertRawFile2MzdbCallback) {
                ((ConvertRawFile2MzdbCallback)this.m_callback).setMzdbFile(null);
                ((ConvertRawFile2MzdbCallback)this.m_callback).setRawFile(this.getFile());
            }
            return false;
        }
        this.logger.info("File conversion start " + this.getFile().getAbsolutePath());
        if (!this.convertFile()) {
            if (this.m_callback instanceof ConvertRawFile2MzdbCallback) {
                ((ConvertRawFile2MzdbCallback)this.m_callback).setMzdbFile(null);
                ((ConvertRawFile2MzdbCallback)this.m_callback).setRawFile(this.getFile());
            }
            return false;
        }
        try {
            this.logger.warn("Check m_conversionProcess");
            while (this.m_conversionProcess != null && this.m_conversionProcess.isAlive()) {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException ex) {
            this.logger.error("File Finalization Interrupted!");
        }
        if (this.m_conversionProcess != null && this.m_conversionProcess.exitValue() == 0) {
            File tmpFile = new File(this.m_outputTempFilePath);
            File mzdbFile = new File(this.m_outputMzdbFilePath);
            if (tmpFile.exists()) {
                String log = tmpFile.getAbsolutePath() + " size is " + tmpFile.length() + " bytes";
                this.logger.debug(log);
                if (!tmpFile.renameTo(mzdbFile)) {
                    this.m_taskError = new TaskError("Temp File Renaming Failure", "File " + tmpFile.getAbsolutePath() + " could not be renamed.");
                    String log2 = "File " + tmpFile.getAbsolutePath() + " could not be renamed.";
                    this.logger.debug(log2);
                    return false;
                }
            } else {
                mzdbFile.renameTo(mzdbFile);
            }
            if (this.m_callback instanceof ConvertRawFile2MzdbCallback) {
                ((ConvertRawFile2MzdbCallback)this.m_callback).setMzdbFile(mzdbFile);
                ((ConvertRawFile2MzdbCallback)this.m_callback).setRawFile(this.getFile());
            }
        } else {
            this.m_taskError = new TaskError("Converter Failure", this.getFile().getAbsolutePath() + " conversion: Non-zero exit value.");
            String log = "File converter for file " + this.getFile().getAbsolutePath() + " is not responding.";
            this.logger.info(log);
            if (this.m_callback instanceof ConvertRawFile2MzdbCallback) {
                ((ConvertRawFile2MzdbCallback)this.m_callback).setMzdbFile(null);
                ((ConvertRawFile2MzdbCallback)this.m_callback).setRawFile(this.getFile());
            }
            return false;
        }
        String log = "Converting for file: " + this.getFile().getAbsolutePath() + " has come to its end.";
        this.logger.info(log);
        return true;
    }

    private boolean convertFile() {
        try {
            String errorLine;
            String line;
            ArrayList<String> command;
            this.logger.info("Convert File ");
            String architecture = ConvertRawFile2MzdbTask.getSystemArchitecture();
            if (architecture.contains("64")) {
                command = new ArrayList<String>();
                this.logger.info("add " + ConverterManager.getConverterExeFile().getAbsolutePath());
                command.add(ConverterManager.getConverterExeFile().getAbsolutePath());
                if (StringUtils.isNotEmpty((CharSequence)ConverterManager.getConverterOption())) {
                    String options = ConverterManager.getConverterOption();
                    String[] eachOptions = options.split(" ");
                    for (int i = 0; i < eachOptions.length; ++i) {
                        if (eachOptions[i].trim().isEmpty()) continue;
                        command.add(eachOptions[i].trim());
                    }
                }
            } else {
                this.m_taskError = new TaskError("This installation package is not supported by this processor type. Contact your administrator.");
                this.logger.warn("This installation package is not supported by this processor type. Contact your administrator.");
                return false;
            }
            command.add("-n");
            command.add("-i");
            command.add(this.getFile().getAbsolutePath());
            command.add("-o");
            command.add(this.m_outputTempFilePath);
            this.m_conversionProcess = new ProcessBuilder(new String[0]).command(command).start();
            this.logger.info("------------------------------------------------------------------------");
            this.logger.info("CONVERSION");
            this.logger.info("------------------------------------------------------------------------");
            this.logger.info("");
            String log = "Converter: " + ConverterManager.getConverterExeFile().getAbsolutePath();
            this.logger.info(log);
            InputStream standardOutputStream = this.m_conversionProcess.getInputStream();
            BufferedReader standardReader = new BufferedReader(new InputStreamReader(standardOutputStream));
            while ((line = standardReader.readLine()) != null) {
                this.logger.info(line);
            }
            InputStream errorStream = this.m_conversionProcess.getErrorStream();
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
            while ((errorLine = errorReader.readLine()) != null) {
                this.logger.info("Warning:");
                this.logger.info(errorLine);
            }
        }
        catch (IOException ex) {
            this.m_taskError = new TaskError("Converter faced an IOException during conversion of " + this.getFile().getAbsolutePath() + ". Check input file's integrity.");
            this.logger.error("File convertion failed!");
            return false;
        }
        return true;
    }

    private static String getSystemArchitecture() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        System.out.println("RealArch:" + realArch);
        return realArch;
    }
}

