/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.swingx.JXComboBox;

public class SmoothingParamDialog
extends DefaultDialog {
    JTextField m_nbrPoint;
    JLabel nbrPointLabel;
    JSpinner sp;
    JComboBox m_smoothingMethods;
    JLabel ratioLabel;
    JCheckBox checkBox;
    JLabel convolutionModeJLabel;
    JComboBox modeOfConvolution;
    JComboBox comboBox;
    JPanel savitskyParamsPanel;
    JTextField polyOrderTField;
    JTextField derivativeJTField;
    JTextField deltaJTField;
    public static final String PARTIAL_SG_SMOOTHER = "Partial Savitzky-Golay Smoother";
    public static final String SG_SMOOTHER = "Savitzky-Golay Smoother";
    public static final String BOTH_SMOOTHER = "All Smoothers";
    public static final String SMOOTHING_JDSP = "SmoothingJDSP";
    public static final String CONVOLUTION_METHOD = "ConvolutionJDSP";
    public static final String GAUSSIAN_FITTING_METHOD = "Apache gaussian fitting";
    public static final String WIENER_METHOD = "WienerJDSP";
    public static final String SVGOLAY_JDSP = "SavitskyJDSP";
    public static final String EXPERIMENTAL_TEST = "Experimental method";
    public static final String MEDIAN_FILTER_METHOD = "medianFilterJDSP";
    public static final String SIGNAL_QUALITY_EVALUATION = "signal quality evaluation";
    String[] methods = new String[]{"Partial Savitzky-Golay Smoother", "Savitzky-Golay Smoother", "All Smoothers", "SmoothingJDSP", "ConvolutionJDSP", "Apache gaussian fitting", "WienerJDSP", "SavitskyJDSP", "Experimental method", "medianFilterJDSP", "signal quality evaluation"};
    String[] convolutionMode = new String[]{"rectangular", "triangular"};
    private boolean showSavitskyParam = false;

    public SmoothingParamDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Smoothing parameters ");
        this.setInternalComponent(this.createInternalPanel());
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.nbrPointLabel = new JLabel("Number of points ");
        internalPanel.add((Component)this.nbrPointLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_nbrPoint = new JTextField(10);
        this.m_nbrPoint.setText("5");
        this.m_nbrPoint.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                    SmoothingParamDialog.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        internalPanel.add((Component)this.m_nbrPoint, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel methodsLabel = new JLabel("Smoothing method ");
        internalPanel.add((Component)methodsLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_smoothingMethods = new JXComboBox((Object[])this.methods);
        this.m_smoothingMethods.setSelectedItem(SVGOLAY_JDSP);
        this.m_smoothingMethods.addActionListener(e -> {
            String selectedMethod = Objects.requireNonNull(this.m_smoothingMethods.getSelectedItem()).toString();
            if (selectedMethod.equals(SIGNAL_QUALITY_EVALUATION)) {
                this.m_nbrPoint.setVisible(true);
                this.m_nbrPoint.setEnabled(true);
                this.nbrPointLabel.setText("Size of kernel");
                this.nbrPointLabel.setToolTipText("Choose the size of kernel to smooth the signal");
                this.checkBox.setVisible(false);
                this.sp.setVisible(false);
                this.ratioLabel.setVisible(false);
                this.convolutionModeJLabel.setVisible(false);
                this.modeOfConvolution.setVisible(false);
                this.savitskyParamsPanel.setVisible(false);
            } else if (selectedMethod.equals(GAUSSIAN_FITTING_METHOD)) {
                this.nbrPointLabel.setVisible(true);
                this.m_nbrPoint.setVisible(true);
                this.m_nbrPoint.setEnabled(false);
                this.checkBox.setText("improve fitting");
                this.checkBox.setSelected(false);
                this.checkBox.setVisible(true);
                this.sp.setVisible(false);
                this.sp.setEnabled(false);
                this.ratioLabel.setVisible(false);
                this.convolutionModeJLabel.setVisible(false);
                this.modeOfConvolution.setVisible(false);
                this.savitskyParamsPanel.setVisible(false);
            } else if (selectedMethod.equals(SMOOTHING_JDSP)) {
                this.nbrPointLabel.setText("Size of kernel");
                this.m_nbrPoint.setEnabled(true);
                this.m_nbrPoint.setVisible(true);
                this.checkBox.setText("Compute optimal kernel size");
                this.checkBox.setToolTipText("if selected calculate an other kernel that fits better the signal");
                this.sp.setVisible(false);
                this.ratioLabel.setVisible(false);
                this.convolutionModeJLabel.setVisible(true);
                this.modeOfConvolution.setVisible(true);
                this.savitskyParamsPanel.setVisible(false);
            } else if (selectedMethod.equals(WIENER_METHOD)) {
                this.nbrPointLabel.setVisible(true);
                this.m_nbrPoint.setVisible(true);
                this.m_nbrPoint.setEnabled(true);
                this.nbrPointLabel.setText("Filter window size");
                this.ratioLabel.setVisible(true);
                this.sp.setVisible(true);
                this.convolutionModeJLabel.setVisible(false);
                this.modeOfConvolution.setVisible(false);
                this.savitskyParamsPanel.setVisible(false);
            } else if (selectedMethod.equals(EXPERIMENTAL_TEST)) {
                this.nbrPointLabel.setVisible(true);
                this.nbrPointLabel.setText("non defined entry");
                this.m_nbrPoint.setVisible(true);
                this.m_nbrPoint.setEnabled(true);
                this.checkBox.setText("non defined");
                this.checkBox.setVisible(true);
                this.ratioLabel.setVisible(true);
                this.sp.setVisible(true);
                this.convolutionModeJLabel.setVisible(false);
                this.modeOfConvolution.setVisible(false);
                this.savitskyParamsPanel.setVisible(false);
            } else {
                if (selectedMethod.equals(SVGOLAY_JDSP)) {
                    this.savitskyParamsPanel.setVisible(true);
                } else {
                    this.savitskyParamsPanel.setVisible(false);
                }
                this.nbrPointLabel.setVisible(true);
                this.nbrPointLabel.setText("Window size");
                this.m_nbrPoint.setVisible(true);
                this.m_nbrPoint.setEnabled(true);
                this.checkBox.setText("Use peak restore");
                this.checkBox.setToolTipText("If selected will restore peaks");
                this.checkBox.setVisible(true);
                this.ratioLabel.setVisible(true);
                this.convolutionModeJLabel.setVisible(false);
                this.modeOfConvolution.setVisible(false);
                this.sp.setVisible(true);
            }
        });
        internalPanel.add((Component)this.m_smoothingMethods, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel peakRestoreLabel = new JLabel();
        internalPanel.add((Component)peakRestoreLabel, c);
        this.checkBox = new JCheckBox("Use peak restore: ");
        this.checkBox.setHorizontalTextPosition(2);
        this.checkBox.setSelected(false);
        this.checkBox.addActionListener(e -> {
            boolean isSelected = this.checkBox.isSelected();
            this.sp.setEnabled(isSelected);
            if (this.m_smoothingMethods.getSelectedItem().equals(SMOOTHING_JDSP)) {
                if (isSelected) {
                    this.sp.setEnabled(false);
                    this.m_nbrPoint.setEnabled(false);
                } else {
                    this.nbrPointLabel.setVisible(true);
                    this.m_nbrPoint.setVisible(true);
                    this.m_nbrPoint.setEnabled(true);
                }
            }
        });
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 10;
        internalPanel.add((Component)this.checkBox, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.ratioLabel = new JLabel("Peak ratio");
        this.ratioLabel.setToolTipText("a ratio of zero will restore all peaks, a ratio of 1 will restore only the peak withmax value");
        c.gridx = 0;
        ++c.gridy;
        internalPanel.add((Component)this.ratioLabel, c);
        SpinnerNumberModel model = new SpinnerNumberModel(0.1, 0.0, 1.0, 0.05);
        this.sp = new JSpinner(model);
        this.sp.setEnabled(false);
        ++c.gridx;
        c.fill = 2;
        internalPanel.add((Component)this.sp, c);
        c.gridx = 0;
        ++c.gridy;
        this.convolutionModeJLabel = new JLabel("Mode of convolution");
        this.convolutionModeJLabel.setVisible(false);
        c.fill = 0;
        internalPanel.add((Component)this.convolutionModeJLabel, c);
        ++c.gridx;
        this.modeOfConvolution = new JComboBox<String>(this.convolutionMode);
        this.modeOfConvolution.setVisible(false);
        this.modeOfConvolution.setSelectedItem(this.convolutionMode[1]);
        internalPanel.add((Component)this.modeOfConvolution, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 3;
        c.fill = 1;
        this.savitskyParamsPanel = this.createSavitskyJPanel();
        internalPanel.add((Component)this.savitskyParamsPanel, c);
        internalPanel.setPreferredSize(new Dimension(300, 270));
        return internalPanel;
    }

    private JPanel createSavitskyJPanel() {
        JPanel savistkyPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        savistkyPanel.setBorder(BorderFactory.createTitledBorder("Savitsky smoothing"));
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        String[] modes = new String[]{"wrap", "nearest", "constant", "mirror"};
        this.comboBox = new JComboBox<String>(modes);
        this.comboBox.setSelectedItem("nearest");
        savistkyPanel.add((Component)this.comboBox, gbc);
        JLabel polyOrderLabel = new JLabel("poly order: ");
        ++gbc.gridx;
        gbc.anchor = 13;
        savistkyPanel.add(polyOrderLabel);
        this.polyOrderTField = new JTextField(8);
        this.polyOrderTField.setText(String.valueOf(3));
        ++gbc.gridx;
        savistkyPanel.add((Component)this.polyOrderTField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel derivJLabel = new JLabel("derivative order: ");
        gbc.anchor = 17;
        savistkyPanel.add((Component)derivJLabel, gbc);
        this.derivativeJTField = new JTextField(8);
        this.derivativeJTField.setText(String.valueOf(0));
        ++gbc.gridx;
        gbc.anchor = 13;
        savistkyPanel.add((Component)this.derivativeJTField, gbc);
        JLabel deltaSpacing = new JLabel("delta spacing :");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 17;
        savistkyPanel.add((Component)deltaSpacing, gbc);
        this.deltaJTField = new JTextField(8);
        this.deltaJTField.setText(String.valueOf(5));
        ++gbc.gridx;
        gbc.anchor = 13;
        savistkyPanel.add((Component)this.deltaJTField, gbc);
        savistkyPanel.setVisible(true);
        return savistkyPanel;
    }

    public int getNbrPoint() {
        return Integer.parseInt(this.m_nbrPoint.getText());
    }

    public String getMethod() {
        return this.m_smoothingMethods.getSelectedItem().toString();
    }

    public String getModeOfConvolution() {
        return this.modeOfConvolution.getSelectedItem().toString();
    }

    public boolean getUsePeakrestore() {
        return this.checkBox.isSelected();
    }

    public double getJSpinnerValue() {
        return (Double)this.sp.getValue();
    }

    public String getSavitskyMode() {
        return this.comboBox.getSelectedItem().toString();
    }

    public int getPolyOrder() {
        return Integer.parseInt(this.polyOrderTField.getText());
    }

    public int getDerivativeOrder() {
        return Integer.parseInt(this.derivativeJTField.getText());
    }

    public int getDeltaSpacing() {
        return Integer.parseInt(this.deltaJTField.getText());
    }
}

