/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.proline.mzscope.model.IPeakel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.table.AbstractNonLazyTableModel;
import fr.proline.studio.table.Column;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PeakelsTableModel
extends AbstractNonLazyTableModel
implements GlobalTableModelInterface {
    private static TableCellRenderer BIG_FLOAT = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
    public static final Column COLTYPE_FEATURE_MZCOL = new Column("m/z", "m/z", Double.class, 0, Column.DOUBLE_5DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_ET_COL = new Column("Elution", "Elution Time in minutes", Float.class, 1, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_DURATION_COL = new Column("Duration", "Duration in minutes", Float.class, 2, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_APEX_INT_COL = new Column("Apex Int.", "Apex intensity", Float.class, 3, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_AREA_COL = new Column("Area", "Area", Double.class, 4, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_SCAN_COUNT_COL = new Column("MS Count", "MS Count", Integer.class, 5);
    public static final Column COLTYPE_FEATURE_RAWFILE = new Column("Raw file", "Raw File Name", String.class, 6, Column.STRING_LEFT);
    public static final Column COLTYPE_FEATURE_MZ_STDEV = new Column("mz Stdev", "m/z standard deviation", Double.class, 7, Column.DOUBLE_5DIGITS_RIGHT);
    protected List<IPeakel> m_peakels = new ArrayList<IPeakel>();
    protected Map<Integer, Double> m_statistics = new HashMap<Integer, Double>();

    public int[] getKeysColumn() {
        int[] keys = new int[]{COLTYPE_FEATURE_MZCOL.getIndex(), COLTYPE_FEATURE_ET_COL.getIndex(), COLTYPE_FEATURE_RAWFILE.getIndex()};
        return keys;
    }

    public int getInfoColumn() {
        return COLTYPE_FEATURE_MZCOL.getIndex();
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public int getRowCount() {
        return this.m_peakels.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == COLTYPE_FEATURE_MZCOL.getIndex()) {
            return this.m_peakels.get(rowIndex).getMz();
        }
        if (columnIndex == COLTYPE_FEATURE_ET_COL.getIndex()) {
            return (double)this.m_peakels.get(rowIndex).getElutionTime() / 60.0;
        }
        if (columnIndex == COLTYPE_FEATURE_DURATION_COL.getIndex()) {
            return (double)this.m_peakels.get(rowIndex).getDuration() / 60.0;
        }
        if (columnIndex == COLTYPE_FEATURE_APEX_INT_COL.getIndex()) {
            return Float.valueOf(this.m_peakels.get(rowIndex).getApexIntensity());
        }
        if (columnIndex == COLTYPE_FEATURE_AREA_COL.getIndex()) {
            return (double)this.m_peakels.get(rowIndex).getArea() / 60.0;
        }
        if (columnIndex == COLTYPE_FEATURE_SCAN_COUNT_COL.getIndex()) {
            return this.m_peakels.get(rowIndex).getScanCount();
        }
        if (columnIndex == COLTYPE_FEATURE_RAWFILE.getIndex()) {
            return this.m_peakels.get(rowIndex).getRawFile().getName();
        }
        if (columnIndex == COLTYPE_FEATURE_MZ_STDEV.getIndex()) {
            return this.m_statistics.get(rowIndex);
        }
        return null;
    }

    private Double getMzStats(int row, IPeakel iPeakel) {
        if (!this.m_statistics.containsKey(row)) {
            if (iPeakel.getPeakel() != null) {
                double[] mzValues = iPeakel.getPeakel().mzValues();
                double standardDeviation = new DescriptiveStatistics(mzValues).getStandardDeviation();
                this.m_statistics.put(row, 1000000.0 * standardDeviation / iPeakel.getMz());
            } else {
                return 0.0;
            }
        }
        return this.m_statistics.get(row);
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (IPeakel.class.isAssignableFrom(c)) {
            return this.m_peakels.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void setPeakels(List<IPeakel> peakels) {
        this.m_statistics.clear();
        this.m_peakels.clear();
        this.m_peakels.addAll(peakels);
        int row = 0;
        for (IPeakel p : this.m_peakels) {
            this.getMzStats(row++, p);
        }
        this.fireTableDataChanged();
    }

    public void addPeakels(List<IPeakel> features) {
        int row = this.m_peakels.size() - 1;
        this.m_peakels.addAll(features);
        for (IPeakel p : features) {
            this.getMzStats(row++, p);
        }
        this.fireTableDataChanged();
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return 0;
    }
}

