/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.dragdrop;

import fr.proline.studio.dock.dragdrop.DockTransferable;
import fr.proline.studio.dock.dragdrop.OverArea;
import fr.proline.studio.dock.gui.DraggingOverlayPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class DockingImportTransfertHandler
extends TransferHandler {
    private DraggingOverlayPanel m_overlayPanel;

    public DockingImportTransfertHandler(DraggingOverlayPanel overlayPanel) {
        this.m_overlayPanel = overlayPanel;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        Point point = info.getDropLocation().getDropPoint();
        Component source = info.getComponent();
        if (point == null) {
            return false;
        }
        SwingUtilities.convertPointToScreen(point, source);
        OverArea overArea = this.m_overlayPanel.getOverArea(point);
        if (overArea == null) {
            return false;
        }
        Transferable transferable = info.getTransferable();
        DockTransferable data = null;
        try {
            data = (DockTransferable)transferable.getTransferData(DockTransferable.FLAVOR);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        if (data == null) {
            return false;
        }
        String zoneAreaSource = data.getDockComponent().getZoneArea();
        String zoneAreaDestination = overArea.getDockContainerTab().getZoneArea();
        if (!(zoneAreaDestination == null || zoneAreaSource != null && zoneAreaSource.equals(zoneAreaDestination))) {
            this.m_overlayPanel.resetOverArea();
            return false;
        }
        return info.isDataFlavorSupported(DockTransferable.FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        Transferable transferable = info.getTransferable();
        DockTransferable data = null;
        try {
            data = (DockTransferable)transferable.getTransferData(DockTransferable.FLAVOR);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        if (data == null) {
            return false;
        }
        this.m_overlayPanel.importData(data);
        return true;
    }
}

