/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.StringFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringDiffFilter
extends StringFilter {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");

    public StringDiffFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_optionList = new String[3];
        this.m_optionList[0] = "=";
        this.m_optionList[1] = "!=";
        this.m_optionList[2] = "IN";
    }

    @Override
    public Filter cloneFilter4Search() {
        StringDiffFilter clone = new StringDiffFilter(this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_optionList = new String[2];
        clone.m_optionList[0] = "=";
        clone.m_optionList[1] = "!=";
        clone.reset();
        this.setValuesForClone(clone);
        clone.m_filterText = this.m_filterText;
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        String value = (String)v1;
        boolean found = false;
        switch (this.m_selectItem) {
            case "=": {
                if (this.m_filterText.length() == 0) {
                    return true;
                }
                Matcher matcher = this.m_searchPattern.matcher(value);
                found = matcher.matches();
                return found;
            }
            case "!=": {
                if (this.m_filterText.length() == 0) {
                    return true;
                }
                Matcher matcher = this.m_searchPattern.matcher(value);
                found = matcher.matches();
                return !found;
            }
            case "IN": {
                if (this.m_filterAreaText.length() == 0) {
                    return true;
                }
                found = false;
                for (Pattern rx : this.m_searchPatternList) {
                    if (!rx.matcher(value).matches()) continue;
                    return true;
                }
                return false;
            }
        }
        return found;
    }
}

