/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ValueListAssociatedStringFilter
extends Filter {
    private static final String TEXTFIELD_EXAMPLE = "<Specify Residues list like ST>";
    private Object[] m_values = null;
    private boolean[] m_selected = null;
    private String[] m_onTextValues = null;
    private JCheckBox[] m_checkBoxArray = null;
    private JTextField[] m_textFieldArray = null;

    public ValueListAssociatedStringFilter(String variableName, Object[] values, ConvertValueInterface convertValueInterface, int modelColumn1, int modelColumn2) {
        super(variableName, convertValueInterface, modelColumn1, modelColumn2);
        int i;
        this.m_values = values;
        this.m_selected = new boolean[this.m_values.length];
        for (i = 0; i < this.m_selected.length; ++i) {
            this.m_selected[i] = false;
        }
        this.m_onTextValues = new String[this.m_values.length];
        for (i = 0; i < this.m_onTextValues.length; ++i) {
            this.m_onTextValues[i] = "";
        }
    }

    @Override
    public Filter cloneFilter4Search() {
        ValueListAssociatedStringFilter clone = new ValueListAssociatedStringFilter(this.m_variableName, this.m_values, this.m_convertValueInterface, this.m_modelColumn, this.m_extraModelColumn);
        if (this.m_selected != null) {
            int nb = this.m_selected.length;
            clone.m_selected = new boolean[nb];
            clone.m_onTextValues = new String[nb];
            for (int i = 0; i < nb; ++i) {
                clone.m_selected[i] = this.m_selected[i];
                clone.m_onTextValues[i] = this.m_onTextValues[i];
            }
        }
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        int index = (Integer)v1;
        if (!this.m_selected[index]) {
            return false;
        }
        String onText = this.m_onTextValues[index];
        if (onText == null || onText.isEmpty()) {
            return true;
        }
        String value = v2 == null ? null : v2.toString();
        return value == null || value.isEmpty() || onText.contains(value);
    }

    @Override
    public FilterStatus checkValues() {
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            int i;
            int nb = this.m_checkBoxArray.length;
            for (i = 0; i < nb; ++i) {
                boolean s = this.m_checkBoxArray[i].isSelected();
                hasChanged |= s != this.m_selected[i];
                this.m_selected[i] = s;
            }
            for (i = 0; i < nb; ++i) {
                String t = this.m_textFieldArray[i].getText().trim();
                if (t.compareTo(TEXTFIELD_EXAMPLE) == 0) {
                    t = "";
                }
                hasChanged |= t.compareTo(this.m_onTextValues[i]) == 0;
                this.m_onTextValues[i] = t;
            }
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 4;
        c.weightx = 1.0;
        p.add((Component)this.createInternalPanel(), c);
        c.gridx += 4;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        int nb = this.m_values.length;
        if (this.m_checkBoxArray == null) {
            this.m_checkBoxArray = new JCheckBox[nb];
        }
        if (this.m_textFieldArray == null) {
            this.m_textFieldArray = new JTextField[nb];
        }
        FocusListener focusListener = null;
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_checkBoxArray[i] == null) {
                this.m_checkBoxArray[i] = new JCheckBox(this.m_values[i].toString());
            }
            c.gridx = 0;
            c.gridy = i;
            internalPanel.add((Component)this.m_checkBoxArray[i], c);
            if (this.m_textFieldArray[i] == null) {
                if (focusListener == null) {
                    focusListener = new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            JTextField textField = (JTextField)e.getComponent();
                            if (textField.getText().compareTo(ValueListAssociatedStringFilter.TEXTFIELD_EXAMPLE) == 0) {
                                textField.setText("");
                                textField.setForeground(Color.black);
                            }
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                        }
                    };
                }
                this.m_textFieldArray[i] = new JTextField(20);
                this.m_textFieldArray[i].setText(TEXTFIELD_EXAMPLE);
                this.m_textFieldArray[i].setForeground(Color.gray);
                this.m_textFieldArray[i].addFocusListener(focusListener);
                this.m_textFieldArray[i].setToolTipText("<html>Specify accepted residues for " + this.m_values[i].toString() + "<br>For instance : ST for a Phosphorylation</html>");
            }
            ++c.gridx;
            internalPanel.add((Component)new JLabel("on"), c);
            ++c.gridx;
            internalPanel.add((Component)this.m_textFieldArray[i], c);
        }
        return internalPanel;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.m_selected.length; ++i) {
            this.m_selected[i] = false;
            this.m_onTextValues[i] = null;
        }
    }
}

