/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.markerbar;

import fr.proline.studio.WindowManager;
import fr.proline.studio.markerbar.AbstractBar;
import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.AnnotationMarker;
import fr.proline.studio.markerbar.AnnotationMarkerDialog;
import fr.proline.studio.markerbar.BookmarkMarker;
import fr.proline.studio.markerbar.DefaultMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.markerbar.MarkerRendererInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MarkerBar
extends AbstractBar
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int TEXT_PAD = 4;
    private static Font m_lineNumbersFont = null;
    private static FontMetrics m_lineNumbersFontMercrics = null;
    private static int m_fontAscent = 0;
    private static int m_fontDescent = 0;
    private boolean m_displayLineNumbers = true;
    private int m_maxLineNumber = -1;
    private static final Color m_almostWhiteColor = new Color(248, 248, 248);
    JPopupMenu m_popup = null;
    AbstractMarkerBarAction[] actions = null;
    private int rowClicked = -1;
    private int popupX = -1;
    private int popupY = -1;

    public MarkerBar(MarkerContainerPanel containerPanel) {
        super(containerPanel);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean isLineNumbersDisplayed() {
        return this.m_displayLineNumbers;
    }

    public void setLineNumbersDisplayed(boolean displayLineNumbers) {
        this.m_displayLineNumbers = displayLineNumbers;
    }

    public boolean setMaxLineNumber(int maxLineNumber) {
        boolean changed = this.m_maxLineNumber != maxLineNumber;
        this.m_maxLineNumber = maxLineNumber;
        return changed;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (this.m_displayLineNumbers && this.m_maxLineNumber != -1 && m_lineNumbersFont != null) {
            String numberString = String.valueOf(this.m_maxLineNumber);
            dim.width = m_lineNumbersFontMercrics.stringWidth(numberString) + 8;
        }
        return dim;
    }

    @Override
    public Dimension getPreferredSize() {
        String numberString;
        int minWidth;
        Dimension dim = super.getPreferredSize();
        if (this.m_displayLineNumbers && this.m_maxLineNumber != -1 && m_lineNumbersFont != null && dim.width < (minWidth = m_lineNumbersFontMercrics.stringWidth(numberString = String.valueOf(this.m_maxLineNumber)) + 8)) {
            dim.width = minWidth;
        }
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        this.initFontForLineNumbers(g);
        g.setColor(m_almostWhiteColor);
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        MarkerComponentInterface componentInterface = this.m_containerPanel.getMarkerComponentInterface();
        int firstVisibleRow = componentInterface.getFirstVisibleRow();
        int lastVisibleRow = componentInterface.getLastVisibleRow();
        TreeMap<Integer, ArrayList<AbstractMarker>> markerMap = this.m_containerPanel.getMarkerArray();
        for (Integer row : markerMap.keySet()) {
            int rowInt = componentInterface.convertRowIndexNonFilteredModelToView(row);
            if (rowInt < firstVisibleRow || rowInt > lastVisibleRow) continue;
            ArrayList<AbstractMarker> markersArrayList = markerMap.get(row);
            int size = markersArrayList.size();
            for (int i = 0; i < size; ++i) {
                AbstractMarker marker = markersArrayList.get(i);
                int y1 = componentInterface.getRowYStart(rowInt);
                int y2 = componentInterface.getRowYStop(rowInt);
                MarkerRendererInterface renderer = this.m_containerPanel.getRenderer(marker);
                renderer.paint(AbstractBar.BarType.MARKER_BAR, g, 0, y1, this.getWidth(), y2 - y1);
            }
        }
        if (this.m_displayLineNumbers && firstVisibleRow != -1) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(m_lineNumbersFont);
            g.setColor(Color.gray);
            for (int i = firstVisibleRow; i <= lastVisibleRow; ++i) {
                int y1 = componentInterface.getRowYStart(i);
                int y2 = componentInterface.getRowYStop(i);
                String numberString = String.valueOf(i + 1);
                int xText = this.getWidth() - m_lineNumbersFontMercrics.stringWidth(numberString) - 4;
                int yText = y1 + (y2 + 1 - y1) / 2 - (m_fontAscent + m_fontDescent) / 2 + m_fontAscent;
                g.drawString(numberString, xText, yText);
            }
        }
    }

    private void initFontForLineNumbers(Graphics g) {
        if (m_lineNumbersFont == null) {
            m_lineNumbersFont = new Font("SansSerif", 0, 9);
            m_lineNumbersFontMercrics = g.getFontMetrics(m_lineNumbersFont);
            m_fontAscent = m_lineNumbersFontMercrics.getAscent();
            m_fontDescent = m_lineNumbersFontMercrics.getDescent();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MarkerComponentInterface componentInterface = this.m_containerPanel.getMarkerComponentInterface();
        this.rowClicked = componentInterface.getRowInNonFilteredModel(e.getY());
        if (SwingUtilities.isRightMouseButton(e)) {
            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
            this.popupX = e.getX() + p.x;
            this.popupY = e.getY() + p.y;
            this.getPopup(this.rowClicked).show((JComponent)e.getSource(), e.getX(), e.getY());
            return;
        }
        if (this.m_containerPanel.removeAllMarkers(this.rowClicked)) {
            return;
        }
        BookmarkMarker marker = new BookmarkMarker(this.rowClicked);
        this.m_containerPanel.addMarker(marker);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MarkerComponentInterface componentInterface = this.m_containerPanel.getMarkerComponentInterface();
        int row = componentInterface.getRowInNonFilteredModel(e.getY());
        AnnotationMarker marker = (AnnotationMarker)this.m_containerPanel.getMarker(row, DefaultMarker.ANNOTATION_MARKER);
        if (marker == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(marker.getText());
        }
    }

    private JPopupMenu getPopup(int row) {
        if (this.m_popup != null) {
            this.updateActions(row);
            return this.m_popup;
        }
        this.actions = new AbstractMarkerBarAction[7];
        this.actions[0] = new DisplayLineNumbersAction();
        this.actions[1] = null;
        this.actions[2] = new AddAnnotationAction();
        this.actions[3] = new AddBookmarkAction();
        this.actions[4] = new RemoveMarkerAction();
        this.actions[5] = null;
        this.actions[6] = new RemoveAllMarkersAction();
        this.m_popup = new JPopupMenu();
        for (int i = 0; i < this.actions.length; ++i) {
            AbstractMarkerBarAction action = this.actions[i];
            if (action == null) {
                this.m_popup.addSeparator();
                continue;
            }
            this.m_popup.add(action.getPopupPresenter());
        }
        this.updateActions(row);
        return this.m_popup;
    }

    private void updateActions(int row) {
        for (int i = 0; i < this.actions.length; ++i) {
            AbstractMarkerBarAction action = this.actions[i];
            if (action == null) continue;
            action.updateEnabled(row);
        }
    }

    private abstract class AbstractMarkerBarAction
    extends AbstractAction {
        public AbstractMarkerBarAction(String name) {
            super(name);
        }

        public abstract void updateEnabled(int var1);

        public JMenuItem getPopupPresenter() {
            return new JMenuItem(this);
        }
    }

    private class DisplayLineNumbersAction
    extends AbstractMarkerBarAction {
        private JCheckBoxMenuItem m_checkboxMenuItem;

        public DisplayLineNumbersAction() {
            super("Display Line Numbers");
            this.m_checkboxMenuItem = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MarkerBar.this.setLineNumbersDisplayed(!MarkerBar.this.isLineNumbersDisplayed());
            MarkerBar.this.m_containerPanel.revalidate();
            MarkerBar.this.m_containerPanel.repaint();
        }

        @Override
        public void updateEnabled(int row) {
            this.setEnabled(true);
            ((JCheckBoxMenuItem)this.getPopupPresenter()).setSelected(MarkerBar.this.m_displayLineNumbers);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            if (this.m_checkboxMenuItem == null) {
                this.m_checkboxMenuItem = new JCheckBoxMenuItem(this);
            }
            return this.m_checkboxMenuItem;
        }
    }

    private class AddAnnotationAction
    extends AbstractMarkerBarAction {
        public AddAnnotationAction() {
            super("Add Annotation...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnnotationMarkerDialog dialog = AnnotationMarkerDialog.getDialog(WindowManager.getDefault().getMainWindow());
            dialog.setLocation(MarkerBar.this.popupX, MarkerBar.this.popupY);
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                String description = dialog.getDescriptionField();
                AnnotationMarker marker = new AnnotationMarker(MarkerBar.this.rowClicked, description);
                MarkerBar.this.m_containerPanel.addMarker(marker);
            }
        }

        @Override
        public void updateEnabled(int row) {
            this.setEnabled(!MarkerBar.this.m_containerPanel.hasMarker(row));
        }
    }

    private class AddBookmarkAction
    extends AbstractMarkerBarAction {
        public AddBookmarkAction() {
            super("Add Bookmark");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkMarker marker = new BookmarkMarker(MarkerBar.this.rowClicked);
            MarkerBar.this.m_containerPanel.addMarker(marker);
        }

        @Override
        public void updateEnabled(int row) {
            this.setEnabled(!MarkerBar.this.m_containerPanel.hasMarker(row));
        }
    }

    private class RemoveMarkerAction
    extends AbstractMarkerBarAction {
        public RemoveMarkerAction() {
            super("Remove");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkMarker marker = new BookmarkMarker(MarkerBar.this.rowClicked);
            MarkerBar.this.m_containerPanel.removeAllMarkers(MarkerBar.this.rowClicked);
        }

        @Override
        public void updateEnabled(int row) {
            this.setEnabled(MarkerBar.this.m_containerPanel.hasMarker(row));
        }
    }

    private class RemoveAllMarkersAction
    extends AbstractMarkerBarAction {
        public RemoveAllMarkersAction() {
            super("Remove All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MarkerBar.this.m_containerPanel.removeAllMarkers();
        }

        @Override
        public void updateEnabled(int row) {
            this.setEnabled(MarkerBar.this.m_containerPanel.hasMarkers());
        }
    }
}

