/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.markerbar;

import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.AnnotationMarker;
import fr.proline.studio.markerbar.AnnotationMarkerRenderer;
import fr.proline.studio.markerbar.BookmarkMarker;
import fr.proline.studio.markerbar.BookmarkMarkerRenderer;
import fr.proline.studio.markerbar.DefaultMarkerRenderer;
import fr.proline.studio.markerbar.MarkerBar;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerRendererInterface;
import fr.proline.studio.markerbar.OverviewBar;
import fr.proline.studio.markerbar.ViewChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MarkerContainerPanel
extends JPanel
implements ViewChangeListener,
TableModelListener {
    private TreeMap<Integer, ArrayList<AbstractMarker>> m_markers = new TreeMap();
    private HashMap<Class, MarkerRendererInterface> m_renderers = new HashMap();
    private static final long serialVersionUID = 1L;
    private MarkerComponentInterface m_markerComponent = null;
    private static DefaultMarkerRenderer m_defaultRenderer = null;
    private OverviewBar m_overviewBar = null;
    private MarkerBar m_markerBar = null;

    public MarkerContainerPanel(JScrollPane sp, MarkerComponentInterface markerComponent) {
        this.m_markerComponent = markerComponent;
        this.m_markerBar = new MarkerBar(this);
        this.m_overviewBar = new OverviewBar(this);
        markerComponent.addViewChangeListerner(this);
        markerComponent.addTableModelListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.m_markerBar, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)sp, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.m_overviewBar, c);
        sp.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                MarkerContainerPanel.this.m_markerBar.repaint();
            }
        });
        sp.getViewport().setBackground(Color.white);
        sp.setBackground(Color.white);
        this.initDefaultRenderers();
    }

    private void initDefaultRenderers() {
        this.addRenderer(BookmarkMarker.class, new BookmarkMarkerRenderer());
        this.addRenderer(AnnotationMarker.class, new AnnotationMarkerRenderer());
    }

    public void addRenderer(Class c, MarkerRendererInterface renderer) {
        this.m_renderers.put(c, renderer);
    }

    public MarkerRendererInterface getRenderer(AbstractMarker marker) {
        MarkerRendererInterface renderer = this.m_renderers.get(marker.getClass());
        if (renderer == null) {
            if (m_defaultRenderer == null) {
                m_defaultRenderer = new DefaultMarkerRenderer(Color.red);
            }
            renderer = m_defaultRenderer;
        }
        return renderer;
    }

    public MarkerComponentInterface getMarkerComponentInterface() {
        return this.m_markerComponent;
    }

    public TreeMap<Integer, ArrayList<AbstractMarker>> getMarkerArray() {
        return this.m_markers;
    }

    public void addMarker(AbstractMarker marker) {
        Integer rowKey = marker.getRow();
        ArrayList<AbstractMarker> markersInRow = this.m_markers.get(rowKey);
        if (markersInRow == null) {
            markersInRow = new ArrayList(1);
            this.m_markers.put(rowKey, markersInRow);
        }
        markersInRow.add(marker);
        this.repaintBars();
    }

    public AbstractMarker getMarker(int row, int type) {
        ArrayList<AbstractMarker> markersInRow = this.m_markers.get(row);
        if (markersInRow == null) {
            return null;
        }
        int size = markersInRow.size();
        for (int i = 0; i < size; ++i) {
            AbstractMarker marker = markersInRow.get(i);
            if (marker.getType() != type) continue;
            return marker;
        }
        return null;
    }

    public boolean removeMarker(int row, int type) {
        ArrayList<AbstractMarker> markersInRow = this.m_markers.get(row);
        if (markersInRow == null) {
            return false;
        }
        int size = markersInRow.size();
        for (int i = 0; i < size; ++i) {
            AbstractMarker marker = markersInRow.get(i);
            if (marker.getType() != type) continue;
            markersInRow.remove(i);
            this.repaintBars();
            if (markersInRow.isEmpty()) {
                this.m_markers.remove(row);
            }
            return true;
        }
        return false;
    }

    public boolean removeAllMarkers(int row) {
        ArrayList<AbstractMarker> markersInRow = this.m_markers.get(row);
        if (markersInRow == null) {
            return false;
        }
        this.m_markers.remove(row);
        this.repaintBars();
        return true;
    }

    public boolean removeAllMarkers() {
        if (this.m_markers.isEmpty()) {
            return false;
        }
        this.m_markers.clear();
        this.repaintBars();
        return true;
    }

    public boolean hasMarker(int row) {
        ArrayList<AbstractMarker> markersInRow = this.m_markers.get(row);
        return markersInRow != null;
    }

    public boolean hasMarkers() {
        return !this.m_markers.isEmpty();
    }

    public int findNearestRowWithMarker(int rowInView) {
        int minDistance = Integer.MAX_VALUE;
        Integer nearestRowKey = null;
        for (Integer rowKey : this.m_markers.keySet()) {
            int row = this.m_markerComponent.convertRowIndexNonFilteredModelToView(rowKey);
            int distance = Math.abs(rowInView - row);
            if (distance >= minDistance) continue;
            minDistance = distance;
            nearestRowKey = rowKey;
        }
        if (nearestRowKey == null) {
            return rowInView;
        }
        return this.m_markerComponent.convertRowIndexNonFilteredModelToView(nearestRowKey);
    }

    private void repaintBars() {
        if (this.m_overviewBar != null) {
            this.m_overviewBar.repaint();
        }
        if (this.m_markerBar != null) {
            this.m_markerBar.repaint();
        }
    }

    @Override
    public void viewChanged() {
        this.repaintBars();
    }

    public void setMaxLineNumber(int maxLineNumber) {
        if (this.m_markerBar != null && this.m_markerBar.setMaxLineNumber(maxLineNumber) && this.m_markerBar.isLineNumbersDisplayed()) {
            this.m_markerComponent.calculateVisibleRange();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.viewChanged();
    }
}

