/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JTabbedPane;

public class DefaultParameterDialog
extends DefaultDialog {
    private ArrayList<ParameterList> m_parameterListArray = null;
    private JTabbedPane m_tabbedPane = null;

    public DefaultParameterDialog(Window parent, String titleName, ArrayList<ParameterList> parameterListArray) {
        super(parent);
        this.setTitle(titleName);
        this.m_parameterListArray = parameterListArray;
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        if (this.m_parameterListArray.isEmpty()) {
            return;
        }
        if (this.m_parameterListArray.size() == 1) {
            ParameterList.ParametersPanel p = this.m_parameterListArray.get(0).getPanel();
            this.setInternalComponent(p);
        } else {
            this.m_tabbedPane = new JTabbedPane();
            for (int i = 0; i < this.m_parameterListArray.size(); ++i) {
                ParameterList parameter = this.m_parameterListArray.get(i);
                this.m_tabbedPane.addTab(parameter.toString(), null, parameter.getPanel(), null);
            }
            this.setInternalComponent(this.m_tabbedPane);
        }
    }

    @Override
    protected boolean okCalled() {
        ParameterError error = null;
        int indexError = 0;
        for (int i = 0; i < this.m_parameterListArray.size(); ++i) {
            ParameterList parameter = this.m_parameterListArray.get(i);
            error = parameter.checkParameters();
            if (error == null) continue;
            indexError = i;
            break;
        }
        if (error != null) {
            if (this.m_tabbedPane != null) {
                this.m_tabbedPane.setSelectedIndex(indexError);
            }
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    @Override
    protected boolean cancelCalled() {
        return true;
    }
}

