/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class DataFormat {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.##");
    private static final DecimalFormat SCIENTIFIC_FORMAT = new DecimalFormat("#.##E0");

    public static String format(Float f, int nbFractionDigits) {
        if (f == null) {
            return null;
        }
        return DataFormat.format(f.floatValue(), nbFractionDigits);
    }

    public static String format(float f, int nbFractionDigits) {
        DECIMAL_FORMAT.setMaximumFractionDigits(nbFractionDigits);
        DECIMAL_FORMAT.setMinimumFractionDigits(nbFractionDigits);
        return DECIMAL_FORMAT.format(f);
    }

    public static String format(Double d, int nbFractionDigits) {
        if (d == null) {
            return null;
        }
        return DataFormat.format((double)d, nbFractionDigits);
    }

    public static String format(double d, int nbFractionDigits) {
        DECIMAL_FORMAT.setMaximumFractionDigits(nbFractionDigits);
        DECIMAL_FORMAT.setMinimumFractionDigits(nbFractionDigits);
        return DECIMAL_FORMAT.format(d);
    }

    public static String formatScientific(Float f, int nbFractionDigits) {
        if (f == null) {
            return null;
        }
        return DataFormat.formatScientific(f.floatValue(), nbFractionDigits);
    }

    public static String formatScientific(float f, int nbFractionDigits) {
        SCIENTIFIC_FORMAT.setMaximumFractionDigits(nbFractionDigits);
        SCIENTIFIC_FORMAT.setMinimumFractionDigits(nbFractionDigits);
        return SCIENTIFIC_FORMAT.format(f);
    }

    public static String formatScientific(Double d, int nbFractionDigits) {
        if (d == null) {
            return null;
        }
        return DataFormat.formatScientific((double)d, nbFractionDigits);
    }

    public static String formatScientific(double d, int nbFractionDigits) {
        SCIENTIFIC_FORMAT.setMaximumFractionDigits(nbFractionDigits);
        SCIENTIFIC_FORMAT.setMinimumFractionDigits(nbFractionDigits);
        return SCIENTIFIC_FORMAT.format(d);
    }

    public static String format(Integer i) {
        if (i == null) {
            return null;
        }
        return String.valueOf(i);
    }

    public static String format(int i) {
        return String.valueOf(i);
    }

    public static String formatWithGroupingSep(Number f, int nbFractionDigits) {
        if (f == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("###,###.##");
        DecimalFormatSymbols dfs = decimalFormat.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setGroupingSeparator(' ');
        decimalFormat.setDecimalFormatSymbols(dfs);
        decimalFormat.setMaximumFractionDigits(nbFractionDigits);
        decimalFormat.setMinimumFractionDigits(nbFractionDigits);
        return decimalFormat.format(f.doubleValue());
    }

    static {
        DecimalFormatSymbols dfs = DECIMAL_FORMAT.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DECIMAL_FORMAT.setDecimalFormatSymbols(dfs);
        dfs = SCIENTIFIC_FORMAT.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        SCIENTIFIC_FORMAT.setDecimalFormatSymbols(dfs);
    }
}

