/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.cli;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.MzDbFeatureExtractor;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig$;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder$;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletDetectorDuMethod;
import fr.profi.mzdb.cli.Commands;
import fr.profi.mzdb.cli.Commands$DetectedPeak$2$;
import fr.profi.mzdb.cli.MzDbProcessing$CreateMgfCommand$;
import fr.profi.mzdb.io.exporter.SQLiteFeatureStorer$;
import fr.profi.mzdb.io.reader.provider.RunSliceDataProvider;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.DefaultSpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.ISpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.IsolationWindowPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.MgfBoostPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.MgfBoostPrecursorExtractor$;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.io.writer.mgf.ScanSelectorModes$;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Feature$;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelBuilder;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.util.stat.Bin;
import fr.profi.util.stat.package;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import mr.go.sgfilter.SGFilterMath3;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class Commands$
implements LazyLogging {
    public static Commands$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Commands$();
    }

    private Logger logger$lzycompute() {
        Commands$ commands$ = this;
        synchronized (commands$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void generateXICs(String mzdbListFilePath, String pepListFilePath, String outputFilePath, float mzTolInPPM, String algo) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        LazyRef DetectedPeak$module = new LazyRef();
        Tuple3[] mzList = Commands$.getPeptideList$1(new File(pepListFilePath));
        PrintWriter writer = new PrintWriter(new FileOutputStream(outputFilePath));
        writer.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file name", "input m/z", "exp m/z", "time", "duration", "area", "fwhm", "intensity", "ms1_intensity"})).mkString("\t"));
        writer.flush();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting the extraction of XICs...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String[][] xics = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getMzdbList$1(mzdbListFilePath))).map((Function1 & Serializable & scala.Serializable)x$8 -> this.extractXICsForOneFile$1((String)x$8, mzList, mzTolInPPM, algo, DetectedPeak$module), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xics)).flatMap((Function1 & Serializable & scala.Serializable)x -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            writer.println(x$9);
            return BoxedUnit.UNIT;
        });
        writer.close();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Extraction of XICs finished !");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void extractFeatures(String mzdbFilePath, String putativeFtsFile, String outputFile) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        MzDbReader mzDb = new MzDbReader(new File(mzdbFilePath), true);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Hello Predicted Time Extractor");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        PutativeFeature[] pfs = Commands$.getPutativeFeatures$1(putativeFtsFile);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Read #{} putative features...", new Object[]{BoxesRunTime.boxToInteger((int)pfs.length)});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        java.util.Iterator rsIter = mzDb.getLcMsRunSliceIterator();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("got RS iterator");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        RunSliceDataProvider rsdProv = new RunSliceDataProvider(rsIter);
        int mzTolPPM = 10;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Extraction...");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        float x$1 = 10.0f;
        Some x$2 = new Some((Object)BoxesRunTime.boxToFloat((float)40.0f));
        int x$3 = FeatureExtractorConfig$.MODULE$.apply$default$2();
        int x$4 = FeatureExtractorConfig$.MODULE$.apply$default$3();
        int x$5 = FeatureExtractorConfig$.MODULE$.apply$default$4();
        float x$6 = FeatureExtractorConfig$.MODULE$.apply$default$5();
        float x$7 = FeatureExtractorConfig$.MODULE$.apply$default$6();
        Option<Object> x$8 = FeatureExtractorConfig$.MODULE$.apply$default$7();
        int x$9 = FeatureExtractorConfig$.MODULE$.apply$default$8();
        MzDbFeatureExtractor mzdbFtX = new MzDbFeatureExtractor(mzDb, 5, 2, new FeatureExtractorConfig(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<Object>)x$2));
        Seq<Feature> xFts = mzdbFtX.extractFeatures(rsdProv, (Seq<PutativeFeature>)Predef$.MODULE$.wrapRefArray((Object[])pfs), mzTolPPM);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Storing detected features");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        SQLiteFeatureStorer$.MODULE$.storeFeatures(xFts, new File(outputFile));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Ended");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public float[] smoothIntensities(float[] intensities) {
        int times = 3;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)4));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int nl = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int nr = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int order = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)nl), (Object)BoxesRunTime.boxToInteger((int)nr), (Object)BoxesRunTime.boxToInteger((int)order));
        Tuple3 tuple33 = tuple32;
        int nl2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int nr2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int order2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        double[] coeffs = SGFilterMath3.computeSGCoefficients(nl2, nr2, order2);
        SGFilterMath3 sgFilter = new SGFilterMath3(5, 5);
        ObjectRef smoothedIntensities = ObjectRef.create((Object)intensities);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), times).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            smoothedIntensities$1.elem = sgFilter.smooth((float[])smoothedIntensities$1.elem, coeffs);
        });
        return (float[])smoothedIntensities.elem;
    }

    public void dumpRegion(String mzdbFilePath, String outputFilePath, double mzmin, double mzmax, float rtmin, float rtmax) {
        BoxedUnit boxedUnit;
        long start = System.currentTimeMillis();
        MzDbReader mzDb = new MzDbReader(mzdbFilePath, true);
        PrintWriter outStream = new PrintWriter(new FileOutputStream(outputFilePath));
        SpectrumSlice[] spectrumSlices = mzDb.getMsSpectrumSlices(mzmin, mzmax, rtmin, rtmax);
        outStream.println(new .colon.colon((Object)"moz", (List)new .colon.colon((Object)"time", (List)new .colon.colon((Object)"intensity", (List)Nil$.MODULE$))).mkString("\t"));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).foreach((Function1 & Serializable & scala.Serializable)spectrumSlice -> {
            Commands$.$anonfun$dumpRegion$1(outStream, spectrumSlice);
            return BoxedUnit.UNIT;
        });
        outStream.close();
        mzDb.close();
        float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(17).append("extraction took: ").append(took).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void dumpRegionBinning(String mzdbFilePath, String outputFilePath, int nbBins, double mzmin, double mzmax, float rtmin, float rtmax) {
        BoxedUnit boxedUnit;
        long start = System.currentTimeMillis();
        MzDbReader mzDb = new MzDbReader(mzdbFilePath, true);
        PrintWriter outStream = new PrintWriter(new FileOutputStream(outputFilePath));
        SpectrumSlice[] spectrumSlices = mzDb.getMsSpectrumSlices(mzmin, mzmax, rtmin, rtmax);
        double[] flattenedPeaksMz = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toPeaks(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class)))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Peak.class)))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.getMz()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sortBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x, (Ordering)Ordering.Double$.MODULE$);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(flattenedPeaksMz)).head()), BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(flattenedPeaksMz)).last()));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double minmz = sp2._1$mcD$sp();
        double maxmz = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(minmz, maxmz);
        Tuple2.mcDD.sp sp4 = sp3;
        double minmz2 = sp4._1$mcD$sp();
        double maxmz2 = sp4._2$mcD$sp();
        package.EntityHistogramComputer binner = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapDoubleArray(flattenedPeaksMz), (Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x);
        Tuple2[] mzBins = binner.calcHistogram(nbBins, binner.calcHistogram$default$2());
        double[] mzList = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mzBins)).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Commands$.$anonfun$dumpRegionBinning$6(x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toArray(ClassTag$.MODULE$.Double());
        float[] rtList = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToFloat((float)Commands$.$anonfun$dumpRegionBinning$7(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).toArray(ClassTag$.MODULE$.Float());
        float[][] intList = (float[][])Array$.MODULE$.ofDim(spectrumSlices.length, mzBins.length, ClassTag$.MODULE$.Float());
        IntRef i = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).foreach((Function1 & Serializable & scala.Serializable)spectrumSlice -> {
            Commands$.$anonfun$dumpRegionBinning$8(nbBins, minmz2, maxmz2, intList, i, spectrumSlice);
            return BoxedUnit.UNIT;
        });
        outStream.println(new StringBuilder(5).append("moz: ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mzList)).mkString("\t")).toString());
        outStream.println(new StringBuilder(4).append("rt: ").append(new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rtList)).mkString("\t")).toString());
        String intString = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intList)).map((Function1 & Serializable & scala.Serializable)x$16 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$16)).mkString("\t"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        outStream.println(new StringBuilder(13).append("intensities: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intList)).map((Function1 & Serializable & scala.Serializable)x$17 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$17)).mkString("\t"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString(",")).toString());
        outStream.close();
        mzDb.close();
        float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(17).append("extraction took: ").append(took).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void dumpScanHeaders(String mzdbFilePath, String outputFilePath, int msLevel) {
        BoxedUnit boxedUnit;
        long start = System.currentTimeMillis();
        MzDbReader mzDbReader = new MzDbReader(mzdbFilePath, true);
        PrintWriter outStream = new PrintWriter(new FileOutputStream(outputFilePath));
        if (msLevel != 2) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        outStream.println(new .colon.colon((Object)"file", (List)new .colon.colon((Object)"scan", (List)new .colon.colon((Object)"moz", (List)new .colon.colon((Object)"charge", (List)Nil$.MODULE$)))).mkString("\t"));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mzDbReader.getMs2SpectrumHeaders())).foreach((Function1 & Serializable & scala.Serializable)sh -> {
            outStream.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mzdbFilePath, BoxesRunTime.boxToInteger((int)sh.getInitialId()), sh.getPrecursorMz(), sh.getPrecursorCharge()})).mkString("\t"));
            return BoxedUnit.UNIT;
        });
        outStream.close();
        mzDbReader.close();
        float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(17).append("extraction took: ").append(took).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void createMgf() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(31).append("Creating MGF File for mzDB at: ").append(MzDbProcessing$CreateMgfCommand$.MODULE$.mzdbFile()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(55).append("Precursor m/z values will be defined using the method: ").append(MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MgfWriter writer = new MgfWriter(MzDbProcessing$CreateMgfCommand$.MODULE$.mzdbFile(), MzDbProcessing$CreateMgfCommand$.MODULE$.msLevel());
        Option precCompEnum = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PrecursorMzComputationEnum.values())).find((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$createMgf$1(x$18)));
        DefaultSpectrumProcessor specProcessor = new DefaultSpectrumProcessor();
        if (precCompEnum.isDefined()) {
            writer.write(MzDbProcessing$CreateMgfCommand$.MODULE$.outputFile(), (IPrecursorComputation)new DefaultPrecursorComputer((PrecursorMzComputationEnum)precCompEnum.get(), MzDbProcessing$CreateMgfCommand$.MODULE$.mzTolPPM()), (ISpectrumProcessor)specProcessor, MzDbProcessing$CreateMgfCommand$.MODULE$.intensityCutoff(), MzDbProcessing$CreateMgfCommand$.MODULE$.exportProlineTitle());
        } else {
            String string = MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation();
            String string2 = "isolation_window_extracted";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                IsolationWindowPrecursorExtractor precComputer = new IsolationWindowPrecursorExtractor(MzDbProcessing$CreateMgfCommand$.MODULE$.mzTolPPM());
                writer.write(MzDbProcessing$CreateMgfCommand$.MODULE$.outputFile(), (IPrecursorComputation)precComputer, (ISpectrumProcessor)specProcessor, MzDbProcessing$CreateMgfCommand$.MODULE$.intensityCutoff(), MzDbProcessing$CreateMgfCommand$.MODULE$.exportProlineTitle());
            } else {
                String string3 = MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation();
                String string4 = "mgf_boost";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    MgfBoostPrecursorExtractor precComputer = new MgfBoostPrecursorExtractor(MzDbProcessing$CreateMgfCommand$.MODULE$.mzTolPPM(), true, true, 1, 0.2f, ScanSelectorModes$.MODULE$.SAME_CYCLE(), MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$7(), MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$8());
                    writer.write(MzDbProcessing$CreateMgfCommand$.MODULE$.outputFile(), (IPrecursorComputation)precComputer, (ISpectrumProcessor)specProcessor, MzDbProcessing$CreateMgfCommand$.MODULE$.intensityCutoff(), MzDbProcessing$CreateMgfCommand$.MODULE$.exportProlineTitle());
                } else {
                    throw new IllegalArgumentException("Can't create the MGF file, invalid precursor m/z computation method");
                }
            }
        }
    }

    private static final /* synthetic */ Commands$DetectedPeak$2$ DetectedPeak$lzycompute$1(LazyRef DetectedPeak$module$1) {
        Commands$DetectedPeak$2$ commands$DetectedPeak$2$;
        LazyRef lazyRef = DetectedPeak$module$1;
        synchronized (lazyRef) {
            commands$DetectedPeak$2$ = DetectedPeak$module$1.initialized() ? (Commands$DetectedPeak$2$)((Object)DetectedPeak$module$1.value()) : (Commands$DetectedPeak$2$)((Object)DetectedPeak$module$1.initialize((Object)new Commands$DetectedPeak$2$()));
        }
        return commands$DetectedPeak$2$;
    }

    private final Commands$DetectedPeak$2$ DetectedPeak$3(LazyRef DetectedPeak$module$1) {
        return DetectedPeak$module$1.initialized() ? (Commands$DetectedPeak$2$)((Object)DetectedPeak$module$1.value()) : Commands$.DetectedPeak$lzycompute$1(DetectedPeak$module$1);
    }

    public static final /* synthetic */ float $anonfun$generateXICs$1(float s, Peak p) {
        return s + p.getIntensity();
    }

    private static final float sumPeaks$1(Seq peaks) {
        return BoxesRunTime.unboxToFloat((Object)peaks.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(s, p) -> BoxesRunTime.boxToFloat((float)Commands$.$anonfun$generateXICs$1(BoxesRunTime.unboxToFloat((Object)s), p))));
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$2(Peak a, Peak b) {
        return a.getIntensity() > b.getIntensity();
    }

    private static final float highestPeakIntensity$1(Seq peaks) {
        return ((Peak)((IterableLike)peaks.sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$2(a, b)))).head()).getIntensity();
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getMzdbList$1(String mzdbListFilePath$1) {
        void var2_2;
        BoxedUnit boxedUnit;
        String[] a = (String[])Source$.MODULE$.fromFile(mzdbListFilePath$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().toArray(ClassTag$.MODULE$.apply(String.class));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Found #{} files to analyze", new Object[]{BoxesRunTime.boxToInteger((int)a.length)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Tuple3[] getPeptideList$1(File pepFile) {
        void var1_1;
        Tuple3[] mzList = (Tuple3[])Source$.MODULE$.fromFile(pepFile.getAbsolutePath(), Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1 & Serializable & scala.Serializable)l -> {
            void var3_2;
            String[] splitted = new StringOps(Predef$.MODULE$.augmentString("\\s")).r().split((CharSequence)l);
            Tuple3 returnVal = null;
            if (splitted.length == 1) {
                returnVal = new Tuple3((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble()), (Object)BoxesRunTime.boxToFloat((float)0.0f), (Object)BoxesRunTime.boxToFloat((float)0.0f));
            } else if (splitted.length == 3) {
                double mz = new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble();
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(splitted[1])).toFloat()), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(splitted[2])).toFloat()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                float rtmin = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                float rtmax = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)rtmin), (Object)BoxesRunTime.boxToFloat((float)rtmax));
                Tuple2 tuple23 = tuple22;
                float rtmin2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                float rtmax2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                if (rtmin2 > rtmax2) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("rtmin is bigger than rtmax: switching both...");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    float tmp = rtmin2;
                    rtmin2 = rtmax2;
                    rtmax2 = tmp;
                }
                returnVal = new Tuple3((Object)BoxesRunTime.boxToDouble((double)mz), (Object)BoxesRunTime.boxToFloat((float)rtmin2), (Object)BoxesRunTime.boxToFloat((float)rtmax2));
            } else {
                throw new Exception(new StringBuilder(43).append("can not parse correctly pepList file, line:").append((String)l).toString());
            }
            return var3_2;
        }).toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        return var1_1;
    }

    public static final /* synthetic */ Peak $anonfun$generateXICs$7(Peak[] peaks$1, int x$3) {
        return peaks$1[x$3];
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$8(Peak[] peaks$1, float rtmin$1, float rtmax$1, Tuple2 x) {
        return (double)peaks$1[x._1$mcI$sp()].getLcContext().getElutionTime() / 60.0 > (double)rtmin$1 && (double)peaks$1[x._2$mcI$sp()].getLcContext().getElutionTime() / 60.0 < (double)rtmax$1;
    }

    public static final /* synthetic */ Peak $anonfun$generateXICs$10(Peak[] peaks$1, int x$4) {
        return peaks$1[x$4];
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$11(Peak[] a, Peak[] b) {
        return Commands$.highestPeakIntensity$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])a)) > Commands$.highestPeakIntensity$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])b));
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$13(int apexIdx$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = tuple2._2$mcI$sp();
        boolean bl = i <= apexIdx$1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$14(FloatRef prevIntensity$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak p = (Peak)tuple2._1();
        float curIntensity = p.getIntensity();
        boolean isHigher = curIntensity >= prevIntensity$1.elem;
        prevIntensity$1.elem = curIntensity;
        boolean bl = isHigher;
        return bl;
    }

    private static final Tuple2[] keepPeaksWithIncreasingIntensity$1(Tuple2[] peaksWithIdx) {
        FloatRef prevIntensity = FloatRef.create((float)0.0f);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaksWithIdx)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$14(prevIntensity, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$generateXICs$17(double threshold$1, Peak p) {
        return (double)p.getIntensity() > threshold$1;
    }

    private final Tuple2[] extractXICs$1(MzDbReader mzDb, Tuple3[] mzList, float mzTolInPPM$1, String algo$1, LazyRef DetectedPeak$module$1) {
        BoxedUnit boxedUnit;
        Tuple3[] peakMatrix = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mzList)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Peak[] peaks;
            float rtmax;
            float rtmin;
            double mz;
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                BoxedUnit boxedUnit;
                mz = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                rtmin = BoxesRunTime.unboxToFloat((Object)tuple3._2());
                rtmax = BoxesRunTime.unboxToFloat((Object)tuple3._3());
                double mzTolInDa = (double)mzTolInPPM$1 * mz / 1000000.0;
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(mz - mzTolInDa, mz + mzTolInDa);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double minMz = sp2._1$mcD$sp();
                double maxMz = sp2._2$mcD$sp();
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(minMz, maxMz);
                Tuple2.mcDD.sp sp4 = sp3;
                double minMz2 = sp4._1$mcD$sp();
                double maxMz2 = sp4._2$mcD$sp();
                peaks = mzDb.getMsXicInMzRange(minMz2, maxMz2, XicMethod.MAX);
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("XIC for mass {} contains #{} peaks", new Object[]{BoxesRunTime.boxToDouble((double)mz), BoxesRunTime.boxToInteger((int)peaks.length)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)mz), (Object)peaks, (Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)rtmin), (Object)BoxesRunTime.boxToFloat((float)rtmax)));
            return tuple32;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        String string = algo$1;
        String string2 = "basic";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("basic algorithm");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            String string3 = algo$1;
            String string4 = "wavelet";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("wavelet algorithm");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new Exception(new StringBuilder(35).append("Specified algorithm is not defined:").append(algo$1).toString());
            }
        }
        return (Tuple2[])((ParIterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakMatrix)).par().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 intSum;
            Tuple2 tuple2;
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            double mz = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            Peak[] peaks = (Peak[])tuple3._2();
            Tuple2 tuple22 = (Tuple2)tuple3._3();
            if (tuple22 == null) throw new MatchError((Object)tuple3);
            float rtmin = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            float rtmax = BoxesRunTime.unboxToFloat((Object)tuple22._2());
            Tuple2<Object, Object>[] peakelIndexes = null;
            String string = algo$1;
            String string2 = "basic";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BasicPeakelFinder basicPeakelFinder = new BasicPeakelFinder(BasicPeakelFinder$.MODULE$.$lessinit$greater$default$1(), BasicPeakelFinder$.MODULE$.$lessinit$greater$default$2());
                peakelIndexes = basicPeakelFinder.findPeakelsIndices((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])peaks));
            } else {
                String string3 = algo$1;
                String string4 = "wavelet";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    WaveletDetectorDuMethod wpf = new WaveletDetectorDuMethod((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])peaks));
                    wpf.ridgeFilteringParams().minSNR_$eq(0.0f);
                    peakelIndexes = wpf.findPeakelsIndexes();
                }
            }
            Peak[][] peakels = rtmin == 0.0f && rtmax == 0.0f ? (Peak[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelIndexes)).map((Function1 & Serializable & scala.Serializable)peakelIdx -> (Peak[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(peakelIdx._1$mcI$sp()), peakelIdx._2$mcI$sp()).toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)x$3 -> Commands$.$anonfun$generateXICs$7(peaks, BoxesRunTime.unboxToInt((Object)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class)))) : (Peak[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelIndexes)).withFilter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$8(peaks, rtmin, rtmax, x))).map((Function1 & Serializable & scala.Serializable)peakelIdx -> (Peak[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(peakelIdx._1$mcI$sp()), peakelIdx._2$mcI$sp()).toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)x$4 -> Commands$.$anonfun$generateXICs$10(peaks, BoxesRunTime.unboxToInt((Object)x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class))));
            Peak[][] sortedPeakels = (Peak[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakels)).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$11(a, b)));
            if (sortedPeakels.length > 0) {
                Peak[] peaks2 = sortedPeakels[0];
                Peak apex = (Peak)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks2)).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.getIntensity() > b.getIntensity() ? a : b);
                int apexIdx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks2)).indexOf((Object)apex);
                Tuple2 tuple23 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks2)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$13(apexIdx, x0$3)));
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Tuple2[] leftPeaksWithIdx = (Tuple2[])tuple23._1();
                Tuple2[] rightPeaksWithIdx = (Tuple2[])tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)leftPeaksWithIdx, (Object)rightPeaksWithIdx);
                Tuple2 tuple25 = tuple24;
                Tuple2[] leftPeaksWithIdx2 = (Tuple2[])tuple25._1();
                Tuple2[] rightPeaksWithIdx2 = (Tuple2[])tuple25._2();
                Tuple2[] leftPeaksFiltered = Commands$.keepPeaksWithIncreasingIntensity$1(leftPeaksWithIdx2);
                Tuple2[] rightPeaksFiltered = Commands$.keepPeaksWithIncreasingIntensity$1((Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightPeaksWithIdx2)).reverse());
                Peak[] smoothedPeaks = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftPeaksFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightPeaksFiltered)).reverse())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$15(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
                    Peak p;
                    Tuple2 tuple2 = x$6;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Peak peak = p = (Peak)tuple2._1();
                    return peak;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class)));
                double threshold = (double)apex.getIntensity() * 0.05;
                Peak[] filteredPeaks = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])smoothedPeaks)).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Commands$.$anonfun$generateXICs$17(threshold, p)));
                PeakelBuilder qual$1 = new PeakelBuilder((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])filteredPeaks));
                int x$1 = qual$1.result$default$1();
                Peakel peakel = qual$1.result(x$1);
                public class Fr_profi_mzdb_cli_Commands$DetectedPeak$1
                implements Product,
                scala.Serializable {
                    private float intensity;
                    private float time;
                    private final double mz;
                    private final Peak apex;
                    private final float duration;
                    private final float area;
                    private volatile byte bitmap$0;

                    public double mz() {
                        return this.mz;
                    }

                    public Peak apex() {
                        return this.apex;
                    }

                    public float duration() {
                        return this.duration;
                    }

                    public float area() {
                        return this.area;
                    }

                    private float intensity$lzycompute() {
                        Fr_profi_mzdb_cli_Commands$DetectedPeak$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                this.intensity = this.apex().getIntensity();
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                        }
                        return this.intensity;
                    }

                    public float intensity() {
                        return (byte)(this.bitmap$0 & 1) == 0 ? this.intensity$lzycompute() : this.intensity;
                    }

                    private float time$lzycompute() {
                        Fr_profi_mzdb_cli_Commands$DetectedPeak$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                this.time = this.apex().getLcContext().getElutionTime();
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                        }
                        return this.time;
                    }

                    public float time() {
                        return (byte)(this.bitmap$0 & 2) == 0 ? this.time$lzycompute() : this.time;
                    }

                    public float getApexFullSpectrumIntensity(MzDbReader mzDb) {
                        Spectrum spectrum = mzDb.getSpectrum(this.apex().getLcContext().getSpectrumId());
                        return spectrum.getHeader().getTIC();
                    }

                    public Fr_profi_mzdb_cli_Commands$DetectedPeak$1 copy(double mz, Peak apex, float duration, float area) {
                        return new Fr_profi_mzdb_cli_Commands$DetectedPeak$1(mz, apex, duration, area);
                    }

                    public double copy$default$1() {
                        return this.mz();
                    }

                    public Peak copy$default$2() {
                        return this.apex();
                    }

                    public float copy$default$3() {
                        return this.duration();
                    }

                    public float copy$default$4() {
                        return this.area();
                    }

                    public String productPrefix() {
                        return "DetectedPeak";
                    }

                    public int productArity() {
                        return 4;
                    }

                    public Object productElement(int x$1) {
                        Object object;
                        int n = x$1;
                        switch (n) {
                            case 0: {
                                object = BoxesRunTime.boxToDouble((double)this.mz());
                                break;
                            }
                            case 1: {
                                object = this.apex();
                                break;
                            }
                            case 2: {
                                object = BoxesRunTime.boxToFloat((float)this.duration());
                                break;
                            }
                            case 3: {
                                object = BoxesRunTime.boxToFloat((float)this.area());
                                break;
                            }
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                        }
                        return object;
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Fr_profi_mzdb_cli_Commands$DetectedPeak$1;
                    }

                    public int hashCode() {
                        int n = -889275714;
                        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mz()));
                        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.apex()));
                        n = Statics.mix((int)n, (int)Statics.floatHash((float)this.duration()));
                        n = Statics.mix((int)n, (int)Statics.floatHash((float)this.area()));
                        return Statics.finalizeHash((int)n, (int)4);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Fr_profi_mzdb_cli_Commands$DetectedPeak$1)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Fr_profi_mzdb_cli_Commands$DetectedPeak$1 var4_4 = (Fr_profi_mzdb_cli_Commands$DetectedPeak$1)x$1;
                        if (this.mz() != var4_4.mz()) return false;
                        Peak peak = this.apex();
                        Peak peak2 = var4_4.apex();
                        if (peak == null) {
                            if (peak2 != null) {
                                return false;
                            }
                        } else if (!peak.equals(peak2)) return false;
                        if (this.duration() != var4_4.duration()) return false;
                        if (this.area() != var4_4.area()) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public Fr_profi_mzdb_cli_Commands$DetectedPeak$1(double mz, Peak apex, float duration, float area) {
                        this.mz = mz;
                        this.apex = apex;
                        this.duration = duration;
                        this.area = area;
                        Product.$init$((Product)this);
                    }
                }
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)mz)), (Object)new Some((Object)this.DetectedPeak$3(DetectedPeak$module$1).apply(peakel.getMz(), apex, peakel.calcDuration(), peakel.area())));
                intSum = tuple2;
                return intSum;
            } else {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)mz)), (Object)None$.MODULE$);
            }
            intSum = tuple2;
            return intSum;
        }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ void $anonfun$generateXICs$18(MzDbReader mzDb$2, ArrayBuffer xicsBuilder$1, String mzdbFilePath$1, Tuple2 pep) {
        BoxedUnit boxedUnit;
        double mz = pep._1$mcD$sp();
        if (((Option)pep._2()).isDefined()) {
            BoxedUnit boxedUnit2;
            Fr_profi_mzdb_cli_Commands$DetectedPeak$1 peak = (Fr_profi_mzdb_cli_Commands$DetectedPeak$1)((Option)pep._2()).get();
            Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)peak.mz()), (Object)BoxesRunTime.boxToFloat((float)(peak.time() / (float)60)), (Object)BoxesRunTime.boxToFloat((float)(peak.duration() / (float)60)), (Object)BoxesRunTime.boxToFloat((float)peak.area()), (Object)BoxesRunTime.boxToFloat((float)peak.intensity()), (Object)BoxesRunTime.boxToFloat((float)peak.getApexFullSpectrumIntensity(mzDb$2)));
            if (tuple6 == null) {
                throw new MatchError((Object)tuple6);
            }
            double expMz = BoxesRunTime.unboxToDouble((Object)tuple6._1());
            float time = BoxesRunTime.unboxToFloat((Object)tuple6._2());
            float dur = BoxesRunTime.unboxToFloat((Object)tuple6._3());
            float area = BoxesRunTime.unboxToFloat((Object)tuple6._4());
            float f = BoxesRunTime.unboxToFloat((Object)tuple6._5());
            float msSpectrumInt = BoxesRunTime.unboxToFloat((Object)tuple6._6());
            Tuple6 tuple62 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)expMz), (Object)BoxesRunTime.boxToFloat((float)time), (Object)BoxesRunTime.boxToFloat((float)dur), (Object)BoxesRunTime.boxToFloat((float)area), (Object)BoxesRunTime.boxToFloat((float)f), (Object)BoxesRunTime.boxToFloat((float)msSpectrumInt));
            Tuple6 tuple63 = tuple62;
            double expMz2 = BoxesRunTime.unboxToDouble((Object)tuple63._1());
            float time2 = BoxesRunTime.unboxToFloat((Object)tuple63._2());
            float dur2 = BoxesRunTime.unboxToFloat((Object)tuple63._3());
            float area2 = BoxesRunTime.unboxToFloat((Object)tuple63._4());
            int = BoxesRunTime.unboxToFloat((Object)tuple63._5());
            float msSpectrumInt2 = BoxesRunTime.unboxToFloat((Object)tuple63._6());
            xicsBuilder$1.$plus$eq((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mzdbFilePath$1, BoxesRunTime.boxToDouble((double)mz), BoxesRunTime.boxToDouble((double)expMz2), BoxesRunTime.boxToFloat((float)time2), BoxesRunTime.boxToFloat((float)dur2), BoxesRunTime.boxToFloat((float)area2), BoxesRunTime.boxToFloat((float)int), BoxesRunTime.boxToFloat((float)msSpectrumInt2)})).mkString("\t"));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(55).append("found peptide ion of intensity |").append(int).append("| and duration |").append(dur2).append("| at |").append(time2).append("|").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (MODULE$.logger().underlying().isWarnEnabled()) {
            MODULE$.logger().underlying().warn(new StringBuilder(30).append("can't find peptide ion of m/z=").append(mz).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final String[] extractXICsForOneFile$1(String mzdbFilePath, Tuple3[] mzList, float mzTolInPPM$1, String algo$1, LazyRef DetectedPeak$module$1) {
        String[] stringArray;
        long start = System.currentTimeMillis();
        try (Object mzDb = null;){
            try {
                BoxedUnit boxedUnit;
                MzDbReader mzDb2 = new MzDbReader(mzdbFilePath, true);
                ArrayBuffer xicsBuilder = new ArrayBuffer();
                Tuple2[] peptides = this.extractXICs$1(mzDb2, mzList, mzTolInPPM$1, algo$1, DetectedPeak$module$1);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peptides)).foreach((Function1 & Serializable & scala.Serializable)pep -> {
                    Commands$.$anonfun$generateXICs$18(mzDb2, xicsBuilder, mzdbFilePath, pep);
                    return BoxedUnit.UNIT;
                });
                float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(17).append("extraction took: ").append(took).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stringArray = (String[])xicsBuilder.toArray(ClassTag$.MODULE$.apply(String.class));
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(37).append("Extraction failed for file ").append(mzdbFilePath).append(" because: ").append(e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }
        return stringArray;
    }

    private static final PutativeFeature[] getPutativeFeatures$1(String putativeFtsFile$1) {
        return (PutativeFeature[])Source$.MODULE$.fromFile(putativeFtsFile$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1 & Serializable & scala.Serializable)l -> {
            String[] splitted = new StringOps(Predef$.MODULE$.augmentString("\\s")).r().split((CharSequence)l);
            return new PutativeFeature(Feature$.MODULE$.generateNewId(), new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(splitted[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(splitted[2])).toFloat(), 1, true);
        }).toArray(ClassTag$.MODULE$.apply(PutativeFeature.class));
    }

    public static final /* synthetic */ void $anonfun$dumpRegion$1(PrintWriter outStream$1, SpectrumSlice spectrumSlice) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlice.toPeaks())).foreach((Function1 & Serializable & scala.Serializable)peak -> {
            outStream$1.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{peak.getMz(), peak.getLcContext().getElutionTime(), peak.getIntensity()})).mkString("\t"));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$dumpRegionBinning$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Bin bin = (Bin)tuple2._1();
        double d = bin.center();
        return d;
    }

    public static final /* synthetic */ float $anonfun$dumpRegionBinning$7(SpectrumSlice x$14) {
        return x$14.getHeader().getElutionTime();
    }

    public static final /* synthetic */ void $anonfun$dumpRegionBinning$10(float[][] intList$1, IntRef i$1, IntRef j$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Seq values = (Seq)tuple2._2();
            intList$1[i$1.elem][j$1.elem] = BoxesRunTime.unboxToFloat((Object)((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToFloat((float)x$15.getIntensity()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            ++j$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$dumpRegionBinning$8(int nbBins$1, double minmz$1, double maxmz$1, float[][] intList$1, IntRef i$1, SpectrumSlice spectrumSlice) {
        package.EntityHistogramComputer binner_ = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapRefArray((Object[])spectrumSlice.toPeaks()), (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)x.getMz()));
        Tuple2[] bins = binner_.calcHistogram(nbBins$1, (Option)new Some((Object)new Tuple2.mcDD.sp(minmz$1, maxmz$1)));
        IntRef j = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Commands$.$anonfun$dumpRegionBinning$10(intList$1, i$1, j, x0$2);
            return BoxedUnit.UNIT;
        });
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$createMgf$1(PrecursorMzComputationEnum x$18) {
        String string = x$18.name();
        String string2 = MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation().toUpperCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Commands$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

