/*
 * Decompiled with CFR 0.152.
 */
package mr.go.sgfilter;

import mr.go.sgfilter.Preprocessor;

public class MeanValuePadder
implements Preprocessor {
    private boolean paddingLeft = true;
    private boolean paddingRight = true;
    private int windowLength;

    public MeanValuePadder(int windowLength) {
        if (windowLength < 0) {
            throw new IllegalArgumentException("windowLength < 0");
        }
        this.windowLength = windowLength;
    }

    public MeanValuePadder(int windowLength, boolean paddingLeft, boolean paddingRight) {
        if (windowLength < 0) {
            throw new IllegalArgumentException("windowLength < 0");
        }
        this.windowLength = windowLength;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
    }

    @Override
    public void apply(double[] data) {
        int i;
        int m;
        int n = data.length;
        if (this.paddingLeft) {
            int l = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                if (data[i2] == 0.0) continue;
                l = i2;
                break;
            }
            double avg = 0.0;
            m = Math.min(l + this.windowLength / 2, n);
            for (i = l; i < m; ++i) {
                avg += data[i];
            }
            avg /= (double)(m - l);
            for (i = 0; i < l; ++i) {
                data[i] = avg;
            }
        }
        if (this.paddingRight) {
            int r = 0;
            for (int i3 = n - 1; i3 >= 0; --i3) {
                if (data[i3] == 0.0) continue;
                r = i3;
                break;
            }
            double avg = 0.0;
            m = Math.min(this.windowLength / 2, r + 1);
            for (i = 0; i < m; ++i) {
                avg += data[r - i];
            }
            avg /= (double)m;
            for (i = r + 1; i < n; ++i) {
                data[i] = avg;
            }
        }
    }

    public int getWindowLength() {
        return this.windowLength;
    }

    public boolean isPaddingLeft() {
        return this.paddingLeft;
    }

    public boolean isPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingLeft(boolean paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(boolean paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setWindowLength(int windowLength) {
        if (windowLength < 0) {
            throw new IllegalArgumentException("windowLength < 0");
        }
        this.windowLength = windowLength;
    }
}

