/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteJob;
import com.almworks.sqlite4java.SQLiteQueue;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDBParamName_0_8;
import fr.profi.mzdb.db.model.MzDBParamName_0_9;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.io.reader.MzDbReaderQueries;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.DataEncodingAsyncReader;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCache;
import fr.profi.mzdb.io.reader.cache.RunSliceHeaderAsyncReader;
import fr.profi.mzdb.io.reader.cache.SpectrumHeaderAsyncReader;
import fr.profi.mzdb.io.reader.iterator.BoundingBoxIterator;
import fr.profi.mzdb.io.reader.iterator.LcMsRunSliceIterator;
import fr.profi.mzdb.io.reader.iterator.LcMsnRunSliceIterator;
import fr.profi.mzdb.io.reader.iterator.SpectrumIterator;
import fr.profi.mzdb.io.reader.table.InstrumentConfigReader;
import fr.profi.mzdb.io.reader.table.MzDbHeaderReader;
import fr.profi.mzdb.io.reader.table.RunReader;
import fr.profi.mzdb.io.reader.table.SampleReader;
import fr.profi.mzdb.io.reader.table.SoftwareReader;
import fr.profi.mzdb.io.reader.table.SourceFileReader;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.RunSliceData;
import fr.profi.mzdb.model.RunSliceHeader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.sqlite.ISQLiteConnectionFunction;
import fr.profi.mzdb.util.sqlite.SQLiteJobWrapper;
import fr.profi.mzdb.util.sqlite.SQLiteObservableJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class MzDbAsyncReader
extends AbstractMzDbReader {
    final Logger logger = LoggerFactory.getLogger(MzDbAsyncReader.class);
    private SQLiteQueue queue = null;
    private DataEncodingAsyncReader _dataEncodingReader = null;
    private SpectrumHeaderAsyncReader _spectrumHeaderReader = null;
    private RunSliceHeaderAsyncReader _runSliceHeaderReader = null;
    private final Object _blockingConnectionLock = new Object();

    public MzDbAsyncReader(File dbLocation, MzDbEntityCache entityCache, boolean logConnections) throws FileNotFoundException, SQLiteException {
        this.entityCache = entityCache;
        if (!logConnections) {
            java.util.logging.Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.OFF);
        }
        if (!dbLocation.exists()) {
            throw new FileNotFoundException("can't find the mzDB file at the given path: " + dbLocation);
        }
        this.dbLocation = dbLocation;
        this.queue = new SQLiteQueue(dbLocation);
        this.queue.start();
        this.queue.execute((SQLiteJob)new SQLiteJob<Void>(){

            protected Void job(SQLiteConnection connection) throws SQLiteException {
                connection.openReadonly();
                connection.exec("PRAGMA synchronous=OFF;");
                connection.exec("PRAGMA journal_mode=OFF;");
                connection.exec("PRAGMA temp_store=2;");
                connection.exec("PRAGMA cache_size=-100000;");
                MzDbAsyncReader.this.mzDbHeader = new MzDbHeaderReader(connection).getMzDbHeader();
                String converterVersion = "";
                boolean isConverter09Compatible = false;
                List<Software> softwareLists = new SoftwareReader(connection).getSoftwareList();
                for (Software nextSoft : softwareLists) {
                    if (nextSoft.getName().endsWith("mzDB")) {
                        converterVersion = nextSoft.getVersion();
                        break;
                    }
                    if (!nextSoft.getName().equals(AbstractMzDbReader.ThermoConverterName) && !nextSoft.getName().equals(AbstractMzDbReader.TimsTofConverterName)) continue;
                    converterVersion = nextSoft.getVersion();
                    isConverter09Compatible = true;
                    break;
                }
                MzDbAsyncReader.this._paramNameGetter = isConverter09Compatible || converterVersion.compareTo("0.9.1") > 0 ? new MzDBParamName_0_9() : new MzDBParamName_0_8();
                MzDbAsyncReader.this._setBBSizes(MzDbAsyncReader.this._paramNameGetter);
                return null;
            }
        });
        this._dataEncodingReader = new DataEncodingAsyncReader(this);
        this._spectrumHeaderReader = new SpectrumHeaderAsyncReader(this, (AbstractDataEncodingReader)this._dataEncodingReader);
        this._runSliceHeaderReader = new RunSliceHeaderAsyncReader(this);
    }

    public MzDbAsyncReader(File dbLocation, boolean cacheEntities) throws FileNotFoundException, SQLiteException {
        this(dbLocation, cacheEntities ? new MzDbEntityCache() : null, false);
    }

    public MzDbAsyncReader(String dbPath, boolean cacheEntities) throws FileNotFoundException, SQLiteException {
        this(new File(dbPath), cacheEntities ? new MzDbEntityCache() : null, false);
    }

    @Override
    public void close() {
        this.queue.stop(true);
        this.logger.debug("Waiting for Job queue to finish");
        try {
            this.queue.join();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataEncodingAsyncReader getDataEncodingReader() {
        return this._dataEncodingReader;
    }

    @Override
    public SpectrumHeaderAsyncReader getSpectrumHeaderReader() {
        return this._spectrumHeaderReader;
    }

    @Override
    public RunSliceHeaderAsyncReader getRunSliceHeaderReader() {
        return this._runSliceHeaderReader;
    }

    public void waitForQueries() throws InterruptedException {
        this.queue.flush();
    }

    protected SQLiteConnection createBlockingSQLiteConnection() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            try {
                return new MzDbReader(this.dbLocation, this.entityCache, false).getConnection();
            }
            catch (SQLiteException | FileNotFoundException e) {
                this.logger.error("Can't open blocking MzDbReader at location: " + this.dbLocation.getAbsolutePath(), e);
                throw new SQLiteException(0, "Error acquiring blocking SQLiteConnection");
            }
        }
    }

    public <T> SQLiteObservableJob<T> observeJobExecution(final ISQLiteConnectionFunction<T> sqliteConnFunction) {
        SQLiteJobWrapper jobWrapper = new SQLiteJobWrapper<T>(){

            @Override
            public T job(SQLiteConnection connection) throws Exception {
                return sqliteConnFunction.apply(connection);
            }
        };
        return new SQLiteObservableJob(this.queue, jobWrapper);
    }

    public Observable<String> getModelVersion() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getModelVersion(connection));
    }

    public Observable<Float> getLastTime() {
        return this.observeJobExecution(connection -> Float.valueOf(MzDbReaderQueries.getLastTime(connection)));
    }

    public Observable<Integer> getMaxMsLevel() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getMaxMsLevel(connection));
    }

    public Observable<int[]> getMzRange(int msLevel) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getMzRange(msLevel, connection));
    }

    public Observable<Integer> getBoundingBoxesCount() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getBoundingBoxesCount(connection));
    }

    public Observable<Integer> getBoundingBoxesCount(int runSliceId) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getBoundingBoxesCount(runSliceId, connection));
    }

    public Observable<Integer> getCyclesCount() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getCyclesCount(connection));
    }

    public Observable<Integer> getDataEncodingsCount() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getDataEncodingsCount(connection));
    }

    public Observable<Integer> getSpectraCount() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getSpectraCount(connection));
    }

    public Observable<Integer> getSpectraCount(int msLevel) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getSpectraCount(msLevel, connection));
    }

    public Observable<Integer> getRunSlicesCount() {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getRunSlicesCount(connection));
    }

    public Observable<Integer> getTableRecordsCount(String tableName) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getTableRecordsCount(tableName, connection));
    }

    public Observable<DataEncoding> getDataEncoding(long id) {
        return this._dataEncodingReader.getDataEncoding(id);
    }

    public Observable<Map<Long, DataEncoding>> getDataEncodingBySpectrumId() {
        return this._dataEncodingReader.getDataEncodingBySpectrumId();
    }

    public Observable<DataEncoding> getSpectrumDataEncoding(long spectrumId) {
        return this._dataEncodingReader.getSpectrumDataEncoding(spectrumId);
    }

    public Observable<RunSliceHeader[]> getRunSliceHeaders(int msLevel) {
        return this._runSliceHeaderReader.getRunSliceHeaders(msLevel);
    }

    public Observable<HashMap<Integer, RunSliceHeader>> getRunSliceHeaderById(int msLevel) {
        return this._runSliceHeaderReader.getRunSliceHeaderById(msLevel);
    }

    public Observable<RunSliceData> getRunSliceData(int runSliceId) {
        return this.observeJobExecution(connection -> this.getRunSliceData(runSliceId, connection));
    }

    public Observable<byte[]> getBoundingBoxData(int bbId) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getBoundingBoxData(bbId, connection));
    }

    public Observable<Long> getBoundingBoxFirstSpectrumId(long spectrumId) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getBoundingBoxFirstSpectrumId(spectrumId, connection));
    }

    public Observable<Float> getBoundingBoxMinMz(int bbId) {
        return this.observeJobExecution(connection -> Float.valueOf(MzDbReaderQueries.getBoundingBoxMinMz(bbId, connection)));
    }

    public Observable<Float> getBoundingBoxMinTime(int bbId) {
        return this.observeJobExecution(connection -> Float.valueOf(MzDbReaderQueries.getBoundingBoxMinTime(bbId, connection)));
    }

    public Observable<Integer> getBoundingBoxMsLevel(int bbId) {
        return this.observeJobExecution(connection -> MzDbReaderQueries.getBoundingBoxMsLevel(bbId, connection));
    }

    public Observable<SpectrumHeader[]> getMs1SpectrumHeaders() {
        return this._spectrumHeaderReader.getMs1SpectrumHeaders();
    }

    public Observable<Map<Long, SpectrumHeader>> getMs1SpectrumHeaderById() {
        return this._spectrumHeaderReader.getMs1SpectrumHeaderById();
    }

    public Observable<SpectrumHeader[]> getMs2SpectrumHeaders() {
        return this._spectrumHeaderReader.getMs2SpectrumHeaders();
    }

    public Observable<Map<Long, SpectrumHeader>> getMs2SpectrumHeaderById() {
        return this._spectrumHeaderReader.getMs2SpectrumHeaderById();
    }

    public Observable<SpectrumHeader[]> getSpectrumHeaders() {
        return this._spectrumHeaderReader.getSpectrumHeaders();
    }

    public Observable<Map<Long, SpectrumHeader>> getSpectrumHeaderById() {
        return this._spectrumHeaderReader.getSpectrumHeaderById();
    }

    public Observable<SpectrumHeader> getSpectrumHeader(long id) {
        return this._spectrumHeaderReader.getSpectrumHeader(id);
    }

    public Observable<SpectrumHeader> getSpectrumHeaderForTime(float time, int msLevel) {
        return this._spectrumHeaderReader.getSpectrumHeaderForTime(time, msLevel);
    }

    public Observable<SpectrumData> getSpectrumData(long spectrumId) {
        return this.observeJobExecution(connection -> this.getSpectrumData(spectrumId, connection));
    }

    public Observable<Spectrum> getSpectrum(long spectrumId) {
        return this.observeJobExecution(connection -> this.getSpectrum(spectrumId, connection));
    }

    public Observable<Peak[]> getSpectrumPeaks(int spectrumId) {
        return this.observeJobExecution(connection -> this.getSpectrumPeaks(spectrumId, connection));
    }

    public Observable<SpectrumSlice[]> getMsSpectrumSlices(double minMz, double maxMz, float minRt, float maxRt) {
        return this.observeJobExecution(connection -> this.getMsSpectrumSlices(minMz, maxMz, minRt, maxRt, connection));
    }

    public Observable<SpectrumSlice[]> getMsnSpectrumSlices(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt) {
        return this.observeJobExecution(connection -> this.getMsnSpectrumSlices(parentMz, minFragMz, maxFragMz, minRt, maxRt, connection));
    }

    public Observable<BoundingBox> getBoundingBoxStream(int msLevel) {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteStatement stmt = connection.prepare("SELECT bounding_box.* FROM bounding_box, spectrum WHERE spectrum.id = bounding_box.first_spectrum_id AND spectrum.ms_level= ?", false);
                stmt.bind(1, msLevel);
                BoundingBoxIterator bbIter = new BoundingBoxIterator(this._spectrumHeaderReader, this._dataEncodingReader, connection, stmt, msLevel);
                SQLiteObservableJob.observeIterator(subscriber, bbIter);
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<Spectrum> getSpectrumStream() {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteObservableJob.observeIterator(subscriber, new SpectrumIterator(this, connection));
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<Spectrum> getSpectrumStream(int msLevel) {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteObservableJob.observeIterator(subscriber, new SpectrumIterator(this, connection, msLevel));
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<RunSlice> getLcMsRunSliceStream() {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteStatement fakeStmt = connection.prepare("SELECT * FROM bounding_box", false);
                while (fakeStmt.step()) {
                }
                fakeStmt.dispose();
                SQLiteObservableJob.observeIterator(subscriber, new LcMsRunSliceIterator(this, connection));
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<RunSlice> getLcMsRunSliceStream(double minRunSliceMz, double maxRunSliceMz) {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                LcMsRunSliceIterator runSliceIter = new LcMsRunSliceIterator(this, connection, minRunSliceMz, maxRunSliceMz);
                SQLiteObservableJob.observeIterator(subscriber, runSliceIter);
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<RunSlice> getLcMsnRunSliceStream(double minParentMz, double maxParentMz) {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteStatement fakeStmt = connection.prepare("SELECT * FROM bounding_box", false);
                while (fakeStmt.step()) {
                }
                fakeStmt.dispose();
                LcMsnRunSliceIterator runSliceIter = new LcMsnRunSliceIterator(this, connection, minParentMz, maxParentMz);
                SQLiteObservableJob.observeIterator(subscriber, runSliceIter);
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<RunSlice> getLcMsnRunSliceStream(double minParentMz, double maxParentMz, double minRunSliceMz, double maxRunSliceMz) {
        return Observable.create(subscriber -> {
            SQLiteJob<Void> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                SQLiteStatement fakeStmt = connection.prepare("SELECT * FROM bounding_box", false);
                while (fakeStmt.step()) {
                }
                fakeStmt.dispose();
                LcMsnRunSliceIterator runSliceIter = new LcMsnRunSliceIterator(this, connection, minParentMz, maxParentMz, minRunSliceMz, maxRunSliceMz);
                SQLiteObservableJob.observeIterator(subscriber, runSliceIter);
                return null;
            });
            this.queue.execute(sqliteJob);
        });
    }

    public Observable<AcquisitionMode> getAcquisitionMode() {
        return this.observeJobExecution(connection -> this.getAcquisitionMode(connection));
    }

    public Observable<IsolationWindow[]> getDIAIsolationWindows() {
        return this.observeJobExecution(connection -> this.getDIAIsolationWindows(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstrumentConfiguration> getInstrumentConfigurations() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            if (this.instrumentConfigs == null) {
                this.instrumentConfigs = new InstrumentConfigReader(this.createBlockingSQLiteConnection()).getInstrumentConfigList();
            }
        }
        return this.instrumentConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Run> getRuns() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            if (this.runs == null) {
                this.runs = new RunReader(this.createBlockingSQLiteConnection()).getRunList();
            }
        }
        return this.runs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sample> getSamples() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            if (this.samples == null) {
                this.samples = new SampleReader(this.createBlockingSQLiteConnection()).getSampleList();
            }
        }
        return this.samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Software> getSoftwareList() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            if (this.softwareList == null) {
                this.softwareList = new SoftwareReader(this.createBlockingSQLiteConnection()).getSoftwareList();
            }
        }
        return this.softwareList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceFile> getSourceFiles() throws SQLiteException {
        Object object = this._blockingConnectionLock;
        synchronized (object) {
            if (this.sourceFiles == null) {
                this.sourceFiles = new SourceFileReader(this.createBlockingSQLiteConnection()).getSourceFileList();
            }
        }
        return this.sourceFiles;
    }

    public Observable<Peak[]> getMsXicInMzRange(double minMz, double maxMz, XicMethod method) {
        return this.observeJobExecution(connection -> this.getMsXicInMzRange(minMz, maxMz, method, connection));
    }

    public Observable<Peak[]> getMsXicInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt, XicMethod method) {
        return this.observeJobExecution(connection -> this.getMsXicInMzRtRanges(minMz, maxMz, minRt, maxRt, method, connection));
    }

    public Observable<Peak[]> getMsXic(double mz, double mzTolInDa, float minRt, float maxRt, XicMethod method) {
        return this.observeJobExecution(connection -> this.getMsXic(mz, mzTolInDa, minRt, maxRt, method, connection));
    }

    public Observable<Peak[]> getMsnXic(double parentMz, double fragmentMz, double fragmentMzTolInDa, float minRt, float maxRt, XicMethod method) {
        return this.observeJobExecution(connection -> this.getMsnXic(parentMz, fragmentMz, fragmentMzTolInDa, minRt, maxRt, method, connection));
    }

    public Observable<Peak[]> getMsPeaksInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt) {
        return this.observeJobExecution(connection -> this.getMsPeaksInMzRtRanges(minMz, maxMz, minRt, maxRt, connection));
    }

    public Observable<Peak[]> getMsnPeaksInMzRtRanges(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt) {
        return this.observeJobExecution(connection -> this.getMsnPeaksInMzRtRanges(parentMz, minFragMz, maxFragMz, minRt, maxRt, connection));
    }
}

