/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.client;

import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class MzdbClient {
    private SerializationWriter m_writer;
    private SerializationReader m_reader;

    public void connect(String host, int port) throws Exception {
        Socket socket = null;
        Object sockDataOut = null;
        Object sockIn = null;
        try {
            socket = new Socket(host, port);
            DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
            this.m_writer = new SerializationWriter(outputStream, 4096);
            this.m_reader = new SerializationReader(socket.getInputStream());
        }
        catch (UnknownHostException e) {
            throw new Exception("hote non atteignable : " + host + "\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new Exception("connection impossible avec : " + host + "\n" + e.getMessage());
        }
    }

    public String createMzdb(String path, AcquisitionMode srcAcqMode) throws Exception {
        this.m_writer.writeInt32(0);
        this.m_writer.writeString(path);
        srcAcqMode.write(this.m_writer);
        this.m_writer.flush();
        return this.readReturnedString();
    }

    public String addMzdbMetaData(MzDBMetaData mzDbMetaData) throws Exception {
        this.m_writer.writeInt32(2);
        mzDbMetaData.write(this.m_writer);
        this.m_writer.flush();
        return this.readReturnedString();
    }

    public String addSpectrum(Spectrum spectrum, DataEncoding dataEncoding) throws Exception {
        this.m_writer.writeInt32(1);
        spectrum.write(this.m_writer);
        dataEncoding.write(this.m_writer);
        this.m_writer.flush();
        return this.readReturnedString();
    }

    public String closedb() throws Exception {
        this.m_writer.writeInt32(3);
        this.m_writer.flush();
        return this.readReturnedString();
    }

    public void exitServer() throws Exception {
        this.m_writer.writeInt32(4);
        this.m_writer.flush();
    }

    private String readReturnedString() throws IOException {
        return this.m_reader.readString();
    }
}

