/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.io.reader.iterator.AbstractRunSliceIterator;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.util.sqlite.ISQLiteStatementConsumer;
import java.io.StreamCorruptedException;
import java.util.Iterator;

public class LcMsRunSliceIterator
extends AbstractRunSliceIterator
implements Iterator<RunSlice> {
    private static String allRunSlicesSqlQuery = "SELECT bounding_box.* FROM bounding_box, run_slice WHERE run_slice.ms_level = ? AND bounding_box.run_slice_id = run_slice.id  ORDER BY run_slice.begin_mz";
    private static String runSlicesSubsetSqlQuery = "SELECT bounding_box.* FROM bounding_box, run_slice WHERE run_slice.ms_level = ? AND bounding_box.run_slice_id = run_slice.id  AND run_slice.end_mz >= ? AND run_slice.begin_mz <= ?ORDER BY run_slice.begin_mz";

    private static ISQLiteStatementConsumer createAllRunSlicesStatementBinder() {
        return new ISQLiteStatementConsumer(){

            @Override
            public void accept(SQLiteStatement stmt) throws SQLiteException {
                stmt.bind(1, 1);
            }
        };
    }

    private static ISQLiteStatementConsumer createRunSlicesSubsetStatementBinder(final double minRunSliceMz, final double maxRunSliceMz) {
        return new ISQLiteStatementConsumer(){

            @Override
            public void accept(SQLiteStatement stmt) throws SQLiteException {
                stmt.bind(1, 1);
                stmt.bind(2, minRunSliceMz);
                stmt.bind(3, maxRunSliceMz);
            }
        };
    }

    public LcMsRunSliceIterator(AbstractMzDbReader mzDbReader, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        super(mzDbReader.getRunSliceHeaderReader(), mzDbReader.getSpectrumHeaderReader(), mzDbReader.getDataEncodingReader(), connection, allRunSlicesSqlQuery, 1, LcMsRunSliceIterator.createAllRunSlicesStatementBinder());
    }

    public LcMsRunSliceIterator(AbstractMzDbReader mzDbReader, SQLiteConnection connection, double minRunSliceMz, double maxRunSliceMz) throws SQLiteException, StreamCorruptedException {
        super(mzDbReader.getRunSliceHeaderReader(), mzDbReader.getSpectrumHeaderReader(), mzDbReader.getDataEncodingReader(), connection, runSlicesSubsetSqlQuery, 1, LcMsRunSliceIterator.createRunSlicesSubsetStatementBinder(minRunSliceMz, maxRunSliceMz));
    }
}

