/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.jdi.request;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ThreadDeathEvent;

/**
 * Request for notification when a thread terminates in the target VM.
 * When an enabled ThreadDeathRequest is satisfied, an
 * {@link EventSet event set} containing a
 * {@link ThreadDeathEvent ThreadDeathEvent}
 * will be placed on the
 * {@link EventQueue EventQueue}.
 * The collection of existing ThreadDeathRequests is
 * managed by the {@link EventRequestManager}
 *
 * @see ThreadDeathEvent
 * @see EventQueue
 * @see EventRequestManager
 *
 * @author Robert Field
 * @since  1.3
 */
public interface ThreadDeathRequest extends EventRequest {

    /**
     * Restricts the events generated by this request to those in
     * the given thread.
     * @param thread the thread to filter on.
     * @throws InvalidRequestStateException if this request is currently
     * enabled or has been deleted.
     * Filters may be added only to disabled requests.
     */
    void addThreadFilter(ThreadReference thread);
}
